/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.dropwizard;

import java.util.Optional;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

class RegexContainer<T> {
    private final Pattern regex;
    private final T content;

    RegexContainer(Pattern regex, T content) {
        this.regex = regex;
        this.content = content;
    }

    static <T> Optional<RegexContainer<T>> checkAndCreate(String maybeRegex, T content) {
        if (maybeRegex.startsWith("/") && maybeRegex.endsWith("/")) {
            try {
                Pattern regex = Pattern.compile(maybeRegex.substring(1, maybeRegex.length() - 1));
                return Optional.of(new RegexContainer<T>(regex, content));
            }
            catch (PatternSyntaxException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    Optional<T> match(String metricName) {
        if (this.regex.matcher(metricName).find()) {
            return Optional.of(this.content);
        }
        return Optional.empty();
    }
}

