/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.dropwizard;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricRegistryListener;
import com.codahale.metrics.Timer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.hawkular.metrics.client.common.http.HawkularHttpClient;
import org.hawkular.metrics.client.common.http.HawkularJson;
import org.hawkular.metrics.dropwizard.MetricPart;
import org.hawkular.metrics.dropwizard.MetricsDecomposer;
import org.hawkular.metrics.dropwizard.RegexContainer;

class MetricsTagger
implements MetricRegistryListener {
    static final String METRIC_TYPE_COUNTER = "counters";
    static final String METRIC_TYPE_GAUGE = "gauges";
    private final Optional<String> prefix;
    private final Map<String, String> globalTags;
    private final Map<String, Map<String, String>> perMetricTags;
    private final Collection<RegexContainer<Map<String, String>>> regexTags;
    private final boolean enableTagComposition;
    private final HawkularHttpClient hawkularClient;
    private final MetricFilter metricFilter;
    private final MetricsDecomposer metricsDecomposer;

    MetricsTagger(Optional<String> prefix, Map<String, String> globalTags, Map<String, Map<String, String>> perMetricTags, Collection<RegexContainer<Map<String, String>>> regexTags, boolean enableTagComposition, MetricsDecomposer metricsDecomposer, HawkularHttpClient hawkularClient, MetricRegistry registry, MetricFilter metricFilter) {
        this.prefix = prefix;
        this.globalTags = new HashMap<String, String>(globalTags);
        this.perMetricTags = new HashMap<String, Map<String, String>>(perMetricTags);
        this.regexTags = new ArrayList<RegexContainer<Map<String, String>>>(regexTags);
        this.enableTagComposition = enableTagComposition;
        this.metricsDecomposer = metricsDecomposer;
        this.hawkularClient = hawkularClient;
        this.metricFilter = metricFilter;
        registry.getGauges().forEach(this::onGaugeAdded);
        registry.getCounters().forEach(this::onCounterAdded);
        registry.getHistograms().forEach(this::onHistogramAdded);
        registry.getTimers().forEach(this::onTimerAdded);
        registry.getMeters().forEach(this::onMeterAdded);
        registry.addListener((MetricRegistryListener)this);
    }

    private void tagMetric(String baseName, MetricPart<?, ?> metricPart, String tagKey) {
        String nameWithSuffix = metricPart.getMetricNameWithSuffix(baseName);
        String fullName = this.prefix.map(p -> p + nameWithSuffix).orElse(nameWithSuffix);
        LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>(this.globalTags);
        if (this.enableTagComposition) {
            tags.put(tagKey, metricPart.getSuffix());
        }
        tags.putAll(this.getTagsForMetrics(baseName));
        tags.putAll(this.getTagsForMetrics(nameWithSuffix));
        if (!tags.isEmpty()) {
            this.hawkularClient.putTags(metricPart.getMetricType(), fullName, HawkularJson.tagsToString(tags));
        }
    }

    private void tagMetric(String metricType, String baseName) {
        String fullName = this.prefix.map(p -> p + baseName).orElse(baseName);
        LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>(this.globalTags);
        tags.putAll(this.getTagsForMetrics(baseName));
        if (!tags.isEmpty()) {
            this.hawkularClient.putTags(metricType, fullName, HawkularJson.tagsToString(tags));
        }
    }

    Map<String, String> getTagsForMetrics(String name) {
        LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
        this.regexTags.forEach(reg -> reg.match(name).ifPresent(tags::putAll));
        if (this.perMetricTags.containsKey(name)) {
            tags.putAll(this.perMetricTags.get(name));
        }
        return tags;
    }

    public void onGaugeAdded(String name, Gauge<?> gauge) {
        if (this.metricFilter.matches(name, gauge)) {
            this.tagMetric(METRIC_TYPE_GAUGE, name);
        }
    }

    public void onGaugeRemoved(String name) {
    }

    public void onCounterAdded(String name, Counter counter) {
        if (this.metricFilter.matches(name, (Metric)counter)) {
            this.tagMetric(METRIC_TYPE_COUNTER, name);
        }
    }

    public void onCounterRemoved(String name) {
    }

    public void onHistogramAdded(String name, Histogram histogram) {
        if (this.metricFilter.matches(name, (Metric)histogram)) {
            MetricsDecomposer.PartsStreamer streamer = this.metricsDecomposer.streamParts(name);
            streamer.countings().forEach(metricPart -> this.tagMetric(name, (MetricPart<?, ?>)metricPart, "histogram"));
            streamer.samplings().forEach(metricPart -> this.tagMetric(name, (MetricPart<?, ?>)metricPart, "histogram"));
        }
    }

    public void onHistogramRemoved(String name) {
    }

    public void onMeterAdded(String name, Meter meter) {
        if (this.metricFilter.matches(name, (Metric)meter)) {
            MetricsDecomposer.PartsStreamer streamer = this.metricsDecomposer.streamParts(name);
            streamer.countings().forEach(metricPart -> this.tagMetric(name, (MetricPart<?, ?>)metricPart, "meter"));
            streamer.metered().forEach(metricPart -> this.tagMetric(name, (MetricPart<?, ?>)metricPart, "meter"));
        }
    }

    public void onMeterRemoved(String name) {
    }

    public void onTimerAdded(String name, Timer timer) {
        if (this.metricFilter.matches(name, (Metric)timer)) {
            MetricsDecomposer.PartsStreamer streamer = this.metricsDecomposer.streamParts(name);
            streamer.countings().forEach(metricPart -> this.tagMetric(name, (MetricPart<?, ?>)metricPart, "timer"));
            streamer.metered().forEach(metricPart -> this.tagMetric(name, (MetricPart<?, ?>)metricPart, "timer"));
            streamer.samplings().forEach(metricPart -> this.tagMetric(name, (MetricPart<?, ?>)metricPart, "timer"));
        }
    }

    public void onTimerRemoved(String name) {
    }

    Map<String, String> getGlobalTags() {
        return this.globalTags;
    }

    boolean isEnableTagComposition() {
        return this.enableTagComposition;
    }

    void addTag(String m, String key, String value) {
        this.perMetricTags.computeIfAbsent(m, k -> new HashMap()).put(key, value);
    }
}

