/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.alerter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hawkular.metrics.alerter.Expression;

/*
 * Exception performing whole class analysis ignored.
 */
public class Expression {
    private static final Pattern SYNTAX = Pattern.compile("(?i)(metric|tag):(\\d+)m?+:(\\w+)\\((\\S+)?\\s*([<>]=?+)\\s*(\\S+)\\)(?:,\\s*(\\d+)m?+)?+");
    private Target target;
    private Func func;
    private String metric;
    private Op op;
    private Double threshold;
    private Integer interval;
    private Integer period;

    public Expression(String expression) {
        Matcher matcher = SYNTAX.matcher(expression);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid expression syntax. Must match: " + SYNTAX.pattern());
        }
        this.target = (Target)Expression.valueOfIgnoreCase(Target.class, (String)matcher.group(1));
        this.interval = Integer.parseInt(matcher.group(2));
        this.func = (Func)Expression.valueOfIgnoreCase(Func.class, (String)matcher.group(3));
        this.metric = matcher.group(4);
        String sOp = matcher.group(5);
        if (">".equals(sOp)) {
            this.op = Op.GT;
        } else if ("<".equals(sOp)) {
            this.op = Op.LT;
        } else if (">=".equals(sOp)) {
            this.op = Op.GTE;
        } else if ("<=".equals(sOp)) {
            this.op = Op.LTE;
        } else {
            throw new IllegalArgumentException("unknown op " + sOp);
        }
        this.threshold = Double.parseDouble(matcher.group(6));
        String sPeriod = matcher.group(7);
        if (sPeriod != null) {
            this.period = Integer.parseInt(sPeriod);
        }
        if (null == this.period) {
            throw new IllegalArgumentException("Invalid expression syntax. Function " + this.func.name() + " requires a time period");
        }
        if (Target.Tag == this.target) {
            throw new IllegalArgumentException("Invalid expression syntax. Function " + this.func.name() + " does not yet support Tag targets");
        }
    }

    public static <T extends Enum<?>> T valueOfIgnoreCase(Class<T> clazz, String s) {
        for (Enum t : (Enum[])clazz.getEnumConstants()) {
            if (!t.name().equalsIgnoreCase(s)) continue;
            return (T)t;
        }
        throw new IllegalArgumentException(s);
    }

    public Target getTarget() {
        return this.target;
    }

    public Integer getInterval() {
        return this.interval;
    }

    public Func getFunc() {
        return this.func;
    }

    public String getMetric() {
        return this.metric;
    }

    public Op getOp() {
        return this.op;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public Integer getPeriod() {
        return this.period;
    }

    public boolean isTrue(Double value) {
        if (null == value || value.isNaN()) {
            return false;
        }
        switch (1.$SwitchMap$org$hawkular$metrics$alerter$Expression$Op[this.op.ordinal()]) {
            case 1: {
                return value > this.threshold;
            }
            case 2: {
                return value >= this.threshold;
            }
            case 3: {
                return value < this.threshold;
            }
            case 4: {
                return value <= this.threshold;
            }
        }
        return false;
    }

    public String toString() {
        String s = this.target + ":" + this.interval + "m:" + this.func + "(" + this.metric + "" + this.op + "" + this.threshold + ")";
        if (this.period > 0) {
            s = s + "," + this.period + "m";
        }
        return s;
    }
}

