/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.alerter;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.inject.Inject;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.condition.ExternalCondition;
import org.hawkular.alerts.api.model.trigger.Trigger;
import org.hawkular.alerts.api.services.AlertsService;
import org.hawkular.alerts.api.services.DefinitionsEvent;
import org.hawkular.alerts.api.services.DefinitionsListener;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.hawkular.metrics.alerter.Expression;
import org.hawkular.metrics.alerter.ExpressionManager;
import org.hawkular.metrics.core.service.MetricsService;
import org.jboss.logging.Logger;

@Startup
@Singleton
public class ExpressionManager {
    private final Logger log = Logger.getLogger(ExpressionManager.class);
    private static final String TAG_NAME = "HawkularMetrics";
    private static final String TAG_VALUE = "MetricsCondition";
    private static final long DAY = 1440000L;
    private static final long WEEK = 10080000L;
    private static final Integer THREAD_POOL_SIZE = 20;
    ScheduledThreadPoolExecutor expressionExecutor;
    Map<ExternalCondition, ScheduledFuture<?>> expressionFutures = new HashMap();
    @Inject
    private MetricsService metrics;
    @Inject
    private DefinitionsService definitions;
    @Inject
    private AlertsService alerts;

    @PostConstruct
    public void init() {
        this.log.debug((Object)"Initializing Hawkular Alerts-Metrics Manager...");
        this.expressionExecutor = new ScheduledThreadPoolExecutor(THREAD_POOL_SIZE);
        this.refresh();
        this.log.debug((Object)"Registering Trigger UPDATE/REMOVE listener");
        this.definitions.registerListener((DefinitionsListener)new /* Unavailable Anonymous Inner Class!! */, DefinitionsEvent.Type.TRIGGER_UPDATE, new DefinitionsEvent.Type[]{DefinitionsEvent.Type.TRIGGER_REMOVE});
    }

    @PreDestroy
    public void shutdown() {
        this.log.debug((Object)"Shutting down Hawkular Alerts-Metrics Manager...");
        if (null != this.expressionFutures) {
            this.expressionFutures.values().forEach(f -> f.cancel(true));
        }
        if (null != this.expressionExecutor) {
            this.expressionExecutor.shutdown();
        }
    }

    private void refresh() {
        this.log.debug((Object)"Refreshing External Metrics Triggers!");
        try {
            HashSet<ExternalCondition> activeConditions = new HashSet<ExternalCondition>();
            Collection triggers = this.definitions.getAllTriggersByTag(TAG_NAME, TAG_VALUE);
            this.log.debug((Object)("Found [" + triggers.size() + "] External Metrics Triggers!"));
            Collection conditions = null;
            for (Trigger trigger : triggers) {
                block13: {
                    try {
                        if (!trigger.isEnabled()) break block13;
                        conditions = this.definitions.getTriggerConditions(trigger.getTenantId(), trigger.getId(), null);
                        this.log.debug((Object)("Checking [" + conditions.size() + "] Conditions for enabled trigger [" + trigger.getName() + "]!"));
                    }
                    catch (Exception e) {
                        this.log.error((Object)("Failed to fetch Conditions when scheduling metrics conditions for " + trigger), (Throwable)e);
                        continue;
                    }
                }
                if (null == conditions) continue;
                for (Condition condition : conditions) {
                    ExternalCondition externalCondition;
                    if (!(condition instanceof ExternalCondition) || !TAG_NAME.equals((externalCondition = (ExternalCondition)condition).getAlerterId())) continue;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Found Metrics ExternalCondition! " + externalCondition));
                    }
                    activeConditions.add(externalCondition);
                    if (this.expressionFutures.containsKey(externalCondition)) {
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug((Object)("Skipping, already evaluating: " + externalCondition));
                        continue;
                    }
                    try {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Adding runner for: " + externalCondition));
                        }
                        Expression expression = new Expression(externalCondition.getExpression());
                        ExpressionRunner runner = new ExpressionRunner(this.metrics, this.alerts, trigger, externalCondition, expression);
                        this.expressionFutures.put(externalCondition, this.expressionExecutor.scheduleAtFixedRate((Runnable)runner, 0L, expression.getInterval().intValue(), TimeUnit.MINUTES));
                    }
                    catch (Exception e) {
                        this.log.error((Object)("Failed to schedule expression for metrics condition " + externalCondition), (Throwable)e);
                    }
                }
            }
            HashSet<ExternalCondition> temp = new HashSet<ExternalCondition>();
            for (Map.Entry me : this.expressionFutures.entrySet()) {
                ExternalCondition ec = (ExternalCondition)me.getKey();
                if (activeConditions.contains(ec)) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Canceling evaluation of obsolete External Metric Condition " + ec));
                }
                ((ScheduledFuture)me.getValue()).cancel(true);
                temp.add(ec);
            }
            this.expressionFutures.keySet().removeAll(temp);
            temp.clear();
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to fetch Triggers for scheduling metrics conditions.", (Throwable)e);
        }
    }

    static /* synthetic */ void access$000(ExpressionManager x0) {
        x0.refresh();
    }
}

