/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.alerter;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.inject.Inject;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.condition.ExternalCondition;
import org.hawkular.alerts.api.model.trigger.Trigger;
import org.hawkular.alerts.api.services.AlertsService;
import org.hawkular.alerts.api.services.DefinitionsEvent;
import org.hawkular.alerts.api.services.DefinitionsListener;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.hawkular.metrics.alerter.Expression;
import org.hawkular.metrics.alerter.ExpressionManager;
import org.hawkular.metrics.core.service.MetricsService;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.logging.Logger;

@Startup
@Singleton
public class ExpressionManager {
    private final Logger log = Logger.getLogger(ExpressionManager.class);
    private static final String TAG_NAME = "HawkularMetrics";
    private static final String TAG_VALUE = "MetricsCondition";
    private static final long DAY = 1440000L;
    private static final long WEEK = 10080000L;
    private static final Integer THREAD_POOL_SIZE = 20;
    ScheduledThreadPoolExecutor expressionExecutor;
    Map<ExternalCondition, ScheduledFuture<?>> expressionFutures = new HashMap();
    private boolean distributed = false;
    private boolean coordinator = false;
    private TopologyChangeListener topologyChangeListener = null;
    private DefinitionsListener definitionsListener = null;
    @Inject
    private MetricsService metrics;
    @Inject
    private DefinitionsService definitions;
    @Inject
    private AlertsService alerts;
    @Resource(lookup="java:jboss/infinispan/container/hawkular-alerts")
    private EmbeddedCacheManager cacheManager;

    @PostConstruct
    public void init() {
        boolean bl = this.distributed = this.cacheManager.getTransport() != null;
        if (this.distributed) {
            this.topologyChangeListener = new TopologyChangeListener(this);
            this.cacheManager.addListener((Object)this.topologyChangeListener);
        }
        this.processTopologyChange();
    }

    private void processTopologyChange() {
        boolean currentCoordinator = this.coordinator;
        boolean bl = this.coordinator = this.distributed ? this.cacheManager.isCoordinator() : true;
        if (this.coordinator && !currentCoordinator) {
            this.start();
        } else if (!this.coordinator && currentCoordinator) {
            this.stop();
        }
    }

    public void start() {
        this.log.infof("Starting Hawkular Metrics External Alerter, distributed=%s", (Object)this.distributed);
        this.expressionExecutor = new ScheduledThreadPoolExecutor(THREAD_POOL_SIZE);
        this.refresh();
        if (null == this.definitionsListener) {
            this.log.info((Object)"Registering Trigger UPDATE/REMOVE listener");
            this.definitionsListener = new /* Unavailable Anonymous Inner Class!! */;
            this.definitions.registerListener(this.definitionsListener, DefinitionsEvent.Type.TRIGGER_UPDATE, new DefinitionsEvent.Type[]{DefinitionsEvent.Type.TRIGGER_REMOVE});
        }
    }

    @PreDestroy
    public void shutdown() {
        if (this.coordinator) {
            this.stop();
        }
        if (this.distributed) {
            this.cacheManager.removeListener((Object)this.topologyChangeListener);
            this.cacheManager.stop();
        }
    }

    public void stop() {
        this.log.infof("Stopping Hawkular Metrics External Alerter, distributed=%s", (Object)this.distributed);
        if (null != this.expressionFutures) {
            this.expressionFutures.values().forEach(f -> f.cancel(true));
        }
        if (null != this.expressionExecutor) {
            this.expressionExecutor.shutdown();
            this.expressionExecutor = null;
        }
    }

    private void refresh() {
        this.log.debug((Object)"Refreshing External Metrics Triggers!");
        try {
            HashSet<ExternalCondition> activeConditions = new HashSet<ExternalCondition>();
            Collection triggers = this.definitions.getAllTriggersByTag(TAG_NAME, TAG_VALUE);
            this.log.debug((Object)("Found [" + triggers.size() + "] External Metrics Triggers!"));
            Collection conditions = null;
            for (Trigger trigger : triggers) {
                block13: {
                    try {
                        if (!trigger.isEnabled()) break block13;
                        conditions = this.definitions.getTriggerConditions(trigger.getTenantId(), trigger.getId(), null);
                        this.log.debug((Object)("Checking [" + conditions.size() + "] Conditions for enabled trigger [" + trigger.getName() + "]!"));
                    }
                    catch (Exception e) {
                        this.log.error((Object)("Failed to fetch Conditions when scheduling metrics conditions for " + trigger), (Throwable)e);
                        continue;
                    }
                }
                if (null == conditions) continue;
                for (Condition condition : conditions) {
                    ExternalCondition externalCondition;
                    if (!(condition instanceof ExternalCondition) || !TAG_NAME.equals((externalCondition = (ExternalCondition)condition).getAlerterId())) continue;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Found Metrics ExternalCondition! " + externalCondition));
                    }
                    activeConditions.add(externalCondition);
                    if (this.expressionFutures.containsKey(externalCondition)) {
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug((Object)("Skipping, already evaluating: " + externalCondition));
                        continue;
                    }
                    try {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Adding runner for: " + externalCondition));
                        }
                        Expression expression = new Expression(externalCondition.getExpression());
                        ExpressionRunner runner = new ExpressionRunner(this.metrics, this.alerts, trigger, externalCondition, expression);
                        this.expressionFutures.put(externalCondition, this.expressionExecutor.scheduleAtFixedRate((Runnable)runner, 0L, expression.getInterval().intValue(), TimeUnit.MINUTES));
                    }
                    catch (Exception e) {
                        this.log.error((Object)("Failed to schedule expression for metrics condition " + externalCondition), (Throwable)e);
                    }
                }
            }
            HashSet<ExternalCondition> temp = new HashSet<ExternalCondition>();
            for (Map.Entry me : this.expressionFutures.entrySet()) {
                ExternalCondition ec = (ExternalCondition)me.getKey();
                if (activeConditions.contains(ec)) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Canceling evaluation of obsolete External Metric Condition " + ec));
                }
                ((ScheduledFuture)me.getValue()).cancel(true);
                temp.add(ec);
            }
            this.expressionFutures.keySet().removeAll(temp);
            temp.clear();
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to fetch Triggers for scheduling metrics conditions.", (Throwable)e);
        }
    }

    static /* synthetic */ void access$000(ExpressionManager x0) {
        x0.processTopologyChange();
    }

    static /* synthetic */ boolean access$100(ExpressionManager x0) {
        return x0.coordinator;
    }

    static /* synthetic */ void access$200(ExpressionManager x0) {
        x0.refresh();
    }
}

