/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.alerter;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.hawkular.metrics.alerter.ConditionEvaluator;
import org.hawkular.metrics.alerter.ConditionExpression;
import org.hawkular.metrics.model.MetricType;
import org.hawkular.metrics.model.param.Duration;
import org.jboss.logging.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class ConditionExpression {
    private static final Logger log = Logger.getLogger(ConditionExpression.class);
    public static final String DEFAULT_FREQUENCY = "10mn";
    @JsonInclude
    private List<Query> queries;
    @JsonInclude
    private String frequency;
    @JsonIgnore
    private Duration frequencyDuration;
    @JsonInclude
    private EvalType evalType;
    @JsonInclude
    private String eval;
    @JsonIgnore
    private ConditionEvaluator evaluator;
    private static final MetricType<?>[] ALL_TYPES = new MetricType[]{MetricType.AVAILABILITY, MetricType.COUNTER, MetricType.COUNTER_RATE, MetricType.GAUGE, MetricType.GAUGE_RATE};
    private static final MetricType<?>[] NUMERIC_TYPES = new MetricType[]{MetricType.COUNTER, MetricType.COUNTER_RATE, MetricType.GAUGE, MetricType.GAUGE_RATE};

    public ConditionExpression() {
        this((List)null, null, null, null);
    }

    public ConditionExpression(Query query, String frequency, String eval) {
        this(Collections.singletonList(query), frequency, null, eval);
    }

    public ConditionExpression(Query query, String frequency, EvalType evalType, String eval) {
        this(Collections.singletonList(query), frequency, evalType, eval);
    }

    public ConditionExpression(List<Query> queries, String frequency, String eval) {
        this(queries, frequency, null, eval);
    }

    public ConditionExpression(List<Query> queries, String frequency, EvalType evalType, String eval) {
        this.setQueries(queries);
        this.setFrequency(frequency);
        this.setEvalType(evalType);
        this.setEval(eval);
    }

    public List<Query> getQueries() {
        if (null == this.queries) {
            this.queries = new ArrayList();
        }
        return this.queries;
    }

    public void setQueries(List<Query> queries) {
        this.queries = null == queries ? new ArrayList() : queries;
        this.validateQueries();
    }

    private void validateQueries() {
        Set queryNames = this.queries.stream().map(Query::getName).collect(Collectors.toSet());
        if (this.queries.size() >= 2 && queryNames.size() < this.queries.size()) {
            throw new IllegalArgumentException("Each query requires a unique name, duplicate found: " + this.queries);
        }
        if (null == this.evaluator) {
            return;
        }
        for (ConditionEvaluator.QueryFunc qf : this.evaluator.getQueryVars().values()) {
            String name = qf.getQueryName();
            String func = qf.getFunction();
            if (!queryNames.contains(name)) {
                throw new IllegalArgumentException("Eval [" + this.eval + "] uses undefined query [" + name + "]");
            }
            for (Query q : this.queries) {
                if (func.startsWith("%")) {
                    try {
                        this.evaluator.funcToPercentile(func, q.getMetricsPercentiles());
                        continue;
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Eval [" + this.eval + "] uses undefined func [" + func + "] in query " + q);
                    }
                }
                if (Function.valueOf((String)func).isSupported(q.getMetricsType())) continue;
                throw new IllegalArgumentException("Eval [" + this.eval + "] uses unsupported func [" + func + "] for query metric type: " + q);
            }
        }
    }

    public String getFrequency() {
        return this.frequency;
    }

    public void setFrequency(String frequency) {
        this.frequency = null == frequency ? "10mn" : frequency;
        this.frequencyDuration = new Duration(this.frequency);
        if (this.frequencyDuration.toMillis() < 60000L) {
            this.frequency = "1mn";
            this.frequencyDuration = new Duration(frequency);
        }
    }

    public Duration getFrequencyDuration() {
        return this.frequencyDuration;
    }

    public EvalType getEvalType() {
        return this.evalType;
    }

    public void setEvalType(EvalType evalType) {
        this.evalType = null == evalType ? EvalType.ALL : evalType;
    }

    public String getEval() {
        return this.eval;
    }

    public void setEval(String eval) {
        this.eval = eval;
        this.evaluator = null == eval ? null : new ConditionEvaluator(eval);
    }

    public ConditionEvaluator getEvaluator() {
        return this.evaluator;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.eval == null ? 0 : this.eval.hashCode());
        result = 31 * result + (this.frequency == null ? 0 : this.frequency.hashCode());
        result = 31 * result + (this.queries == null ? 0 : this.queries.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConditionExpression other = (ConditionExpression)obj;
        if (this.eval == null ? other.eval != null : !this.eval.equals(other.eval)) {
            return false;
        }
        if (this.frequency == null ? other.frequency != null : !this.frequency.equals(other.frequency)) {
            return false;
        }
        return !(this.queries == null ? other.queries != null : !this.queries.equals(other.queries));
    }

    public String toString() {
        return "MetricsCondition [queries=" + this.queries + ", frequency=" + this.frequency + ", eval=" + this.eval + "]";
    }

    public static ConditionExpression toObject(String json) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (ConditionExpression)mapper.readValue(json, ConditionExpression.class);
        }
        catch (Exception e) {
            log.error((Object)"Failed to convert JSON to MetricsCondition", (Throwable)e);
            return null;
        }
    }

    public String toJson() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (Exception e) {
            log.error((Object)"Failed to convert MetricsCondition to JSON", (Throwable)e);
            return null;
        }
    }

    static /* synthetic */ MetricType[] access$000() {
        return NUMERIC_TYPES;
    }

    static /* synthetic */ MetricType[] access$100() {
        return ALL_TYPES;
    }
}

