/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.alerter;

import com.udojava.evalex.Expression;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hawkular.metrics.alerter.ConditionExpression;
import org.hawkular.metrics.model.AvailabilityBucketPoint;
import org.hawkular.metrics.model.BucketPoint;
import org.hawkular.metrics.model.NumericBucketPoint;
import org.hawkular.metrics.model.Percentile;
import org.jboss.logging.Logger;

public class ConditionEvaluator {
    private static final Logger log = Logger.getLogger(ConditionEvaluator.class);
    private static final Pattern PATTERN_QUERY_FUNC = Pattern.compile("q\\((.*?),\\s*(.*?)\\)");
    private static final Pattern PATTERN_QUERY_VAR = Pattern.compile("q\\(.*?\\)");
    private Map<String, QueryFunc> queryVars;
    private String eval;
    private Expression expression;

    public ConditionEvaluator(String eval) {
        this.eval = eval;
        this.queryVars = new HashMap<String, QueryFunc>();
        this.expression = new Expression(this.replaceQueriesWithVariables(eval));
        log.debugf("eval [%s] produced [%s] with variables %s", (Object)eval, (Object)this.expression.getOriginalExpression(), this.queryVars);
        try {
            for (String var : this.queryVars.keySet()) {
                this.expression.setVariable(var, "1");
            }
            this.expression.eval();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid eval expression [" + eval + "]: " + e.getMessage());
        }
    }

    public String getEval() {
        return this.eval;
    }

    public Map<String, String> prepare(Map<String, BucketPoint> queryMap) throws IllegalArgumentException {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, QueryFunc> entry : this.queryVars.entrySet()) {
            String var = entry.getKey();
            QueryFunc queryFunc = entry.getValue();
            BucketPoint bucketPoint = queryMap.get(queryFunc.getQueryName());
            if (null == bucketPoint) {
                throw new IllegalArgumentException("No data found for query name [" + queryFunc.getQueryName() + "]");
            }
            BigDecimal value = null;
            try {
                value = BigDecimal.valueOf(this.getValue(queryFunc.getFunction(), bucketPoint));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Could not prepare evaluation query [" + queryFunc.getQueryName() + "]: " + e.getMessage());
            }
            this.expression.setVariable(var, value);
            result.put(queryFunc.getCanonical(), value.toString());
        }
        return result;
    }

    public boolean evaluate() {
        return this.expression.eval() != BigDecimal.ZERO;
    }

    public boolean prepareAndEvaluate(Map<String, BucketPoint> queryMap) {
        this.prepare(queryMap);
        return this.expression.eval() != BigDecimal.ZERO;
    }

    private double getValue(String func, BucketPoint bucketPoint) throws Exception {
        if (bucketPoint instanceof AvailabilityBucketPoint) {
            return this.getAvailabilityValue(func, (AvailabilityBucketPoint)bucketPoint);
        }
        return this.getNumericValue(func, (NumericBucketPoint)bucketPoint);
    }

    private double getNumericValue(String func, NumericBucketPoint data) {
        if (null == data || null == data.getSamples() || 0 == data.getSamples()) {
            throw new IllegalArgumentException("NumericBucketPoint has no samples");
        }
        if (func.startsWith("%")) {
            return this.funcToPercentile(func, data.getPercentiles()).getValue();
        }
        try {
            switch (ConditionExpression.Function.valueOf(func)) {
                case avg: {
                    return data.getAvg();
                }
                case max: {
                    return data.getMax();
                }
                case median: {
                    return data.getMedian();
                }
                case min: {
                    return data.getMin();
                }
                case samples: {
                    return (double)data.getSamples().intValue() * 1.0;
                }
                case sum: {
                    return data.getSum();
                }
            }
            throw new IllegalArgumentException("Unexpected func [" + func + "]");
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid value for func [" + func + "] in " + data.toString());
        }
    }

    private double getAvailabilityValue(String func, AvailabilityBucketPoint data) {
        if (null == data || null == data.getSamples() || 0L == data.getSamples()) {
            throw new IllegalArgumentException("AvailabilityBucketPoint has no samples");
        }
        try {
            switch (ConditionExpression.Function.valueOf(func)) {
                case notUpCount: {
                    return data.getNotUpCount().doubleValue();
                }
                case notUpDuration: {
                    return data.getNotUpDuration().doubleValue();
                }
                case upCount: {
                    return data.getUpCount().doubleValue();
                }
                case uptimeRatio: {
                    return data.getUptimeRatio();
                }
                case samples: {
                    return (double)data.getSamples().longValue() * 1.0;
                }
            }
            throw new IllegalArgumentException("Unexpected func [" + func + "]");
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid value for func [" + func + "] in " + data.toString());
        }
    }

    Percentile funcToPercentile(String func, List<Percentile> percentiles) {
        String quantile = func.substring(1);
        for (Percentile p : percentiles) {
            if (!p.getOriginalQuantile().equals(quantile)) continue;
            return p;
        }
        throw new IllegalArgumentException("Failed to find Percentile for [" + func + "] in " + percentiles);
    }

    public Map<String, QueryFunc> getQueryVars() {
        return this.queryVars;
    }

    public Expression getExpression() {
        return this.expression;
    }

    private String replaceQueriesWithVariables(String eval) {
        if (null == this.queryVars) {
            this.queryVars = new HashMap<String, QueryFunc>();
        }
        this.queryVars.clear();
        ArrayList<String> queries = new ArrayList<String>();
        Matcher m = PATTERN_QUERY_VAR.matcher(eval);
        while (m.find()) {
            queries.add(m.group());
        }
        int varNum = 0;
        for (String q : queries) {
            String var = null;
            QueryFunc qf = new QueryFunc(q);
            if (this.queryVars.containsValue(qf)) {
                for (Map.Entry<String, QueryFunc> e : this.queryVars.entrySet()) {
                    if (!e.getValue().equals(qf)) continue;
                    var = e.getKey();
                    break;
                }
            } else {
                var = "q" + varNum++;
                this.queryVars.put(var, qf);
            }
            eval = eval.replaceFirst("q\\(.*?\\)", var);
        }
        return eval;
    }

    static class QueryFunc {
        private String queryName;
        private String function;
        private String canonical;

        public QueryFunc(String queryName, String function) {
            this.queryName = queryName.trim();
            this.function = function.trim();
        }

        public QueryFunc(String query) {
            Matcher m = PATTERN_QUERY_FUNC.matcher(query);
            if (!m.matches() || m.groupCount() != 2) {
                throw new IllegalArgumentException("Query segment [" + query + "] failed to parse. Groups=[" + m.groupCount() + "]");
            }
            this.queryName = m.group(1).trim();
            this.function = m.group(2).trim();
        }

        public String getQueryName() {
            return this.queryName;
        }

        public String getFunction() {
            return this.function;
        }

        public String getCanonical() {
            if (null == this.canonical) {
                this.canonical = "q(" + this.queryName + "," + this.function + ")";
            }
            return this.canonical;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.function == null ? 0 : this.function.hashCode());
            result = 31 * result + (this.queryName == null ? 0 : this.queryName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            QueryFunc other = (QueryFunc)obj;
            if (this.function == null ? other.function != null : !this.function.equals(other.function)) {
                return false;
            }
            return !(this.queryName == null ? other.queryName != null : !this.queryName.equals(other.queryName));
        }

        public String toString() {
            return "QueryFunc [queryName=" + this.queryName + ", function=" + this.function + "]";
        }
    }
}

