/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.alerter;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.inject.Inject;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.condition.ExternalCondition;
import org.hawkular.alerts.api.model.trigger.Trigger;
import org.hawkular.alerts.api.services.AlertsService;
import org.hawkular.alerts.api.services.DefinitionsEvent;
import org.hawkular.alerts.api.services.DefinitionsListener;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.hawkular.metrics.alerter.ConditionExpression;
import org.hawkular.metrics.alerter.ConditionManager;
import org.hawkular.metrics.core.service.MetricsService;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.logging.Logger;

@Startup
@Singleton
public class ConditionManager {
    private final Logger log = Logger.getLogger(ConditionManager.class);
    private static final String TAG_EXTERNAL_CONDITION_NAME = "HawkularMetrics";
    private static final String TAG_EXTERNAL_CONDITION_VALUE = "MetricsCondition";
    private static final Integer THREAD_POOL_SIZE;
    private static final String THREAD_POOL_SIZE_DEFAULT = "20";
    private static final String THREAD_POOL_SIZE_PROPERTY = "hawkular-metrics.alerter.condition-pool-size";
    ScheduledThreadPoolExecutor expressionExecutor;
    Map<ExternalCondition, ScheduledFuture<?>> expressionFutures = new HashMap();
    private boolean distributed = false;
    private boolean coordinator = false;
    private TopologyChangeListener topologyChangeListener = null;
    private DefinitionsListener definitionsListener = null;
    @Inject
    private MetricsService metrics;
    @Inject
    private DefinitionsService definitions;
    @Inject
    private AlertsService alerts;
    @Resource(lookup="java:jboss/infinispan/container/hawkular-alerts")
    private EmbeddedCacheManager cacheManager;

    @PostConstruct
    public void init() {
        boolean bl = this.distributed = this.cacheManager.getTransport() != null;
        if (this.distributed) {
            this.topologyChangeListener = new TopologyChangeListener(this);
            this.cacheManager.addListener((Object)this.topologyChangeListener);
        }
        this.processTopologyChange();
    }

    private void processTopologyChange() {
        boolean currentCoordinator = this.coordinator;
        boolean bl = this.coordinator = this.distributed ? this.cacheManager.isCoordinator() : true;
        if (this.coordinator && !currentCoordinator) {
            this.start();
        } else if (!this.coordinator && currentCoordinator) {
            this.stop();
        }
    }

    public void start() {
        this.log.infof("Starting Hawkular Metrics External Alerter, distributed=%s", (Object)this.distributed);
        this.expressionExecutor = new ScheduledThreadPoolExecutor(THREAD_POOL_SIZE);
        this.refresh();
        if (null == this.definitionsListener) {
            this.log.info((Object)"Registering Trigger UPDATE/REMOVE listener");
            this.definitionsListener = new /* Unavailable Anonymous Inner Class!! */;
            this.definitions.registerListener(this.definitionsListener, DefinitionsEvent.Type.TRIGGER_UPDATE, new DefinitionsEvent.Type[]{DefinitionsEvent.Type.TRIGGER_REMOVE});
        }
    }

    @PreDestroy
    public void shutdown() {
        if (this.coordinator) {
            this.stop();
        }
        if (this.distributed) {
            this.cacheManager.removeListener((Object)this.topologyChangeListener);
            this.cacheManager.stop();
        }
    }

    public void stop() {
        this.log.infof("Stopping Hawkular Metrics External Alerter, distributed=%s", (Object)this.distributed);
        if (null != this.expressionFutures) {
            this.expressionFutures.values().forEach(f -> f.cancel(true));
        }
        if (null != this.expressionExecutor) {
            this.expressionExecutor.shutdown();
            this.expressionExecutor = null;
        }
    }

    private void refresh() {
        this.log.debug((Object)"Refreshing External Metrics Triggers!");
        try {
            HashSet<ExternalCondition> activeConditions = new HashSet<ExternalCondition>();
            Collection triggers = this.definitions.getAllTriggersByTag(TAG_EXTERNAL_CONDITION_NAME, TAG_EXTERNAL_CONDITION_VALUE);
            this.log.debugf("Found [%s] External Metrics Triggers!", triggers.size());
            Collection conditions = null;
            for (Trigger trigger : triggers) {
                block10: {
                    try {
                        if (!trigger.isEnabled()) break block10;
                        conditions = this.definitions.getTriggerConditions(trigger.getTenantId(), trigger.getId(), null);
                        this.log.debugf("Checking [%s] Conditions for enabled trigger [%s]!", conditions.size(), (Object)trigger.getName());
                    }
                    catch (Exception e) {
                        this.log.error((Object)("Failed to fetch Conditions when scheduling metrics conditions for " + trigger), (Throwable)e);
                        continue;
                    }
                }
                if (null == conditions) continue;
                for (Condition condition : conditions) {
                    ExternalCondition externalCondition;
                    if (!(condition instanceof ExternalCondition) || !TAG_EXTERNAL_CONDITION_NAME.equals((externalCondition = (ExternalCondition)condition).getAlerterId())) continue;
                    this.log.debugf("Found Metrics ExternalCondition %s", (Object)externalCondition);
                    activeConditions.add(externalCondition);
                    if (this.expressionFutures.containsKey(externalCondition)) {
                        this.log.debugf("Skipping, already evaluating %s", (Object)externalCondition);
                        continue;
                    }
                    try {
                        this.log.debugf("Adding runner for %s", (Object)externalCondition);
                        ConditionExpression expression = ConditionExpression.toObject((String)externalCondition.getExpression());
                        ExpressionRunner runner = new ExpressionRunner(this.metrics, this.alerts, trigger, externalCondition, expression);
                        this.expressionFutures.put(externalCondition, this.expressionExecutor.scheduleAtFixedRate((Runnable)runner, 0L, expression.getFrequencyDuration().getValue(), expression.getFrequencyDuration().getTimeUnit()));
                    }
                    catch (Exception e) {
                        this.log.error((Object)("Failed to schedule expression for metrics condition " + externalCondition), (Throwable)e);
                    }
                }
            }
            HashSet<ExternalCondition> temp = new HashSet<ExternalCondition>();
            for (Map.Entry me : this.expressionFutures.entrySet()) {
                ExternalCondition ec = (ExternalCondition)me.getKey();
                if (activeConditions.contains(ec)) continue;
                this.log.debugf("Canceling evaluation of obsolete External Metric Condition %s", (Object)ec);
                ((ScheduledFuture)me.getValue()).cancel(true);
                temp.add(ec);
            }
            this.expressionFutures.keySet().removeAll(temp);
            temp.clear();
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to fetch Triggers for scheduling metrics conditions.", (Throwable)e);
        }
    }

    static /* synthetic */ void access$000(ConditionManager x0) {
        x0.processTopologyChange();
    }

    static /* synthetic */ boolean access$100(ConditionManager x0) {
        return x0.coordinator;
    }

    static /* synthetic */ void access$200(ConditionManager x0) {
        x0.refresh();
    }

    static {
        int v;
        try {
            v = Integer.valueOf(System.getProperty(THREAD_POOL_SIZE_PROPERTY, THREAD_POOL_SIZE_DEFAULT));
        }
        catch (Exception e) {
            v = Integer.valueOf(THREAD_POOL_SIZE_DEFAULT);
        }
        THREAD_POOL_SIZE = v;
    }
}

