/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.alerter.groups;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.inject.Inject;
import org.hawkular.alerts.api.model.trigger.Trigger;
import org.hawkular.alerts.api.services.DefinitionsEvent;
import org.hawkular.alerts.api.services.DefinitionsListener;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.hawkular.metrics.alerter.groups.GroupTriggerManager;
import org.hawkular.metrics.core.service.MetricsService;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.logging.Logger;

@Startup
@Singleton
public class GroupTriggerManager {
    private final Logger log = Logger.getLogger(GroupTriggerManager.class);
    private static final String TAG_DATA_IDS = "DataIds";
    private static final String TAG_GROUP_TRIGGER = "HawkularMetrics";
    private static final String TAG_GROUP_TRIGGER_VALUE = "GroupTrigger";
    private static final String TAG_SOURCE_BY = "SourceBy";
    private static final Integer THREAD_POOL_SIZE;
    private static final String THREAD_POOL_SIZE_DEFAULT = "20";
    private static final String THREAD_POOL_SIZE_PROPERTY = "hawkular-metrics.alerter.mgt.pool-size";
    private static final Integer JOB_PERIOD;
    private static final String JOB_PERIOD_DEFAULT;
    private static final String JOB_PERIOD_PROPERTY = "hawkular-metrics.alerter.mgt.job-period-seconds";
    ScheduledThreadPoolExecutor mgtExecutor;
    Map<Trigger, ScheduledFuture<?>> mgtFutures = new HashMap();
    private boolean distributed = false;
    private boolean coordinator = false;
    private TopologyChangeListener topologyChangeListener = null;
    private DefinitionsListener definitionsListener = null;
    @Inject
    private MetricsService metrics;
    @Inject
    private DefinitionsService definitions;
    @Resource(lookup="java:jboss/infinispan/container/hawkular-alerts")
    private EmbeddedCacheManager cacheManager;

    @PostConstruct
    public void init() {
        boolean bl = this.distributed = this.cacheManager.getTransport() != null;
        if (this.distributed) {
            this.topologyChangeListener = new TopologyChangeListener(this);
            this.cacheManager.addListener((Object)this.topologyChangeListener);
        }
        this.processTopologyChange();
    }

    private void processTopologyChange() {
        boolean currentCoordinator = this.coordinator;
        boolean bl = this.coordinator = this.distributed ? this.cacheManager.isCoordinator() : true;
        if (this.coordinator && !currentCoordinator) {
            this.start();
        } else if (!this.coordinator && currentCoordinator) {
            this.stop();
        }
    }

    public void start() {
        this.log.infof("Starting Hawkular Metrics Group Trigger Manager, distributed=%s", (Object)this.distributed);
        this.mgtExecutor = new ScheduledThreadPoolExecutor(THREAD_POOL_SIZE);
        this.refresh();
        if (null == this.definitionsListener) {
            this.log.info((Object)"Registering Trigger UPDATE/REMOVE listener");
            this.definitionsListener = new /* Unavailable Anonymous Inner Class!! */;
            this.definitions.registerListener(this.definitionsListener, DefinitionsEvent.Type.TRIGGER_CONDITION_CHANGE, new DefinitionsEvent.Type[]{DefinitionsEvent.Type.TRIGGER_REMOVE});
        }
    }

    @PreDestroy
    public void shutdown() {
        if (this.coordinator) {
            this.stop();
        }
        if (this.distributed) {
            this.cacheManager.removeListener((Object)this.topologyChangeListener);
            this.cacheManager.stop();
        }
    }

    public void stop() {
        this.log.infof("Stopping Hawkular Metrics Group Trigger Manager, distributed=%s", (Object)this.distributed);
        if (null != this.mgtFutures) {
            this.mgtFutures.values().forEach(f -> f.cancel(true));
        }
        if (null != this.mgtExecutor) {
            this.mgtExecutor.shutdown();
            this.mgtExecutor = null;
        }
    }

    public void cancel(Trigger mgt) {
        ScheduledFuture f = (ScheduledFuture)this.mgtFutures.get(mgt);
        if (null != f) {
            this.log.debugf("Canceling Hawkular Metrics Group Trigger Job for %s", (Object)mgt);
            try {
                f.cancel(true);
                this.mgtFutures.remove(mgt);
            }
            catch (Exception e) {
                this.log.warnf("Failed to cancel Hawkular Metrics Group Trigger Job for %s: %s", (Object)mgt, (Object)e.getMessage());
            }
        }
    }

    private void refresh() {
        try {
            Collection taggedMgts = this.definitions.getAllTriggersByTag(TAG_GROUP_TRIGGER, TAG_GROUP_TRIGGER_VALUE);
            this.log.debugf("Refreshing [%s] Metrics Group Triggers!", taggedMgts.size());
            Set mgts = taggedMgts.stream().filter(t -> {
                if (!t.isGroup()) {
                    this.log.warnf("Tagged as Metrics Group Trigger is not a group trigger, skipping %s", t);
                    return false;
                }
                return true;
            }).collect(Collectors.toSet());
            for (Trigger mgt : mgts) {
                if (this.mgtFutures.containsKey(mgt)) {
                    this.log.debugf("Already running job for MGT %s", (Object)mgt);
                    continue;
                }
                try {
                    this.log.infof("Adding MGT runner for %s with job period %d seconds", (Object)mgt, (Object)JOB_PERIOD);
                    MGTRunner runner = new MGTRunner(this.metrics, this.definitions, mgt);
                    this.mgtFutures.put(mgt, this.mgtExecutor.scheduleAtFixedRate((Runnable)runner, 0L, JOB_PERIOD.intValue(), TimeUnit.SECONDS));
                }
                catch (Exception e) {
                    this.log.errorf("Failed to schedule metrics group trigger %s: %s ", (Object)mgt, (Object)e.getMessage());
                }
            }
            Set doomedJobs = this.mgtFutures.keySet().stream().filter(k -> !mgts.contains(k)).collect(Collectors.toSet());
            doomedJobs.stream().forEach(k -> {
                this.log.infof("Canceling obsolete MGT runner for %s", k);
                this.cancel(k);
            });
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to refresh Metrics Group Triggers.", (Throwable)e);
        }
    }

    static /* synthetic */ void access$000(GroupTriggerManager x0) {
        x0.processTopologyChange();
    }

    static /* synthetic */ boolean access$100(GroupTriggerManager x0) {
        return x0.coordinator;
    }

    static /* synthetic */ Logger access$200(GroupTriggerManager x0) {
        return x0.log;
    }

    static /* synthetic */ void access$300(GroupTriggerManager x0) {
        x0.refresh();
    }

    static {
        int v;
        JOB_PERIOD_DEFAULT = String.valueOf(3600);
        try {
            v = Integer.valueOf(System.getProperty(THREAD_POOL_SIZE_PROPERTY, THREAD_POOL_SIZE_DEFAULT));
        }
        catch (Exception e) {
            v = Integer.valueOf(THREAD_POOL_SIZE_DEFAULT);
        }
        THREAD_POOL_SIZE = v;
        try {
            v = Integer.valueOf(System.getProperty(JOB_PERIOD_PROPERTY, JOB_PERIOD_DEFAULT));
        }
        catch (Exception e) {
            v = Integer.valueOf(JOB_PERIOD_DEFAULT);
        }
        JOB_PERIOD = v;
    }
}

