/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.alerter.groups;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.inject.Inject;
import org.hawkular.alerts.api.json.GroupMemberInfo;
import org.hawkular.alerts.api.model.condition.CompareCondition;
import org.hawkular.alerts.api.model.trigger.Trigger;
import org.hawkular.alerts.api.services.DefinitionsEvent;
import org.hawkular.alerts.api.services.DefinitionsListener;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.hawkular.metrics.core.service.MetricsService;
import org.hawkular.metrics.model.Metric;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.jboss.logging.Logger;

@Startup
@Singleton
public class GroupTriggerManager {
    private final Logger log = Logger.getLogger(GroupTriggerManager.class);
    private static final String TAG_DATA_IDS = "DataIds";
    private static final String TAG_GROUP_TRIGGER = "HawkularMetrics";
    private static final String TAG_GROUP_TRIGGER_VALUE = "GroupTrigger";
    private static final String TAG_SOURCE_BY = "SourceBy";
    private static final Integer THREAD_POOL_SIZE;
    private static final String THREAD_POOL_SIZE_DEFAULT = "20";
    private static final String THREAD_POOL_SIZE_PROPERTY = "hawkular-metrics.alerter.mgt.pool-size";
    private static final Integer JOB_PERIOD;
    private static final String JOB_PERIOD_DEFAULT;
    private static final String JOB_PERIOD_PROPERTY = "hawkular-metrics.alerter.mgt.job-period-seconds";
    ScheduledThreadPoolExecutor mgtExecutor;
    Map<Trigger, ScheduledFuture<?>> mgtFutures = new HashMap();
    private boolean distributed = false;
    private boolean coordinator = false;
    private TopologyChangeListener topologyChangeListener = null;
    private DefinitionsListener definitionsListener = null;
    @Inject
    private MetricsService metrics;
    @Inject
    private DefinitionsService definitions;
    @Resource(lookup="java:jboss/infinispan/container/hawkular-alerts")
    private EmbeddedCacheManager cacheManager;

    @PostConstruct
    public void init() {
        boolean bl = this.distributed = this.cacheManager.getTransport() != null;
        if (this.distributed) {
            this.topologyChangeListener = new TopologyChangeListener();
            this.cacheManager.addListener((Object)this.topologyChangeListener);
        }
        this.processTopologyChange();
    }

    private void processTopologyChange() {
        boolean currentCoordinator = this.coordinator;
        boolean bl = this.coordinator = this.distributed ? this.cacheManager.isCoordinator() : true;
        if (this.coordinator && !currentCoordinator) {
            this.start();
        } else if (!this.coordinator && currentCoordinator) {
            this.stop();
        }
    }

    public void start() {
        this.log.infof("Starting Hawkular Metrics Group Trigger Manager, distributed=%s", (Object)this.distributed);
        this.mgtExecutor = new ScheduledThreadPoolExecutor(THREAD_POOL_SIZE);
        this.refresh();
        if (null == this.definitionsListener) {
            this.log.info((Object)"Registering Trigger UPDATE/REMOVE listener");
            this.definitionsListener = new DefinitionsListener(){

                public void onChange(List<DefinitionsEvent> events) {
                    if (GroupTriggerManager.this.coordinator) {
                        GroupTriggerManager.this.log.debugf("Refreshing due to change events %s", events);
                        GroupTriggerManager.this.refresh();
                    }
                }
            };
            this.definitions.registerListener(this.definitionsListener, DefinitionsEvent.Type.TRIGGER_CONDITION_CHANGE, new DefinitionsEvent.Type[]{DefinitionsEvent.Type.TRIGGER_REMOVE});
        }
    }

    @PreDestroy
    public void shutdown() {
        if (this.coordinator) {
            this.stop();
        }
        if (this.distributed) {
            this.cacheManager.removeListener((Object)this.topologyChangeListener);
            this.cacheManager.stop();
        }
    }

    public void stop() {
        this.log.infof("Stopping Hawkular Metrics Group Trigger Manager, distributed=%s", (Object)this.distributed);
        if (null != this.mgtFutures) {
            this.mgtFutures.values().forEach(f -> f.cancel(true));
        }
        if (null != this.mgtExecutor) {
            this.mgtExecutor.shutdown();
            this.mgtExecutor = null;
        }
    }

    public void cancel(Trigger mgt) {
        ScheduledFuture<?> f = this.mgtFutures.get(mgt);
        if (null != f) {
            this.log.debugf("Canceling Hawkular Metrics Group Trigger Job for %s", (Object)mgt);
            try {
                f.cancel(true);
                this.mgtFutures.remove(mgt);
            }
            catch (Exception e) {
                this.log.warnf("Failed to cancel Hawkular Metrics Group Trigger Job for %s: %s", (Object)mgt, (Object)e.getMessage());
            }
        }
    }

    private synchronized void refresh() {
        try {
            Collection taggedMgts = this.definitions.getAllTriggersByTag(TAG_GROUP_TRIGGER, TAG_GROUP_TRIGGER_VALUE);
            this.log.debugf("Refreshing [%s] Metrics Group Triggers!", taggedMgts.size());
            Set mgts = taggedMgts.stream().filter(t -> {
                if (!t.isGroup()) {
                    this.log.warnf("Tagged as Metrics Group Trigger is not a group trigger, skipping %s", t);
                    return false;
                }
                return true;
            }).collect(Collectors.toSet());
            for (Trigger mgt : mgts) {
                if (this.mgtFutures.containsKey(mgt)) {
                    this.log.debugf("Already running job for MGT %s", (Object)mgt);
                    continue;
                }
                try {
                    this.log.infof("Adding MGT runner for %s with job period %d seconds", (Object)mgt, (Object)JOB_PERIOD);
                    MGTRunner runner = new MGTRunner(this.metrics, this.definitions, mgt);
                    this.mgtFutures.put(mgt, this.mgtExecutor.scheduleAtFixedRate(runner, 0L, JOB_PERIOD.intValue(), TimeUnit.SECONDS));
                }
                catch (Exception e) {
                    this.log.errorf("Failed to schedule metrics group trigger %s: %s ", (Object)mgt, (Object)e.getMessage());
                }
            }
            Set doomedJobs = this.mgtFutures.keySet().stream().filter(k -> !mgts.contains(k)).collect(Collectors.toSet());
            doomedJobs.stream().forEach(k -> {
                this.log.infof("Canceling obsolete MGT runner for %s", k);
                this.cancel((Trigger)k);
            });
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to refresh Metrics Group Triggers.", (Throwable)e);
        }
    }

    static {
        int v;
        JOB_PERIOD_DEFAULT = String.valueOf(3600);
        try {
            v = Integer.valueOf(System.getProperty(THREAD_POOL_SIZE_PROPERTY, THREAD_POOL_SIZE_DEFAULT));
        }
        catch (Exception e) {
            v = Integer.valueOf(THREAD_POOL_SIZE_DEFAULT);
        }
        THREAD_POOL_SIZE = v;
        try {
            v = Integer.valueOf(System.getProperty(JOB_PERIOD_PROPERTY, JOB_PERIOD_DEFAULT));
        }
        catch (Exception e) {
            v = Integer.valueOf(JOB_PERIOD_DEFAULT);
        }
        JOB_PERIOD = v;
    }

    static class MGTRunner
    implements Runnable {
        private final Logger log = Logger.getLogger(MGTRunner.class);
        private MetricsService metricsService;
        private DefinitionsService definitionsService;
        private Trigger metricsGroupTrigger;
        private Integer dataIdMapHash;

        public MGTRunner(MetricsService metrics, DefinitionsService definitionsService, Trigger metricsGroupTrigger) {
            this.metricsService = metrics;
            this.definitionsService = definitionsService;
            this.metricsGroupTrigger = metricsGroupTrigger;
        }

        @Override
        public void run() {
            try {
                this.log.debugf("Running job for MGT %s", (Object)this.metricsGroupTrigger);
                Trigger mgt = this.definitionsService.getTrigger(this.metricsGroupTrigger.getTenantId(), this.metricsGroupTrigger.getId());
                if (null == mgt) {
                    this.log.warnf("Metrics Group Trigger not found. Skipping %s", (Object)mgt);
                    return;
                }
                if (!mgt.isGroup()) {
                    this.log.warnf("Metrics Group Trigger is not a group trigger, skipping %s", (Object)mgt);
                    return;
                }
                Map tags = mgt.getTags();
                if (this.isEmpty(tags.getOrDefault(GroupTriggerManager.TAG_DATA_IDS, ""))) {
                    this.log.warnf("Required Metrics Group Trigger tag [%s] missing or null, skipping %s", (Object)GroupTriggerManager.TAG_DATA_IDS, (Object)mgt);
                    return;
                }
                if (this.isEmpty(tags.getOrDefault(GroupTriggerManager.TAG_SOURCE_BY, ""))) {
                    this.log.warnf("Required Metrics Group Trigger tag [%s] missing or null, skipping %s", (Object)GroupTriggerManager.TAG_SOURCE_BY, (Object)mgt);
                    return;
                }
                Set<String> dataIds = Arrays.asList(((String)tags.get(GroupTriggerManager.TAG_DATA_IDS)).split(",")).stream().map(s -> s.trim()).collect(Collectors.toSet());
                if (dataIds.stream().anyMatch(s -> tags.getOrDefault(s, "").trim().isEmpty())) {
                    this.log.warnf("Metrics Group Trigger dataId tag missing or invalid. DataIds %s, Tags %s, skipping %s", dataIds, (Object)tags, (Object)mgt);
                    return;
                }
                HashSet conditionDataIds = new HashSet();
                try {
                    Collection conditions = this.definitionsService.getTriggerConditions(mgt.getTenantId(), mgt.getId(), null);
                    conditionDataIds.addAll(conditions.stream().map(c -> c.getDataId()).collect(Collectors.toSet()));
                    conditionDataIds.addAll(conditions.stream().filter(c -> c instanceof CompareCondition).map(c -> ((CompareCondition)c).getDataId()).collect(Collectors.toSet()));
                }
                catch (Exception e) {
                    this.log.error((Object)("Failed to fetch Conditions when refreshing Metrics Group Trigger " + mgt), (Throwable)e);
                    return;
                }
                if (!dataIds.equals(conditionDataIds)) {
                    this.log.warnf("Metrics Group Trigger dataId mismatch. In Tag: %s, In Conditions: %s. Skipping %s", dataIds, conditionDataIds, (Object)mgt);
                    return;
                }
                HashMap dataIdMap = new HashMap();
                for (String dataId : dataIds) {
                    String tagQuery = (String)tags.get(dataId);
                    List dataIdMetrics = (List)this.metricsService.findMetricsWithFilters(mgt.getTenantId(), null, tagQuery).toList().toBlocking().firstOrDefault(Collections.emptyList());
                    dataIdMap.put(dataId, new HashSet(dataIdMetrics));
                }
                Integer hash = dataIdMap.hashCode();
                if (hash.equals(this.dataIdMapHash)) {
                    this.log.debugf("Metrics Group Trigger has no changes to member set, skipping %s", (Object)mgt);
                    return;
                }
                this.dataIdMapHash = hash;
                Map<List<String>, Map<String, List<String>>> sourceMap = MGTRunner.generateSourceMap((String)tags.get(GroupTriggerManager.TAG_SOURCE_BY), dataIdMap);
                Set<GroupMemberInfo> members = MGTRunner.generateMembers(mgt, dataIds, sourceMap);
                Collection existingMembers = this.definitionsService.getMemberTriggers(mgt.getTenantId(), mgt.getId(), true);
                Set memberIds = members.stream().map(m -> m.getMemberId()).collect(Collectors.toSet());
                Set existingMemberIds = existingMembers.stream().map(t -> t.getId()).collect(Collectors.toSet());
                this.log.tracef("members: %s", members);
                this.log.tracef("memberIds        : %s", memberIds);
                this.log.tracef("existingMemberIds: %s", existingMemberIds);
                for (GroupMemberInfo member : members) {
                    if (existingMemberIds.contains(member.getMemberId())) {
                        this.log.tracef("Member already exists, skipping %s", (Object)member);
                        continue;
                    }
                    try {
                        this.log.debugf("Adding Member %s", (Object)member);
                        this.definitionsService.addMemberTrigger(mgt.getTenantId(), mgt.getId(), member.getMemberId(), member.getMemberName(), member.getMemberDescription(), member.getMemberContext(), member.getMemberTags(), member.getDataIdMap());
                    }
                    catch (Exception e) {
                        this.log.warnf("Failed creating member %s: %s", (Object)member, (Object)e.getMessage());
                    }
                }
                existingMemberIds.removeAll(memberIds);
                for (String doomedMemberId : existingMemberIds) {
                    try {
                        this.log.debugf("Removing trigger %s", (Object)doomedMemberId);
                        this.definitionsService.removeTrigger(mgt.getTenantId(), doomedMemberId);
                    }
                    catch (Exception e) {
                        this.log.warnf("Failed to delete member %s: %s", (Object)doomedMemberId, (Object)e.getMessage());
                    }
                }
            }
            catch (Exception e) {
                this.log.error((Object)"Failed to fetch Triggers for scheduling metrics conditions.", (Throwable)e);
            }
        }

        static Map<List<String>, Map<String, List<String>>> generateSourceMap(String sourceByTag, Map<String, Set<Metric<?>>> dataIdMap) {
            List sourceBy = Arrays.asList(sourceByTag.split(",")).stream().map(s -> s.trim()).collect(Collectors.toList());
            boolean isStarSourceBy = "*".equals(sourceBy.get(0));
            List<String> starSource = isStarSourceBy ? Arrays.asList("*") : null;
            HashMap<List<String>, Map<String, List<String>>> sourceMap = new HashMap<List<String>, Map<String, List<String>>>();
            for (Map.Entry<String, Set<Metric<?>>> entry : dataIdMap.entrySet()) {
                String dataId = entry.getKey();
                Set<Metric<?>> metrics = entry.getValue();
                for (Metric<?> metric : metrics) {
                    ArrayList<String> metricNames;
                    List<String> source = isStarSourceBy ? starSource : sourceBy.stream().map(s -> (String)metric.getTags().get(s)).filter(s -> null != s).collect(Collectors.toList());
                    if (source.size() < sourceBy.size()) continue;
                    HashMap<String, ArrayList<String>> metricsMap = (HashMap<String, ArrayList<String>>)sourceMap.get(source);
                    if (null == metricsMap) {
                        metricsMap = new HashMap<String, ArrayList<String>>();
                    }
                    if (null == (metricNames = (ArrayList<String>)metricsMap.get(dataId))) {
                        metricNames = new ArrayList<String>();
                    }
                    metricNames.add(metric.getId());
                    metricsMap.put(dataId, metricNames);
                    sourceMap.put(source, metricsMap);
                }
            }
            return sourceMap;
        }

        static Set<GroupMemberInfo> generateMembers(Trigger mgt, Set<String> dataIds, Map<List<String>, Map<String, List<String>>> sourceMap) {
            HashMap<String, String> memberTags = new HashMap<String, String>();
            memberTags.put(GroupTriggerManager.TAG_GROUP_TRIGGER, "MemberTrigger");
            HashSet<GroupMemberInfo> members = new HashSet<GroupMemberInfo>();
            for (Map.Entry<List<String>, Map<String, List<String>>> sourceMapEntry : sourceMap.entrySet()) {
                List<String> source = sourceMapEntry.getKey();
                Map<String, List<String>> metricsMap = sourceMapEntry.getValue();
                if (metricsMap.size() < dataIds.size()) {
                    Logger log = Logger.getLogger(MGTRunner.class);
                    log.warnf("No MGT members: source: %s tags: %s dataIds: %s", source, metricsMap.keySet(), dataIds);
                    continue;
                }
                ArrayList memberDataIdMaps = new ArrayList();
                for (Map.Entry<String, List<String>> metricsMapEntry : metricsMap.entrySet()) {
                    String string = metricsMapEntry.getKey();
                    List<String> metricNames = metricsMapEntry.getValue();
                    if (memberDataIdMaps.isEmpty()) {
                        for (String metricName : metricNames) {
                            HashMap<String, String> hashMap = new HashMap<String, String>();
                            hashMap.put(string, metricName);
                            memberDataIdMaps.add(hashMap);
                        }
                        continue;
                    }
                    ArrayList prevMemberDataIdMaps = memberDataIdMaps;
                    memberDataIdMaps = new ArrayList();
                    for (Map map : prevMemberDataIdMaps) {
                        for (String metricName : metricNames) {
                            HashMap<String, String> memberDataIdMap = new HashMap<String, String>();
                            memberDataIdMap.putAll(map);
                            memberDataIdMap.put(string, metricName);
                            memberDataIdMaps.add(memberDataIdMap);
                        }
                    }
                }
                HashMap<String, String> memberContext = new HashMap<String, String>();
                memberContext.put("source", source.toString());
                for (Map map : memberDataIdMaps) {
                    GroupMemberInfo member = new GroupMemberInfo(mgt.getId(), String.valueOf(map.hashCode()), null, null, memberContext, memberTags, map);
                    members.add(member);
                }
            }
            return members;
        }

        private boolean isEmpty(String s) {
            return null == s || s.trim().isEmpty();
        }
    }

    @Listener
    public class TopologyChangeListener {
        @ViewChanged
        public void onTopologyChange(ViewChangedEvent cacheEvent) {
            GroupTriggerManager.this.processTopologyChange();
        }
    }
}

