/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.alerter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.inject.Inject;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.condition.ExternalCondition;
import org.hawkular.alerts.api.model.event.Event;
import org.hawkular.alerts.api.model.trigger.Trigger;
import org.hawkular.alerts.api.services.AlertsService;
import org.hawkular.alerts.api.services.DefinitionsEvent;
import org.hawkular.alerts.api.services.DefinitionsListener;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.hawkular.metrics.alerter.ConditionEvaluator;
import org.hawkular.metrics.alerter.ConditionExpression;
import org.hawkular.metrics.core.service.MetricsService;
import org.hawkular.metrics.model.BucketPoint;
import org.hawkular.metrics.model.Buckets;
import org.hawkular.metrics.model.MetricId;
import org.hawkular.metrics.model.MetricType;
import org.hawkular.metrics.model.Percentile;
import org.hawkular.metrics.model.exception.RuntimeApiError;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.jboss.logging.Logger;
import rx.Observable;

@Startup
@Singleton
public class ConditionManager {
    private final Logger log = Logger.getLogger(ConditionManager.class);
    private static final String TAG_EXTERNAL_CONDITION_NAME = "HawkularMetrics";
    private static final String TAG_EXTERNAL_CONDITION_VALUE = "MetricsCondition";
    private static final Integer THREAD_POOL_SIZE;
    private static final String THREAD_POOL_SIZE_DEFAULT = "20";
    private static final String THREAD_POOL_SIZE_PROPERTY = "hawkular-metrics.alerter.condition-pool-size";
    ScheduledThreadPoolExecutor expressionExecutor;
    Map<ExternalCondition, ScheduledFuture<?>> expressionFutures = new HashMap();
    private boolean distributed = false;
    private boolean coordinator = false;
    private TopologyChangeListener topologyChangeListener = null;
    private DefinitionsListener definitionsListener = null;
    @Inject
    private MetricsService metrics;
    @Inject
    private DefinitionsService definitions;
    @Inject
    private AlertsService alerts;
    @Resource(lookup="java:jboss/infinispan/container/hawkular-alerts")
    private EmbeddedCacheManager cacheManager;

    @PostConstruct
    public void init() {
        boolean bl = this.distributed = this.cacheManager.getTransport() != null;
        if (this.distributed) {
            this.topologyChangeListener = new TopologyChangeListener();
            this.cacheManager.addListener((Object)this.topologyChangeListener);
        }
        this.processTopologyChange();
    }

    private void processTopologyChange() {
        boolean currentCoordinator = this.coordinator;
        boolean bl = this.coordinator = this.distributed ? this.cacheManager.isCoordinator() : true;
        if (this.coordinator && !currentCoordinator) {
            this.start();
        } else if (!this.coordinator && currentCoordinator) {
            this.stop();
        }
    }

    public void start() {
        this.log.infof("Starting Hawkular Metrics External Alerter, distributed=%s", (Object)this.distributed);
        this.expressionExecutor = new ScheduledThreadPoolExecutor(THREAD_POOL_SIZE);
        this.refresh();
        if (null == this.definitionsListener) {
            this.log.info((Object)"Registering Trigger UPDATE/REMOVE listener");
            this.definitionsListener = new DefinitionsListener(){

                public void onChange(List<DefinitionsEvent> events) {
                    if (ConditionManager.this.coordinator) {
                        ConditionManager.this.refresh();
                    }
                }
            };
            this.definitions.registerListener(this.definitionsListener, DefinitionsEvent.Type.TRIGGER_CONDITION_CHANGE, new DefinitionsEvent.Type[]{DefinitionsEvent.Type.TRIGGER_UPDATE, DefinitionsEvent.Type.TRIGGER_REMOVE});
        }
    }

    @PreDestroy
    public void shutdown() {
        if (this.coordinator) {
            this.stop();
        }
        if (this.distributed) {
            this.cacheManager.removeListener((Object)this.topologyChangeListener);
            this.cacheManager.stop();
        }
    }

    public void stop() {
        this.log.infof("Stopping Hawkular Metrics External Alerter, distributed=%s", (Object)this.distributed);
        if (null != this.expressionFutures) {
            this.expressionFutures.values().forEach(f -> f.cancel(true));
        }
        if (null != this.expressionExecutor) {
            this.expressionExecutor.shutdown();
            this.expressionExecutor = null;
        }
    }

    private synchronized void refresh() {
        this.log.debug((Object)"Refreshing External Metrics Triggers!");
        try {
            HashSet<ExternalCondition> activeConditions = new HashSet<ExternalCondition>();
            Collection triggers = this.definitions.getAllTriggersByTag(TAG_EXTERNAL_CONDITION_NAME, TAG_EXTERNAL_CONDITION_VALUE);
            this.log.debugf("Found [%s] External Metrics Triggers!", triggers.size());
            Collection conditions = null;
            for (Trigger trigger : triggers) {
                block10: {
                    try {
                        if (!trigger.isEnabled()) break block10;
                        conditions = this.definitions.getTriggerConditions(trigger.getTenantId(), trigger.getId(), null);
                        this.log.debugf("Checking [%s] Conditions for enabled trigger [%s]!", conditions.size(), (Object)trigger.getName());
                    }
                    catch (Exception e) {
                        this.log.error((Object)("Failed to fetch Conditions when scheduling metrics conditions for " + trigger), (Throwable)e);
                        continue;
                    }
                }
                if (null == conditions) continue;
                for (Condition condition : conditions) {
                    ExternalCondition externalCondition;
                    if (!(condition instanceof ExternalCondition) || !TAG_EXTERNAL_CONDITION_NAME.equals((externalCondition = (ExternalCondition)condition).getAlerterId())) continue;
                    this.log.debugf("Found Metrics ExternalCondition %s", (Object)externalCondition);
                    activeConditions.add(externalCondition);
                    if (this.expressionFutures.containsKey(externalCondition)) {
                        this.log.debugf("Skipping, already evaluating %s", (Object)externalCondition);
                        continue;
                    }
                    try {
                        this.log.debugf("Adding runner for %s", (Object)externalCondition);
                        ConditionExpression expression = ConditionExpression.toObject(externalCondition.getExpression());
                        ExpressionRunner runner = new ExpressionRunner(this.metrics, this.alerts, trigger, externalCondition, expression);
                        this.expressionFutures.put(externalCondition, this.expressionExecutor.scheduleAtFixedRate(runner, 0L, expression.getFrequencyDuration().getValue(), expression.getFrequencyDuration().getTimeUnit()));
                    }
                    catch (Exception e) {
                        this.log.error((Object)("Failed to schedule expression for metrics condition " + externalCondition), (Throwable)e);
                    }
                }
            }
            HashSet<ExternalCondition> temp = new HashSet<ExternalCondition>();
            for (Map.Entry<ExternalCondition, ScheduledFuture<?>> me : this.expressionFutures.entrySet()) {
                ExternalCondition ec = me.getKey();
                if (activeConditions.contains(ec)) continue;
                this.log.debugf("Canceling evaluation of obsolete External Metric Condition %s", (Object)ec);
                me.getValue().cancel(true);
                temp.add(ec);
            }
            this.expressionFutures.keySet().removeAll(temp);
            temp.clear();
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to fetch Triggers for scheduling metrics conditions.", (Throwable)e);
        }
    }

    static {
        int v;
        try {
            v = Integer.valueOf(System.getProperty(THREAD_POOL_SIZE_PROPERTY, THREAD_POOL_SIZE_DEFAULT));
        }
        catch (Exception e) {
            v = Integer.valueOf(THREAD_POOL_SIZE_DEFAULT);
        }
        THREAD_POOL_SIZE = v;
    }

    private static class ExpressionRunner
    implements Runnable {
        private final Logger log = Logger.getLogger(ExpressionRunner.class);
        private MetricsService metricsService;
        private AlertsService alertsService;
        private Trigger trigger;
        private ExternalCondition externalCondition;
        private ConditionExpression expression;
        private transient Map<String, Integer> quietMap;

        public ExpressionRunner(MetricsService metrics, AlertsService alerts, Trigger trigger, ExternalCondition externalCondition, ConditionExpression expression) {
            this.metricsService = metrics;
            this.alertsService = alerts;
            this.trigger = trigger;
            this.externalCondition = externalCondition;
            this.expression = expression;
            if (expression.getQuietCount() > 0) {
                this.quietMap = new HashMap<String, Integer>();
            }
        }

        @Override
        public void run() {
            if (ConditionExpression.EvalType.ALL == this.expression.getEvalType()) {
                this.runOnAll();
            } else {
                this.runOnEach();
            }
        }

        private void runOnAll() {
            try {
                long now = System.currentTimeMillis();
                HashMap<String, BucketPoint> queryResults = new HashMap<String, BucketPoint>();
                for (ConditionExpression.Query q : this.expression.getQueries()) {
                    boolean isRate;
                    MetricType type = q.getMetricsType();
                    boolean isAvail = MetricType.AVAILABILITY == type;
                    boolean bl = isRate = MetricType.COUNTER_RATE == type || MetricType.GAUGE_RATE == type;
                    if (isRate) {
                        type = MetricType.COUNTER_RATE == type ? MetricType.COUNTER : MetricType.GAUGE;
                    }
                    ArrayList<String> metrics = this.isEmpty(q.getMetrics()) ? null : new ArrayList<String>(q.getMetrics());
                    String tags = q.getTags();
                    long end = now - q.getMetricsOffset().toMillis();
                    long start = end - q.getMetricsDuration().toMillis();
                    List<Percentile> percentiles = q.getMetricsPercentiles();
                    List result = isAvail ? (List)this.findMetricsByNameOrTags(this.trigger.getTenantId(), metrics, tags, MetricType.AVAILABILITY).toList().flatMap(metricIds -> {
                        if (metricIds.size() != 1) {
                            String err = "Only one Availability metric currently supported. Found [" + metricIds.size() + "] using metrics=" + metrics + " tags=" + tags;
                            throw new IllegalArgumentException(err);
                        }
                        return this.metricsService.findAvailabilityStats((MetricId)metricIds.get(0), start, end, Buckets.fromCount((long)start, (long)end, (int)1));
                    }).toBlocking().firstOrDefault((Object)Collections.EMPTY_LIST) : (List)this.findMetricsByNameOrTags(this.trigger.getTenantId(), metrics, tags, type).toList().flatMap(metricIds -> this.metricsService.findNumericStats(metricIds, start, end, Buckets.fromCount((long)start, (long)end, (int)1), percentiles, false, isRate)).toBlocking().firstOrDefault((Object)Collections.EMPTY_LIST);
                    if (result.size() != 1) {
                        throw new IllegalStateException("Failed to retrieve proper data " + result + " for query [%s]" + q.getName());
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debugf("Performing Query [%s]", (Object)q.getName());
                        this.log.debugf("        Type : %s (rate=%s)", (Object)type, (Object)isRate);
                        this.log.debugf("     Metrics : %s", metrics);
                        this.log.debugf("        Tags : %s", (Object)tags);
                        this.log.debugf("      Bucket : %s", (Object)Buckets.fromCount((long)start, (long)end, (int)1));
                        this.log.debugf(" Percentiles : %s", percentiles);
                    }
                    queryResults.put(q.getName(), (BucketPoint)result.get(0));
                }
                this.log.debugf("Query Results: %s", queryResults);
                this.evaluate("", queryResults, this.expression);
            }
            catch (Throwable t) {
                if (this.log.isDebugEnabled()) {
                    t.printStackTrace();
                }
                this.log.warnf("Failed data fetch for %s: %s", (Object)this.expression, (Object)t.getMessage());
            }
        }

        private void runOnEach() {
            try {
                long now = System.currentTimeMillis();
                HashMap<String, Map<String, List<? extends BucketPoint>>> queryResults = new HashMap<String, Map<String, List<? extends BucketPoint>>>();
                for (ConditionExpression.Query q : this.expression.getQueries()) {
                    boolean isRate;
                    MetricType type = q.getMetricsType();
                    boolean isAvail = MetricType.AVAILABILITY == type;
                    boolean bl = isRate = MetricType.COUNTER_RATE == type || MetricType.GAUGE_RATE == type;
                    if (isRate) {
                        type = MetricType.COUNTER_RATE == type ? MetricType.COUNTER : MetricType.GAUGE;
                    }
                    ArrayList<String> metrics = this.isEmpty(q.getMetrics()) ? null : new ArrayList<String>(q.getMetrics());
                    String tags = q.getTags();
                    long end = now - q.getMetricsOffset().toMillis();
                    long start = end - q.getMetricsDuration().toMillis();
                    List<Percentile> percentiles = q.getMetricsPercentiles();
                    Observable oResult = isAvail ? this.findMetricsByNameOrTags(this.trigger.getTenantId(), metrics, tags, MetricType.AVAILABILITY).flatMap(metricId -> this.metricsService.findAvailabilityStats(metricId, start, end, Buckets.fromCount((long)start, (long)end, (int)1)).map(bucketPoints -> Collections.singletonMap(metricId.getName(), bucketPoints))).collect(HashMap::new, (rMap, statsMap) -> rMap.putAll(statsMap)) : this.findMetricsByNameOrTags(this.trigger.getTenantId(), metrics, tags, type).flatMap(metricId -> this.metricsService.findNumericStats(Collections.singletonList(metricId), start, end, Buckets.fromCount((long)start, (long)end, (int)1), percentiles, false, isRate).map(bucketPoints -> Collections.singletonMap(metricId.getName(), bucketPoints))).collect(HashMap::new, (rMap, statsMap) -> rMap.putAll(statsMap));
                    Map result = (Map)oResult.toBlocking().firstOrDefault((Object)Collections.EMPTY_MAP);
                    if (this.log.isDebugEnabled()) {
                        this.log.debugf("Performing Query [%s]", (Object)q.getName());
                        this.log.debugf("        Type : %s (rate=%s)", (Object)type, (Object)isRate);
                        this.log.debugf("     Metrics : %s", metrics);
                        this.log.debugf("        Tags : %s", (Object)tags);
                        this.log.debugf("      Bucket : %s", (Object)Buckets.fromCount((long)start, (long)end, (int)1));
                        this.log.debugf(" Percentiles : %s", percentiles);
                    }
                    queryResults.put(q.getName(), result);
                }
                this.log.debugf("Query Results: %s", queryResults);
                ConditionEvaluator evaluator = this.expression.getEvaluator();
                this.evaluateEach("", queryResults, evaluator);
            }
            catch (Throwable t) {
                if (this.log.isDebugEnabled()) {
                    t.printStackTrace();
                }
                this.log.warnf("Failed data fetch for %s: %s", (Object)this.expression, (Object)t.getMessage());
            }
        }

        private void evaluateEach(String target, Map<String, Map<String, List<? extends BucketPoint>>> queryResults, ConditionEvaluator evaluator) {
            HashSet<String> metrics = null;
            for (String queryName : queryResults.keySet()) {
                if (null == metrics) {
                    metrics = new HashSet<String>(queryResults.get(queryName).keySet());
                    continue;
                }
                metrics.retainAll(queryResults.get(queryName).keySet());
            }
            HashMap<String, BucketPoint> metricQueryResults = new HashMap<String, BucketPoint>();
            Map<Object, Object> preparedCondition = new HashMap();
            for (String metric : metrics) {
                metricQueryResults.clear();
                preparedCondition.clear();
                for (String queryName : queryResults.keySet()) {
                    metricQueryResults.put(queryName, queryResults.get(queryName).get(metric).get(0));
                }
                try {
                    preparedCondition = evaluator.prepare(metricQueryResults);
                }
                catch (Exception e) {
                    this.log.debugf("Could not prepare evaluation, Skipping due to [%s]", (Object)e.getMessage());
                    return;
                }
                boolean evalResult = evaluator.evaluate();
                if (this.isQuiet(metric, this.expression.getQuietCount(), evalResult)) continue;
                try {
                    Event externalEvent = new Event(this.externalCondition.getTenantId(), UUID.randomUUID().toString(), System.currentTimeMillis(), this.externalCondition.getDataId(), ConditionManager.TAG_EXTERNAL_CONDITION_VALUE, preparedCondition.toString(), Collections.singletonMap("metricName", metric), null);
                    this.log.debugf("Sending External Condition Event to alerting: %s", (Object)externalEvent);
                    this.alertsService.sendEvents(Collections.singleton(externalEvent));
                }
                catch (Exception e) {
                    this.log.error((Object)"Failed to send external [EACH] event to alerting system.", (Throwable)e);
                }
            }
        }

        private void evaluate(String target, Map<String, BucketPoint> queryResults, ConditionExpression expression) {
            ConditionEvaluator evaluator = expression.getEvaluator();
            Map<String, String> preparedCondition = null;
            try {
                preparedCondition = evaluator.prepare(queryResults);
            }
            catch (Exception e) {
                this.log.debugf("Could not prepare evaluation, Skipping due to [%s]", (Object)e.getMessage());
                return;
            }
            boolean evalResult = evaluator.evaluate();
            if (!this.isQuiet("_ALL_", expression.getQuietCount(), evalResult)) {
                try {
                    Event externalEvent = new Event(this.externalCondition.getTenantId(), UUID.randomUUID().toString(), System.currentTimeMillis(), this.externalCondition.getDataId(), ConditionManager.TAG_EXTERNAL_CONDITION_VALUE, preparedCondition.toString());
                    this.log.debugf("Sending External Condition Event to Alerting %s", (Object)externalEvent);
                    this.alertsService.sendEvents(Collections.singleton(externalEvent));
                }
                catch (Exception e) {
                    this.log.error((Object)"Failed to send external [ALL] event to alerts system.", (Throwable)e);
                }
            }
        }

        private boolean isQuiet(String metricName, int quietCount, boolean evalResult) {
            if (quietCount <= 0) {
                return !evalResult;
            }
            boolean isQuiet = false;
            Integer currentQuietCount = this.quietMap.get(metricName);
            if (evalResult) {
                this.quietMap.put(metricName, quietCount);
                isQuiet = null != currentQuietCount;
            } else if (null != currentQuietCount) {
                isQuiet = true;
                if (1 == currentQuietCount) {
                    this.quietMap.remove(metricName);
                } else {
                    currentQuietCount = currentQuietCount - 1;
                    this.quietMap.put(metricName, currentQuietCount);
                }
            }
            return isQuiet;
        }

        private boolean isEmpty(Collection<?> c) {
            return null == c || c.isEmpty();
        }

        private boolean isEmpty(String s) {
            return null == s || s.trim().isEmpty();
        }

        private <T> Observable<MetricId<T>> findMetricsByNameOrTags(String tenantId, List<String> metricNames, String tags, MetricType<T> type) {
            if (this.isEmpty(metricNames) && this.isEmpty(tags)) {
                return Observable.error((Throwable)new RuntimeApiError("Either metrics or tags parameter must be used"));
            }
            if (!this.isEmpty(metricNames)) {
                if (!this.isEmpty(tags)) {
                    return Observable.error((Throwable)new RuntimeApiError("Cannot use both the metrics and tags parameters"));
                }
                return Observable.from(metricNames).map(id -> new MetricId(tenantId, type, id));
            }
            return this.metricsService.findMetricIdentifiersWithFilters(tenantId, type, tags);
        }
    }

    @Listener
    public class TopologyChangeListener {
        @ViewChanged
        public void onTopologyChange(ViewChangedEvent cacheEvent) {
            ConditionManager.this.processTopologyChange();
        }
    }
}

