/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.alerter;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.hawkular.metrics.alerter.ConditionEvaluator;
import org.hawkular.metrics.model.MetricType;
import org.hawkular.metrics.model.Percentile;
import org.hawkular.metrics.model.param.Duration;
import org.jboss.logging.Logger;

public class ConditionExpression {
    private static final Logger log = Logger.getLogger(ConditionExpression.class);
    public static final String DEFAULT_FREQUENCY = "10mn";
    @JsonInclude
    private List<Query> queries;
    @JsonInclude
    private String frequency;
    @JsonIgnore
    private Duration frequencyDuration;
    @JsonInclude
    private EvalType evalType;
    @JsonInclude
    private String eval;
    @JsonInclude
    private int quietCount;
    @JsonIgnore
    private ConditionEvaluator evaluator;
    private static final MetricType<?>[] ALL_TYPES = new MetricType[]{MetricType.AVAILABILITY, MetricType.COUNTER, MetricType.COUNTER_RATE, MetricType.GAUGE, MetricType.GAUGE_RATE};
    private static final MetricType<?>[] NUMERIC_TYPES = new MetricType[]{MetricType.COUNTER, MetricType.COUNTER_RATE, MetricType.GAUGE, MetricType.GAUGE_RATE};

    public ConditionExpression() {
        this((List<Query>)null, null, null, null, 0);
    }

    public ConditionExpression(Query query, String frequency, String eval) {
        this(Collections.singletonList(query), frequency, null, eval, 0);
    }

    public ConditionExpression(Query query, String frequency, EvalType evalType, String eval) {
        this(Collections.singletonList(query), frequency, evalType, eval, 0);
    }

    public ConditionExpression(List<Query> queries, String frequency, String eval) {
        this(queries, frequency, null, eval, 0);
    }

    public ConditionExpression(List<Query> queries, String frequency, EvalType evalType, String eval) {
        this(queries, frequency, evalType, eval, 0);
    }

    public ConditionExpression(Query query, String frequency, EvalType evalType, String eval, int quietCount) {
        this(Collections.singletonList(query), frequency, evalType, eval, quietCount);
    }

    public ConditionExpression(List<Query> queries, String frequency, EvalType evalType, String eval, int quietCount) {
        this.setQueries(queries);
        this.setFrequency(frequency);
        this.setEvalType(evalType);
        this.setEval(eval);
        this.setQuietCount(quietCount);
    }

    public List<Query> getQueries() {
        if (null == this.queries) {
            this.queries = new ArrayList<Query>();
        }
        return this.queries;
    }

    public void setQueries(List<Query> queries) {
        this.queries = null == queries ? new ArrayList() : queries;
        this.validateQueries();
    }

    private void validateQueries() {
        Set queryNames = this.queries.stream().map(Query::getName).collect(Collectors.toSet());
        if (this.queries.size() >= 2 && queryNames.size() < this.queries.size()) {
            throw new IllegalArgumentException("Each query requires a unique name, duplicate found: " + this.queries);
        }
        if (null == this.evaluator) {
            return;
        }
        for (ConditionEvaluator.QueryFunc qf : this.evaluator.getQueryVars().values()) {
            String name = qf.getQueryName();
            String func = qf.getFunction();
            if (!queryNames.contains(name)) {
                throw new IllegalArgumentException("Eval [" + this.eval + "] uses undefined query [" + name + "]");
            }
            for (Query q : this.queries) {
                if (func.startsWith("%")) {
                    try {
                        this.evaluator.funcToPercentile(func, q.getMetricsPercentiles());
                        continue;
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Eval [" + this.eval + "] uses undefined func [" + func + "] in query " + q);
                    }
                }
                if (Function.valueOf(func).isSupported(q.getMetricsType())) continue;
                throw new IllegalArgumentException("Eval [" + this.eval + "] uses unsupported func [" + func + "] for query metric type: " + q);
            }
        }
    }

    public String getFrequency() {
        return this.frequency;
    }

    public void setFrequency(String frequency) {
        this.frequency = null == frequency ? DEFAULT_FREQUENCY : frequency;
        this.frequencyDuration = new Duration(this.frequency);
        if (this.frequencyDuration.toMillis() < 60000L) {
            this.frequency = "1mn";
            this.frequencyDuration = new Duration(frequency);
        }
    }

    public Duration getFrequencyDuration() {
        return this.frequencyDuration;
    }

    public EvalType getEvalType() {
        return this.evalType;
    }

    public void setEvalType(EvalType evalType) {
        this.evalType = null == evalType ? EvalType.ALL : evalType;
    }

    public String getEval() {
        return this.eval;
    }

    public void setEval(String eval) {
        this.eval = eval;
        this.evaluator = null == eval ? null : new ConditionEvaluator(eval);
    }

    public int getQuietCount() {
        return this.quietCount;
    }

    public void setQuietCount(int quietCount) {
        if (quietCount < 0) {
            quietCount = 0;
        }
        this.quietCount = quietCount;
    }

    public ConditionEvaluator getEvaluator() {
        return this.evaluator;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.eval == null ? 0 : this.eval.hashCode());
        result = 31 * result + (this.evalType == null ? 0 : this.evalType.hashCode());
        result = 31 * result + (this.frequency == null ? 0 : this.frequency.hashCode());
        result = 31 * result + (this.queries == null ? 0 : this.queries.hashCode());
        result = 31 * result + this.quietCount;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConditionExpression other = (ConditionExpression)obj;
        if (this.eval == null ? other.eval != null : !this.eval.equals(other.eval)) {
            return false;
        }
        if (this.evalType != other.evalType) {
            return false;
        }
        if (this.frequency == null ? other.frequency != null : !this.frequency.equals(other.frequency)) {
            return false;
        }
        if (this.queries == null ? other.queries != null : !this.queries.equals(other.queries)) {
            return false;
        }
        return this.quietCount == other.quietCount;
    }

    public String toString() {
        return "ConditionExpression [queries=" + this.queries + ", frequency=" + this.frequency + ", evalType=" + (Object)((Object)this.evalType) + ", eval=" + this.eval + ", quietCount=" + this.quietCount + "]";
    }

    public static ConditionExpression toObject(String json) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (ConditionExpression)mapper.readValue(json, ConditionExpression.class);
        }
        catch (Exception e) {
            log.error((Object)"Failed to convert JSON to MetricsCondition", (Throwable)e);
            return null;
        }
    }

    public String toJson() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (Exception e) {
            log.error((Object)"Failed to convert MetricsCondition to JSON", (Throwable)e);
            return null;
        }
    }

    static /* synthetic */ MetricType[] access$000() {
        return NUMERIC_TYPES;
    }

    static /* synthetic */ MetricType[] access$100() {
        return ALL_TYPES;
    }

    public static class Query {
        public static final Set<MetricType<?>> UNSUPPORTED_TYPES = new HashSet<MetricType>(Arrays.asList(MetricType.STRING));
        @JsonInclude
        private String name;
        @JsonInclude
        private String type;
        @JsonIgnore
        private MetricType<?> metricsType;
        @JsonInclude
        private Set<String> metrics;
        @JsonInclude
        private String tags;
        @JsonInclude
        private Set<String> percentiles;
        @JsonIgnore
        private List<Percentile> metricsPercentiles;
        @JsonInclude
        private String duration;
        @JsonIgnore
        private Duration metricsDuration;
        @JsonInclude
        private String offset;
        @JsonIgnore
        private Duration metricsOffset;

        Query() {
            this(null, null, null, null, null, null, null);
        }

        Query(String name, String offset, Query query) {
            this.name = name;
            this.setOffset(offset);
            this.setType(query.getType());
            this.setMetrics(query.getMetrics());
            this.setTags(query.getTags());
            this.setPercentiles(query.getPercentiles());
            this.setDuration(query.getDuration());
        }

        Query(String name, Set<String> metrics, String tags, Set<String> percentiles, String duration, String offset) {
            this(name, null, metrics, tags, percentiles, duration, offset);
        }

        Query(String name, String metricType, Set<String> metrics, String tags, Set<String> percentiles, String duration, String offset) {
            this.name = name;
            this.setType(metricType);
            this.setMetrics(metrics);
            this.setTags(tags);
            this.setPercentiles(percentiles);
            this.setDuration(duration);
            this.setOffset(offset);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            MetricType mt;
            if (null == type) {
                type = MetricType.GAUGE.getText();
            }
            if (UNSUPPORTED_TYPES.contains(mt = MetricType.fromTextCode((String)type))) {
                throw new IllegalArgumentException("Unsupported type: [" + type + "]");
            }
            this.type = type;
            this.metricsType = MetricType.fromTextCode((String)type);
        }

        public MetricType<?> getMetricsType() {
            return this.metricsType;
        }

        public Set<String> getMetrics() {
            return this.metrics;
        }

        public void setMetrics(Set<String> metrics) {
            if (metrics != null && this.tags != null) {
                throw new IllegalArgumentException("Metrics and Tags can not both be set on the Query");
            }
            this.metrics = metrics;
        }

        public String getTags() {
            return this.tags;
        }

        public void setTags(String tags) {
            if (this.metrics != null && tags != null) {
                throw new IllegalArgumentException("Metrics and Tags can not both be set on the Query");
            }
            this.tags = tags;
        }

        private boolean isEmpty(String s) {
            return null == s || s.isEmpty();
        }

        private boolean isEmpty(Collection<?> c) {
            return null == c || c.isEmpty();
        }

        public Set<String> getPercentiles() {
            if (null == this.percentiles) {
                this.percentiles = new HashSet<String>();
            }
            return this.percentiles;
        }

        public void setPercentiles(Set<String> percentiles) {
            this.percentiles = null == percentiles ? new HashSet() : percentiles;
            this.metricsPercentiles = this.percentilesToMetricsPercentiles();
        }

        private List<Percentile> percentilesToMetricsPercentiles() {
            if (this.isEmpty(this.percentiles)) {
                return Collections.emptyList();
            }
            return this.percentiles.stream().map(Percentile::new).collect(Collectors.toList());
        }

        public List<Percentile> getMetricsPercentiles() {
            return this.metricsPercentiles;
        }

        public String getDuration() {
            return this.duration;
        }

        public void setDuration(String duration) {
            this.duration = duration;
            this.metricsDuration = new Duration(this.isEmpty(duration) ? "0ms" : duration);
        }

        public Duration getMetricsDuration() {
            return this.metricsDuration;
        }

        public String getOffset() {
            return this.offset;
        }

        public void setOffset(String offset) {
            this.offset = offset;
            this.metricsOffset = new Duration(this.isEmpty(offset) ? "0ms" : offset);
        }

        public Duration getMetricsOffset() {
            return this.metricsOffset;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.duration == null ? 0 : this.duration.hashCode());
            result = 31 * result + (this.metrics == null ? 0 : this.metrics.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.offset == null ? 0 : this.offset.hashCode());
            result = 31 * result + (this.percentiles == null ? 0 : this.percentiles.hashCode());
            result = 31 * result + (this.tags == null ? 0 : this.tags.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Query other = (Query)obj;
            if (this.duration == null ? other.duration != null : !this.duration.equals(other.duration)) {
                return false;
            }
            if (this.metrics == null ? other.metrics != null : !this.metrics.equals(other.metrics)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.offset == null ? other.offset != null : !this.offset.equals(other.offset)) {
                return false;
            }
            if (this.percentiles == null ? other.percentiles != null : !this.percentiles.equals(other.percentiles)) {
                return false;
            }
            if (this.tags == null ? other.tags != null : !this.tags.equals(other.tags)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }

        public String toString() {
            return "Query [name=" + this.name + ", type=" + this.type + ", metrics=" + this.metrics + ", tags=" + this.tags + ", percentiles=" + this.percentiles + ", duration=" + this.duration + ", offset=" + this.offset + "]";
        }

        public static Builder builder(String name) {
            return new Builder(name);
        }

        public static Builder builder(String name, String offset, Query query) {
            return new Builder(name, offset, query);
        }

        public static class Builder {
            Query query;

            private Builder(String name) {
                this.query = new Query(name, null, null, null, null, null, null);
            }

            private Builder(String name, String offset, Query query) {
                this.query = new Query(name, offset, query);
            }

            public Builder duration(String duration) {
                this.query.setDuration(duration);
                return this;
            }

            public Builder metrics(Set<String> metrics) {
                this.query.setMetrics(metrics);
                return this;
            }

            public Builder metrics(String ... metrics) {
                this.query.setMetrics(new HashSet<String>(Arrays.asList(metrics)));
                return this;
            }

            public Builder metric(String metric) {
                this.query.setMetrics(Collections.singleton(metric));
                return this;
            }

            public Builder offset(String offset) {
                this.query.setOffset(offset);
                return this;
            }

            public Builder percentiles(Set<String> percentiles) {
                this.query.setPercentiles(percentiles);
                return this;
            }

            public Builder tags(String tags) {
                this.query.setTags(tags);
                return this;
            }

            public Builder type(String type) {
                this.query.setType(type);
                return this;
            }

            public Builder type(MetricType<?> type) {
                this.query.setType(type.getText());
                return this;
            }

            public Query build() {
                return this.query;
            }
        }
    }

    public static enum Function {
        avg(ConditionExpression.access$000()),
        max(ConditionExpression.access$000()),
        median(ConditionExpression.access$000()),
        min(ConditionExpression.access$000()),
        notUpCount(MetricType.AVAILABILITY),
        notUpDuration(MetricType.AVAILABILITY),
        samples(ConditionExpression.access$100()),
        sum(ConditionExpression.access$000()),
        uptimeRatio(MetricType.AVAILABILITY),
        upCount(MetricType.AVAILABILITY);

        private Set<MetricType<?>> supportedMetricTypes;

        private Function(MetricType<?> ... supportedMetricTypes) {
            this.supportedMetricTypes = new HashSet(Arrays.asList(supportedMetricTypes));
        }

        public boolean isSupported(MetricType<?> metricType) {
            return this.supportedMetricTypes.contains(metricType);
        }
    }

    public static enum EvalType {
        ALL,
        EACH;

    }
}

