/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.alerting;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.hawkular.alerts.api.model.data.AvailabilityType;
import org.hawkular.alerts.api.model.data.Data;
import org.hawkular.alerts.api.services.AlertsService;
import org.hawkular.metrics.api.jaxrs.ServiceReady;
import org.hawkular.metrics.api.jaxrs.ServiceReadyEvent;
import org.hawkular.metrics.api.jaxrs.config.Configurable;
import org.hawkular.metrics.api.jaxrs.config.ConfigurationKey;
import org.hawkular.metrics.api.jaxrs.config.ConfigurationProperty;
import org.hawkular.metrics.model.Metric;
import org.hawkular.metrics.model.MetricId;
import org.hawkular.metrics.model.MetricType;
import org.jboss.logging.Logger;
import rx.Observable;
import rx.Subscription;
import rx.schedulers.Schedulers;

@ApplicationScoped
public class InsertedDataSubscriber {
    private static final Logger log = Logger.getLogger(InsertedDataSubscriber.class);
    static final Map<MetricType<?>, String> prefixMap = new HashMap();
    private Subscription subscription;
    @Inject
    private AlertsService alertsService;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.METRICS_PUBLISH_PERIOD)
    private String publishPeriodProperty;
    private int publishPeriod;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.DISABLE_METRICS_FORWARDING)
    private String disableMetricsForwarding;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.DISABLE_PUBLISH_FILTERING)
    private String disablePublishFiltering;

    public void onMetricsServiceReady(@Observes @ServiceReady ServiceReadyEvent event) {
        if (!Boolean.parseBoolean(this.disableMetricsForwarding)) {
            this.publishPeriod = this.getPublishPeriod();
            Observable events = Boolean.parseBoolean(this.disablePublishFiltering) ? event.getInsertedData().buffer((long)this.publishPeriod, TimeUnit.MILLISECONDS, 100).filter(list -> !list.isEmpty()) : event.getInsertedData().filter(m -> m.getType() != MetricType.STRING).buffer((long)this.publishPeriod, TimeUnit.MILLISECONDS, 100).filter(list -> !list.isEmpty());
            events = events.onBackpressureBuffer().observeOn(Schedulers.io());
            this.subscription = events.subscribe(list -> list.forEach(this::onInsertedData));
        }
    }

    private void onInsertedData(Metric<?> metric) {
        MetricType metricType = metric.getMetricId().getType();
        if (metricType == MetricType.UNDEFINED) {
            return;
        }
        if (metricType == MetricType.AVAILABILITY) {
            Metric<?> avail = metric;
            this.publishAvailablility(avail);
        } else if (metricType == MetricType.STRING) {
            Metric<?> string = metric;
            this.publishString(string);
        } else {
            this.publishNumeric(metric);
        }
    }

    private void publishNumeric(Metric<? extends Number> numeric) {
        MetricId numericId = numeric.getMetricId();
        String tenantId = numericId.getTenantId();
        String dataId = prefixMap.get(numericId.getType()) + numericId.getName();
        List data = numeric.getDataPoints().stream().map(dataPoint -> Data.forNumeric((String)tenantId, (String)dataId, (long)dataPoint.getTimestamp(), (Double)((Number)dataPoint.getValue()).doubleValue())).collect(Collectors.toList());
        try {
            log.tracef("Publish numeric data: %s", data);
            this.alertsService.sendData(data);
        }
        catch (Exception e) {
            log.warnf("Failed to send numeric alerting data.", (Object)e);
        }
    }

    private void publishAvailablility(Metric<org.hawkular.metrics.model.AvailabilityType> avail) {
        MetricId availId = avail.getMetricId();
        String tenantId = availId.getTenantId();
        String dataId = prefixMap.get(MetricType.AVAILABILITY) + availId.getName();
        List data = avail.getDataPoints().stream().map(dataPoint -> Data.forAvailability((String)tenantId, (String)dataId, (long)dataPoint.getTimestamp(), (AvailabilityType)this.toAlertingAvail((org.hawkular.metrics.model.AvailabilityType)dataPoint.getValue()))).collect(Collectors.toList());
        try {
            log.tracef("Publish avail data: %s", data);
            this.alertsService.sendData(data);
        }
        catch (Exception e) {
            log.warnf("Failed to send availability alerting data.", (Object)e);
        }
    }

    private void publishString(Metric<String> string) {
        MetricId stringId = string.getMetricId();
        String tenantId = stringId.getTenantId();
        String dataId = prefixMap.get(MetricType.STRING) + stringId.getName();
        List data = string.getDataPoints().stream().map(dataPoint -> Data.forString((String)tenantId, (String)dataId, (long)dataPoint.getTimestamp(), (String)((String)dataPoint.getValue()))).collect(Collectors.toList());
        try {
            log.tracef("Publish string data: %s", data);
            this.alertsService.sendData(data);
        }
        catch (Exception e) {
            log.warnf("Failed to send string alerting data.", (Object)e);
        }
    }

    private AvailabilityType toAlertingAvail(org.hawkular.metrics.model.AvailabilityType metricAvailType) {
        switch (metricAvailType) {
            case UP: {
                return AvailabilityType.UP;
            }
            case DOWN: {
                return AvailabilityType.DOWN;
            }
        }
        return AvailabilityType.UNAVAILABLE;
    }

    @PreDestroy
    void shutdown() {
        if (this.subscription != null) {
            this.subscription.unsubscribe();
        }
    }

    private int getPublishPeriod() {
        try {
            return Integer.parseInt(this.publishPeriodProperty);
        }
        catch (NumberFormatException e) {
            log.warnf("Invalid publish period. Setting default value %s", (Object)ConfigurationKey.METRICS_PUBLISH_PERIOD.defaultValue());
            return Integer.parseInt(ConfigurationKey.METRICS_PUBLISH_PERIOD.defaultValue());
        }
    }

    static {
        prefixMap.put(MetricType.AVAILABILITY, "hm_a_");
        prefixMap.put(MetricType.COUNTER, "hm_c_");
        prefixMap.put(MetricType.COUNTER_RATE, "hm_cr_");
        prefixMap.put(MetricType.GAUGE, "hm_g_");
        prefixMap.put(MetricType.GAUGE_RATE, "hm_gr_");
        prefixMap.put(MetricType.STRING, "hm_s_");
    }
}

