/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.alerting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.hawkular.alerts.api.model.data.AvailabilityType;
import org.hawkular.alerts.api.model.data.Data;
import org.hawkular.alerts.api.services.AlertsService;
import org.hawkular.alerts.filter.CacheClient;
import org.hawkular.alerts.filter.CacheKey;
import org.hawkular.metrics.api.jaxrs.ServiceReady;
import org.hawkular.metrics.api.jaxrs.ServiceReadyEvent;
import org.hawkular.metrics.api.jaxrs.config.Configurable;
import org.hawkular.metrics.api.jaxrs.config.ConfigurationKey;
import org.hawkular.metrics.api.jaxrs.config.ConfigurationProperty;
import org.hawkular.metrics.model.Metric;
import org.hawkular.metrics.model.MetricId;
import org.hawkular.metrics.model.MetricType;
import org.jboss.logging.Logger;
import rx.Observable;
import rx.Subscription;
import rx.schedulers.Schedulers;

@ApplicationScoped
public class InsertedDataSubscriber {
    private static final Logger log = Logger.getLogger(InsertedDataSubscriber.class);
    static final Map<MetricType<?>, String> prefixMap = new HashMap();
    private Subscription subscription;
    @Inject
    private AlertsService alertsService;
    @Inject
    private CacheClient dataIdCache;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.METRICS_PUBLISH_PERIOD)
    private String publishPeriodProperty;
    private int publishPeriod;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.DISABLE_METRICS_FORWARDING)
    private String disableMetricsForwardingProperty;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.DISABLE_PUBLISH_FILTERING)
    private String disablePublishFilteringProperty;
    private boolean disablePublishFiltering;

    public void onMetricsServiceReady(@Observes @ServiceReady ServiceReadyEvent event) {
        if (!Boolean.parseBoolean(this.disableMetricsForwardingProperty)) {
            this.publishPeriod = this.getPublishPeriod();
            this.disablePublishFiltering = Boolean.parseBoolean(this.disablePublishFilteringProperty);
            Observable events = event.getInsertedData().buffer((long)this.publishPeriod, TimeUnit.MILLISECONDS, 100).filter(list -> !list.isEmpty());
            events = events.onBackpressureBuffer().observeOn(Schedulers.io());
            this.subscription = events.subscribe(list -> this.onInsertedData((List<Metric<?>>)list));
        }
    }

    private void onInsertedData(List<Metric<?>> metrics) {
        ArrayList dataToSend = new ArrayList(metrics.size());
        CacheKey reusableKey = new CacheKey("", "");
        metrics.stream().forEach(m -> this.addToData((Metric<?>)m, dataToSend, reusableKey));
        if (!dataToSend.isEmpty()) {
            try {
                this.alertsService.sendData(dataToSend, true);
            }
            catch (Exception e) {
                log.warnf("Failed to send alerting data.", (Object)e);
            }
        }
    }

    private boolean containsKey(String tenantId, String dataId, CacheKey reusableKey) {
        reusableKey.setTenantId(tenantId);
        reusableKey.setDataId(dataId);
        return this.dataIdCache.containsKey(reusableKey);
    }

    private void addToData(Metric<?> metric, List<Data> dataToSend, CacheKey reusableKey) {
        MetricId metricId = metric.getMetricId();
        MetricType metricType = metricId.getType();
        if (metricType == MetricType.UNDEFINED) {
            return;
        }
        String tenantId = metricId.getTenantId();
        String dataId = prefixMap.get(metricType) + metricId.getName();
        if (!this.disablePublishFiltering && !this.containsKey(tenantId, dataId, reusableKey)) {
            return;
        }
        if (metricType == MetricType.AVAILABILITY) {
            Metric<?> avail = metric;
            List availData = avail.getDataPoints().stream().map(dataPoint -> Data.forAvailability((String)tenantId, (String)dataId, (long)dataPoint.getTimestamp(), (AvailabilityType)this.toAlertingAvail((org.hawkular.metrics.model.AvailabilityType)dataPoint.getValue()))).collect(Collectors.toList());
            dataToSend.addAll(availData);
        } else if (metricType == MetricType.STRING) {
            Metric<?> string = metric;
            List stringData = string.getDataPoints().stream().map(dataPoint -> Data.forString((String)tenantId, (String)dataId, (long)dataPoint.getTimestamp(), (String)((String)dataPoint.getValue()))).collect(Collectors.toList());
            dataToSend.addAll(stringData);
        } else {
            Metric<?> numeric = metric;
            List numericData = numeric.getDataPoints().stream().map(dataPoint -> Data.forNumeric((String)tenantId, (String)dataId, (long)dataPoint.getTimestamp(), (Double)((Number)dataPoint.getValue()).doubleValue())).collect(Collectors.toList());
            dataToSend.addAll(numericData);
        }
    }

    private AvailabilityType toAlertingAvail(org.hawkular.metrics.model.AvailabilityType metricAvailType) {
        switch (metricAvailType) {
            case UP: {
                return AvailabilityType.UP;
            }
            case DOWN: {
                return AvailabilityType.DOWN;
            }
        }
        return AvailabilityType.UNAVAILABLE;
    }

    @PreDestroy
    void shutdown() {
        if (this.subscription != null) {
            this.subscription.unsubscribe();
        }
    }

    private int getPublishPeriod() {
        try {
            return Integer.parseInt(this.publishPeriodProperty);
        }
        catch (NumberFormatException e) {
            log.warnf("Invalid publish period. Setting default value %s", (Object)ConfigurationKey.METRICS_PUBLISH_PERIOD.defaultValue());
            return Integer.parseInt(ConfigurationKey.METRICS_PUBLISH_PERIOD.defaultValue());
        }
    }

    static {
        prefixMap.put(MetricType.AVAILABILITY, "hm_a_");
        prefixMap.put(MetricType.COUNTER, "hm_c_");
        prefixMap.put(MetricType.COUNTER_RATE, "hm_cr_");
        prefixMap.put(MetricType.GAUGE, "hm_g_");
        prefixMap.put(MetricType.GAUGE_RATE, "hm_gr_");
        prefixMap.put(MetricType.STRING, "hm_s_");
    }
}

