/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.handler;

import java.net.URI;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.metrics.api.jaxrs.model.ApiError;
import org.hawkular.metrics.api.jaxrs.model.Availability;
import org.hawkular.metrics.api.jaxrs.model.Counter;
import org.hawkular.metrics.api.jaxrs.model.Gauge;
import org.hawkular.metrics.api.jaxrs.model.MetricDefinition;
import org.hawkular.metrics.api.jaxrs.model.MixedMetricsRequest;
import org.hawkular.metrics.api.jaxrs.param.Tags;
import org.hawkular.metrics.api.jaxrs.util.ApiUtils;
import org.hawkular.metrics.api.jaxrs.util.MetricTypeTextConverter;
import org.hawkular.metrics.core.api.Metric;
import org.hawkular.metrics.core.api.MetricAlreadyExistsException;
import org.hawkular.metrics.core.api.MetricId;
import org.hawkular.metrics.core.api.MetricType;
import org.hawkular.metrics.core.api.MetricsService;
import rx.Observable;

@Path(value="/metrics")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class MetricHandler {
    @Inject
    private MetricsService metricsService;
    @HeaderParam(value="Hawkular-Tenant")
    private String tenantId;

    @POST
    @Path(value="/")
    public Response createMetric(MetricDefinition metricDefinition, @Context UriInfo uriInfo) {
        if (metricDefinition.getType() == null || !metricDefinition.getType().isUserType()) {
            return ApiUtils.badRequest((ApiError)new ApiError("MetricDefinition type is invalid"));
        }
        MetricId id = new MetricId(this.tenantId, metricDefinition.getType(), metricDefinition.getId());
        Metric metric = new Metric(id, metricDefinition.getTags(), metricDefinition.getDataRetention());
        URI location = uriInfo.getBaseUriBuilder().path("/{type}/{id}").build(new Object[]{MetricTypeTextConverter.getLongForm((MetricType)id.getType()), id.getName()});
        try {
            Observable observable = this.metricsService.createMetric(metric);
            observable.toBlocking().lastOrDefault(null);
            return Response.created((URI)location).build();
        }
        catch (MetricAlreadyExistsException e) {
            String message = "A metric with name [" + e.getMetric().getId().getName() + "] already exists";
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)new ApiError(message)).build();
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @GET
    @Path(value="/")
    public <T> Response findMetrics(@QueryParam(value="type") MetricType<T> metricType, @QueryParam(value="tags") Tags tags) {
        if (metricType != null && !metricType.isUserType()) {
            return ApiUtils.badRequest((ApiError)new ApiError("Incorrect type param " + metricType.toString()));
        }
        Observable metricObservable = tags == null ? this.metricsService.findMetrics(this.tenantId, metricType) : this.metricsService.findMetricsWithFilters(this.tenantId, tags.getTags(), metricType);
        try {
            return (Response)metricObservable.map(MetricDefinition::new).toList().map(ApiUtils::collectionToResponse).toBlocking().lastOrDefault(null);
        }
        catch (PatternSyntaxException e) {
            return ApiUtils.badRequest((Throwable)e);
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @POST
    @Path(value="/data")
    public Response addMetricsData(MixedMetricsRequest metricsRequest) {
        if (metricsRequest.isEmpty()) {
            return ApiUtils.emptyPayload();
        }
        Observable gauges = Gauge.toObservable((String)this.tenantId, (List)metricsRequest.getGauges());
        Observable availabilities = Availability.toObservable((String)this.tenantId, (List)metricsRequest.getAvailabilities());
        Observable counters = Counter.toObservable((String)this.tenantId, (List)metricsRequest.getCounters());
        try {
            this.metricsService.addDataPoints(MetricType.GAUGE, gauges).mergeWith(this.metricsService.addDataPoints(MetricType.AVAILABILITY, availabilities)).mergeWith(this.metricsService.addDataPoints(MetricType.COUNTER, counters)).toBlocking().lastOrDefault(null);
            return Response.ok().build();
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }
}

