/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.handler;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.metrics.api.jaxrs.util.ApiUtils;
import org.hawkular.metrics.core.service.Functions;
import org.hawkular.metrics.core.service.MetricsService;
import org.hawkular.metrics.core.service.Order;
import org.hawkular.metrics.model.ApiError;
import org.hawkular.metrics.model.Buckets;
import org.hawkular.metrics.model.DataPoint;
import org.hawkular.metrics.model.Metric;
import org.hawkular.metrics.model.MetricId;
import org.hawkular.metrics.model.MetricType;
import org.hawkular.metrics.model.exception.MetricAlreadyExistsException;
import org.hawkular.metrics.model.exception.RuntimeApiError;
import org.hawkular.metrics.model.param.BucketConfig;
import org.hawkular.metrics.model.param.Duration;
import org.hawkular.metrics.model.param.Percentiles;
import org.hawkular.metrics.model.param.Tags;
import org.hawkular.metrics.model.param.TimeRange;
import rx.Observable;
import rx.functions.Func1;

@Path(value="/counters")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class CounterHandler {
    @Inject
    private MetricsService metricsService;
    @HeaderParam(value="Hawkular-Tenant")
    private String tenantId;

    @POST
    @Path(value="/")
    public Response createCounter(Metric<Long> metric, @Context UriInfo uriInfo) {
        if (metric.getType() != null && MetricType.UNDEFINED != metric.getType() && MetricType.COUNTER != metric.getType()) {
            return ApiUtils.badRequest((ApiError)new ApiError("Metric type does not match " + MetricType.COUNTER.getText()));
        }
        metric = new Metric(new MetricId(this.tenantId, MetricType.COUNTER, metric.getId()), metric.getTags(), metric.getDataRetention());
        URI location = uriInfo.getBaseUriBuilder().path("/counters/{id}").build(new Object[]{metric.getMetricId().getName()});
        try {
            Observable observable = this.metricsService.createMetric(metric);
            observable.toBlocking().lastOrDefault(null);
            return Response.created((URI)location).build();
        }
        catch (MetricAlreadyExistsException e) {
            String message = "A metric with name [" + e.getMetric().getMetricId().getName() + "] already exists";
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)new ApiError(message)).build();
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @GET
    @Path(value="/")
    public Response findCounterMetrics(@QueryParam(value="tags") Tags tags) {
        Observable metricObservable = tags == null ? this.metricsService.findMetrics(this.tenantId, MetricType.COUNTER) : this.metricsService.findMetricsWithFilters(this.tenantId, MetricType.COUNTER, tags.getTags(), new Func1[0]);
        try {
            return (Response)metricObservable.toList().map(ApiUtils::collectionToResponse).toBlocking().lastOrDefault(null);
        }
        catch (PatternSyntaxException e) {
            return ApiUtils.badRequest((Throwable)e);
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @GET
    @Path(value="/{id}")
    public Response getCounter(@PathParam(value="id") String id) {
        try {
            return (Response)this.metricsService.findMetric(new MetricId(this.tenantId, MetricType.COUNTER, id)).map(metricDef -> Response.ok((Object)metricDef).build()).switchIfEmpty(Observable.just((Object)ApiUtils.noContent())).toBlocking().lastOrDefault(null);
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @GET
    @Path(value="/{id}/tags")
    public Response getMetricTags(@PathParam(value="id") String id) {
        try {
            return (Response)this.metricsService.getMetricTags(new MetricId(this.tenantId, MetricType.COUNTER, id)).map(ApiUtils::valueToResponse).toBlocking().lastOrDefault(null);
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @PUT
    @Path(value="/{id}/tags")
    public Response updateMetricTags(@PathParam(value="id") String id, Map<String, String> tags) {
        Metric metric = new Metric(new MetricId(this.tenantId, MetricType.COUNTER, id));
        try {
            this.metricsService.addTags(metric, tags).toBlocking().lastOrDefault(null);
            return Response.ok().build();
        }
        catch (IllegalArgumentException e1) {
            return ApiUtils.badRequest((ApiError)new ApiError(e1.getMessage()));
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @DELETE
    @Path(value="/{id}/tags/{tags}")
    public Response deleteMetricTags(@PathParam(value="id") String id, @PathParam(value="tags") Tags tags) {
        try {
            Metric metric = new Metric(new MetricId(this.tenantId, MetricType.COUNTER, id));
            this.metricsService.deleteTags(metric, tags.getTags()).toBlocking().lastOrDefault(null);
            return Response.ok().build();
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @POST
    @Path(value="/data")
    public Response addData(List<Metric<Long>> counters) {
        Observable metrics = Functions.metricToObservable((String)this.tenantId, counters, (MetricType)MetricType.COUNTER);
        try {
            this.metricsService.addDataPoints(MetricType.COUNTER, metrics).toBlocking().lastOrDefault(null);
            return Response.ok().build();
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @POST
    @Path(value="/{id}/data")
    public Response addData(@PathParam(value="id") String id, List<DataPoint<Long>> data) {
        Observable metrics = Functions.dataPointToObservable((String)this.tenantId, (String)id, data, (MetricType)MetricType.COUNTER);
        try {
            this.metricsService.addDataPoints(MetricType.COUNTER, metrics).toBlocking().lastOrDefault(null);
            return Response.ok().build();
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @GET
    @Path(value="/{id}/data")
    public Response findCounterData(@PathParam(value="id") String id, @QueryParam(value="start") Long start, @QueryParam(value="end") Long end, @QueryParam(value="fromEarliest") Boolean fromEarliest, @QueryParam(value="buckets") Integer bucketsCount, @QueryParam(value="bucketDuration") Duration bucketDuration, @QueryParam(value="percentiles") Percentiles percentiles, @QueryParam(value="limit") Integer limit, @QueryParam(value="order") Order order) {
        MetricId metricId = new MetricId(this.tenantId, MetricType.COUNTER, id);
        if (!(bucketsCount == null && bucketDuration == null || limit == null && order == null)) {
            return ApiUtils.badRequest((ApiError)new ApiError("Limit and order cannot be used with bucketed results"));
        }
        if (bucketsCount == null && bucketDuration == null && !Boolean.TRUE.equals(fromEarliest)) {
            TimeRange timeRange = new TimeRange(start, end);
            if (!timeRange.isValid()) {
                return ApiUtils.badRequest((ApiError)new ApiError(timeRange.getProblem()));
            }
            if (limit != null) {
                if (order == null) {
                    order = start == null && end != null ? Order.DESC : (start != null && end == null ? Order.ASC : Order.DESC);
                }
            } else {
                limit = 0;
            }
            if (order == null) {
                order = Order.DESC;
            }
            try {
                return (Response)this.metricsService.findDataPoints(metricId, timeRange.getStart(), timeRange.getEnd(), limit.intValue(), order).toList().map(ApiUtils::collectionToResponse).toBlocking().lastOrDefault(null);
            }
            catch (Exception e) {
                return ApiUtils.serverError((Throwable)e);
            }
        }
        Observable observableConfig = null;
        if (Boolean.TRUE.equals(fromEarliest)) {
            if (start != null || end != null) {
                return ApiUtils.badRequest((ApiError)new ApiError("fromEarliest can only be used without start & end"));
            }
            if (bucketsCount == null && bucketDuration == null) {
                return ApiUtils.badRequest((ApiError)new ApiError("fromEarliest can only be used with bucketed results"));
            }
            observableConfig = this.metricsService.findMetric(metricId).map(metric -> {
                long dataRetention = (long)(metric.getDataRetention() * 24 * 60 * 60) * 1000L;
                long now = System.currentTimeMillis();
                long earliest = now - dataRetention;
                BucketConfig bucketConfig = new BucketConfig(bucketsCount, bucketDuration, new TimeRange(Long.valueOf(earliest), Long.valueOf(now)));
                if (!bucketConfig.isValid()) {
                    throw new RuntimeApiError(bucketConfig.getProblem());
                }
                return bucketConfig;
            });
        } else {
            TimeRange timeRange = new TimeRange(start, end);
            if (!timeRange.isValid()) {
                return ApiUtils.badRequest((ApiError)new ApiError(timeRange.getProblem()));
            }
            BucketConfig bucketConfig = new BucketConfig(bucketsCount, bucketDuration, timeRange);
            if (!bucketConfig.isValid()) {
                return ApiUtils.badRequest((ApiError)new ApiError(bucketConfig.getProblem()));
            }
            observableConfig = Observable.just((Object)bucketConfig);
        }
        Percentiles lPercentiles = percentiles != null ? percentiles : new Percentiles(Collections.emptyList());
        try {
            return (Response)observableConfig.flatMap(config -> this.metricsService.findCounterStats(metricId, config.getTimeRange().getStart(), config.getTimeRange().getEnd(), config.getBuckets(), lPercentiles.getPercentiles())).flatMap(Observable::from).skipWhile(bucket -> Boolean.TRUE.equals(fromEarliest) && bucket.isEmpty()).toList().map(ApiUtils::collectionToResponse).toBlocking().lastOrDefault(null);
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @GET
    @Path(value="/{id}/rate")
    public Response findRate(@PathParam(value="id") String id, @QueryParam(value="start") Long start, @QueryParam(value="end") Long end, @QueryParam(value="buckets") Integer bucketsCount, @QueryParam(value="bucketDuration") Duration bucketDuration, @QueryParam(value="percentiles") Percentiles percentiles) {
        TimeRange timeRange = new TimeRange(start, end);
        if (!timeRange.isValid()) {
            return ApiUtils.badRequest((ApiError)new ApiError(timeRange.getProblem()));
        }
        BucketConfig bucketConfig = new BucketConfig(bucketsCount, bucketDuration, timeRange);
        if (!bucketConfig.isValid()) {
            return ApiUtils.badRequest((ApiError)new ApiError(bucketConfig.getProblem()));
        }
        MetricId metricId = new MetricId(this.tenantId, MetricType.COUNTER, id);
        Buckets buckets = bucketConfig.getBuckets();
        try {
            if (buckets == null) {
                return (Response)this.metricsService.findRateData(metricId, timeRange.getStart(), timeRange.getEnd()).toList().map(ApiUtils::collectionToResponse).toBlocking().lastOrDefault(null);
            }
            if (percentiles == null) {
                percentiles = new Percentiles(Collections.emptyList());
            }
            return (Response)this.metricsService.findRateStats(metricId, timeRange.getStart(), timeRange.getEnd(), buckets, percentiles.getPercentiles()).map(ApiUtils::collectionToResponse).toBlocking().lastOrDefault(null);
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @GET
    @Path(value="/data")
    public Response findCounterDataStats(@QueryParam(value="start") Long start, @QueryParam(value="end") Long end, @QueryParam(value="tags") Tags tags, @QueryParam(value="buckets") Integer bucketsCount, @QueryParam(value="bucketDuration") Duration bucketDuration, @QueryParam(value="percentiles") Percentiles percentiles, @QueryParam(value="metrics") List<String> metricNames, @DefaultValue(value="false") @QueryParam(value="stacked") Boolean stacked) {
        TimeRange timeRange = new TimeRange(start, end);
        if (!timeRange.isValid()) {
            return ApiUtils.badRequest((ApiError)new ApiError(timeRange.getProblem()));
        }
        BucketConfig bucketConfig = new BucketConfig(bucketsCount, bucketDuration, timeRange);
        if (bucketConfig.isEmpty()) {
            return ApiUtils.badRequest((ApiError)new ApiError("Either the buckets or bucketsDuration parameter must be used"));
        }
        if (!bucketConfig.isValid()) {
            return ApiUtils.badRequest((ApiError)new ApiError(bucketConfig.getProblem()));
        }
        if (metricNames.isEmpty() && (tags == null || tags.getTags().isEmpty())) {
            return ApiUtils.badRequest((ApiError)new ApiError("Either metrics or tags parameter must be used"));
        }
        if (!metricNames.isEmpty() && tags != null && !tags.getTags().isEmpty()) {
            return ApiUtils.badRequest((ApiError)new ApiError("Cannot use both the metrics and tags parameters"));
        }
        if (percentiles == null) {
            percentiles = new Percentiles(Collections.emptyList());
        }
        if (metricNames.isEmpty()) {
            return (Response)this.metricsService.findNumericStats(this.tenantId, MetricType.COUNTER, tags.getTags(), timeRange.getStart(), timeRange.getEnd(), bucketConfig.getBuckets(), percentiles.getPercentiles(), stacked.booleanValue()).map(ApiUtils::collectionToResponse).toBlocking().lastOrDefault(null);
        }
        return (Response)this.metricsService.findNumericStats(this.tenantId, MetricType.COUNTER, metricNames, timeRange.getStart(), timeRange.getEnd(), bucketConfig.getBuckets(), percentiles.getPercentiles(), stacked.booleanValue()).map(ApiUtils::collectionToResponse).toBlocking().lastOrDefault(null);
    }

    @GET
    @Path(value="/rate")
    public Response findCounterRateDataStats(@QueryParam(value="start") Long start, @QueryParam(value="end") Long end, @QueryParam(value="tags") Tags tags, @QueryParam(value="buckets") Integer bucketsCount, @QueryParam(value="bucketDuration") Duration bucketDuration, @QueryParam(value="percentiles") Percentiles percentiles, @QueryParam(value="metrics") List<String> metricNames, @DefaultValue(value="false") @QueryParam(value="stacked") Boolean stacked) {
        TimeRange timeRange = new TimeRange(start, end);
        if (!timeRange.isValid()) {
            return ApiUtils.badRequest((ApiError)new ApiError(timeRange.getProblem()));
        }
        BucketConfig bucketConfig = new BucketConfig(bucketsCount, bucketDuration, timeRange);
        if (bucketConfig.isEmpty()) {
            return ApiUtils.badRequest((ApiError)new ApiError("Either the buckets or bucketsDuration parameter must be used"));
        }
        if (!bucketConfig.isValid()) {
            return ApiUtils.badRequest((ApiError)new ApiError(bucketConfig.getProblem()));
        }
        if (metricNames.isEmpty() && (tags == null || tags.getTags().isEmpty())) {
            return ApiUtils.badRequest((ApiError)new ApiError("Either metrics or tags parameter must be used"));
        }
        if (!metricNames.isEmpty() && tags != null && !tags.getTags().isEmpty()) {
            return ApiUtils.badRequest((ApiError)new ApiError("Cannot use both the metrics and tags parameters"));
        }
        if (percentiles == null) {
            percentiles = new Percentiles(Collections.emptyList());
        }
        if (metricNames.isEmpty()) {
            return (Response)this.metricsService.findNumericStats(this.tenantId, MetricType.COUNTER_RATE, tags.getTags(), timeRange.getStart(), timeRange.getEnd(), bucketConfig.getBuckets(), percentiles.getPercentiles(), stacked.booleanValue()).map(ApiUtils::collectionToResponse).toBlocking().lastOrDefault(null);
        }
        return (Response)this.metricsService.findNumericStats(this.tenantId, MetricType.COUNTER_RATE, metricNames, timeRange.getStart(), timeRange.getEnd(), bucketConfig.getBuckets(), percentiles.getPercentiles(), stacked.booleanValue()).map(ApiUtils::collectionToResponse).toBlocking().lastOrDefault(null);
    }
}

