/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.handler;

import java.net.URI;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.metrics.api.jaxrs.util.ApiUtils;
import org.hawkular.metrics.core.service.MetricsService;
import org.hawkular.metrics.model.ApiError;
import org.hawkular.metrics.model.TenantDefinition;
import org.hawkular.metrics.model.exception.TenantAlreadyExistsException;

@Path(value="/tenants")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class TenantsHandler {
    @Inject
    private MetricsService metricsService;

    @POST
    public Response createTenant(TenantDefinition tenantDefinition, @Context UriInfo uriInfo) {
        URI location = uriInfo.getBaseUriBuilder().path("/tenants").build(new Object[0]);
        try {
            this.metricsService.createTenant(tenantDefinition.toTenant()).toBlocking().lastOrDefault(null);
            return Response.created((URI)location).build();
        }
        catch (TenantAlreadyExistsException e) {
            String message = "A tenant with id [" + e.getTenantId() + "] already exists";
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)new ApiError(message)).build();
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @GET
    public Response findTenants() {
        try {
            return (Response)this.metricsService.getTenants().map(TenantDefinition::new).toList().map(ApiUtils::collectionToResponse).toBlocking().lastOrDefault(null);
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }
}

