/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.param;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.ws.rs.ext.Provider;
import org.hawkular.metrics.model.param.Duration;
import org.jboss.resteasy.spi.StringConverter;

@Provider
public class DurationConverter
implements StringConverter<Duration> {
    private static final ImmutableBiMap<String, TimeUnit> STRING_UNITS = Duration.UNITS.inverse();
    private static final Pattern REGEXP = Pattern.compile("(\\d+)(" + Duration.UNITS.values().stream().collect(Collectors.joining("|")) + ")");

    public Duration fromString(String value) {
        Matcher matcher = REGEXP.matcher(value);
        Preconditions.checkArgument((boolean)matcher.matches(), (String)"Invalid duration %s", (Object[])new Object[]{value});
        return new Duration(Long.valueOf(matcher.group(1)).longValue(), (TimeUnit)((Object)STRING_UNITS.get((Object)matcher.group(2))));
    }

    public String toString(Duration duration) {
        return duration.getValue() + (String)Duration.UNITS.get((Object)duration.getTimeUnit());
    }
}

