/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.filter;

import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.hawkular.metrics.api.jaxrs.ApiError;
import org.hawkular.metrics.api.jaxrs.MetricsServiceLifecycle;
import org.jboss.resteasy.annotations.interception.ServerInterceptor;
import org.jboss.resteasy.core.ResourceMethod;
import org.jboss.resteasy.core.ServerResponse;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.interception.PreProcessInterceptor;

@Provider
@ServerInterceptor
public class MetricsServiceStateFilter
implements PreProcessInterceptor {
    private static final String STARTING = "Service unavailable while initializing.";
    private static final String FAILED = "Internal server error.";
    private static final String STOPPED = "The service is no longer running.";
    @Inject
    private MetricsServiceLifecycle metricsServiceLifecycle;

    public ServerResponse preProcess(HttpRequest request, ResourceMethod method) throws Failure, WebApplicationException {
        String path = request.getUri().getPath();
        if (path.startsWith("/status")) {
            return null;
        }
        if (this.metricsServiceLifecycle.getState() == MetricsServiceLifecycle.State.STARTING) {
            Response response = Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new ApiError(STARTING)).build();
            return ServerResponse.copyIfNotServerResponse((Response)response);
        }
        if (this.metricsServiceLifecycle.getState() == MetricsServiceLifecycle.State.FAILED) {
            Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new ApiError(FAILED)).build();
            return ServerResponse.copyIfNotServerResponse((Response)response);
        }
        if (this.metricsServiceLifecycle.getState() == MetricsServiceLifecycle.State.STOPPED || this.metricsServiceLifecycle.getState() == MetricsServiceLifecycle.State.STOPPING) {
            Response response = Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new ApiError(STOPPED)).build();
            return ServerResponse.copyIfNotServerResponse((Response)response);
        }
        return null;
    }
}

