/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.handler;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.metrics.api.jaxrs.ApiError;
import org.hawkular.metrics.api.jaxrs.model.Availability;
import org.hawkular.metrics.api.jaxrs.model.AvailabilityDataPoint;
import org.hawkular.metrics.api.jaxrs.param.Duration;
import org.hawkular.metrics.api.jaxrs.param.Tags;
import org.hawkular.metrics.api.jaxrs.request.MetricDefinition;
import org.hawkular.metrics.api.jaxrs.request.TagRequest;
import org.hawkular.metrics.api.jaxrs.util.ApiUtils;
import org.hawkular.metrics.core.api.Buckets;
import org.hawkular.metrics.core.api.Metric;
import org.hawkular.metrics.core.api.MetricAlreadyExistsException;
import org.hawkular.metrics.core.api.MetricId;
import org.hawkular.metrics.core.api.MetricType;
import org.hawkular.metrics.core.api.MetricsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

@Path(value="/availability")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(value="", description="Availability metrics interface")
public class AvailabilityHandler {
    private static final long EIGHT_HOURS = TimeUnit.MILLISECONDS.convert(8L, TimeUnit.HOURS);
    private static final Logger logger = LoggerFactory.getLogger(AvailabilityHandler.class);
    @Inject
    private MetricsService metricsService;
    @HeaderParam(value="Hawkular-Tenant")
    private String tenantId;

    @POST
    @Path(value="/")
    @ApiOperation(value="Create availability metric definition. Same notes as creating gauge metric apply.")
    @ApiResponses(value={@ApiResponse(code=201, message="Metric definition created successfully"), @ApiResponse(code=400, message="Missing or invalid payload", response=ApiError.class), @ApiResponse(code=409, message="Availability metric with given id already exists", response=ApiError.class), @ApiResponse(code=500, message="Metric definition creation failed due to an unexpected error", response=ApiError.class)})
    public Response createAvailabilityMetric(@ApiParam(required=true) MetricDefinition metricDefinition, @Context UriInfo uriInfo) {
        URI location = uriInfo.getBaseUriBuilder().path("/availability/{id}").build(new Object[]{metricDefinition.getId()});
        Metric metric = new Metric(new MetricId(this.tenantId, MetricType.AVAILABILITY, metricDefinition.getId()), metricDefinition.getTags(), metricDefinition.getDataRetention());
        try {
            Observable observable = this.metricsService.createMetric(metric);
            observable.toBlocking().lastOrDefault(null);
            return Response.created((URI)location).build();
        }
        catch (MetricAlreadyExistsException e) {
            String message = "A metric with name [" + e.getMetric().getId().getName() + "] already exists";
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)new ApiError(message)).build();
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @GET
    @Path(value="/{id}")
    @ApiOperation(value="Retrieve single metric definition.", response=MetricDefinition.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Metric's definition was successfully retrieved."), @ApiResponse(code=204, message="Query was successful, but no metrics definition is set."), @ApiResponse(code=500, message="Unexpected error occurred while fetching metric's definition.", response=ApiError.class)})
    public Response getAvailabilityMetric(@HeaderParam(value="tenantId") String tenantId, @PathParam(value="id") String id) {
        try {
            return (Response)this.metricsService.findMetric(new MetricId(tenantId, MetricType.AVAILABILITY, id)).map(MetricDefinition::new).map(metricDef -> Response.ok((Object)metricDef).build()).switchIfEmpty(Observable.just((Object)ApiUtils.noContent())).toBlocking().firstOrDefault(null);
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @GET
    @Path(value="/{id}/tags")
    @ApiOperation(value="Retrieve tags associated with the metric definition.", response=String.class, responseContainer="Map")
    @ApiResponses(value={@ApiResponse(code=200, message="Metric's tags were successfully retrieved."), @ApiResponse(code=204, message="Query was successful, but no metrics were found."), @ApiResponse(code=500, message="Unexpected error occurred while fetching metric's tags.", response=ApiError.class)})
    public Response getAvailabilityMetricTags(@PathParam(value="id") String id) {
        Observable something = this.metricsService.getMetricTags(new MetricId(this.tenantId, MetricType.AVAILABILITY, id));
        try {
            return (Response)something.map(optional -> ApiUtils.valueToResponse((Optional)optional)).toBlocking().lastOrDefault(null);
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @PUT
    @Path(value="/{id}/tags")
    @ApiOperation(value="Update tags associated with the metric definition.")
    @ApiResponses(value={@ApiResponse(code=200, message="Metric's tags were successfully updated."), @ApiResponse(code=500, message="Unexpected error occurred while updating metric's tags.", response=ApiError.class)})
    public Response updateAvailabilityMetricTags(@PathParam(value="id") String id, @ApiParam(required=true) Map<String, String> tags) {
        Metric metric = new Metric(new MetricId(this.tenantId, MetricType.AVAILABILITY, id));
        try {
            this.metricsService.addTags(metric, tags).toBlocking().lastOrDefault(null);
            return Response.ok().build();
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @DELETE
    @Path(value="/{id}/tags/{tags}")
    @ApiOperation(value="Delete tags associated with the metric definition.")
    @ApiResponses(value={@ApiResponse(code=200, message="Metric's tags were successfully deleted."), @ApiResponse(code=400, message="Invalid tags", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error occurred while trying to delete metric's tags.", response=ApiError.class)})
    public Response deleteAvailabilityMetricTags(@PathParam(value="id") String id, @ApiParam(value="Tag list") @PathParam(value="tags") Tags tags) {
        Metric metric = new Metric(new MetricId(this.tenantId, MetricType.AVAILABILITY, id));
        try {
            this.metricsService.deleteTags(metric, tags.getTags()).toBlocking().lastOrDefault(null);
            return Response.ok().build();
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @POST
    @Path(value="/{id}/data")
    @ApiOperation(value="Add data for a single availability metric.")
    @ApiResponses(value={@ApiResponse(code=200, message="Adding data succeeded."), @ApiResponse(code=400, message="Missing or invalid payload", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error happened while storing the data", response=ApiError.class)})
    public Response addAvailabilityForMetric(@PathParam(value="id") String id, @ApiParam(value="List of availability datapoints", required=true) List<AvailabilityDataPoint> data) {
        Metric metric = new Metric(new MetricId(this.tenantId, MetricType.AVAILABILITY, id), ApiUtils.requestToAvailabilityDataPoints(data));
        try {
            this.metricsService.addAvailabilityData(Observable.just((Object)metric)).toBlocking().lastOrDefault(null);
            return Response.ok().build();
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @POST
    @Path(value="/data")
    @ApiOperation(value="Add metric data for multiple availability metrics in a single call.")
    @ApiResponses(value={@ApiResponse(code=200, message="Adding data succeeded."), @ApiResponse(code=400, message="Missing or invalid payload", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error happened while storing the data", response=ApiError.class)})
    public Response addAvailabilityData(@ApiParam(value="List of availability metrics", required=true) List<Availability> availabilities) {
        try {
            this.metricsService.addAvailabilityData(ApiUtils.requestToAvailabilities((String)this.tenantId, availabilities)).toBlocking().lastOrDefault(null);
            return Response.ok().build();
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @GET
    @Path(value="/")
    @ApiOperation(value="Find availabilities metrics data by their tags.", response=Map.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully fetched data."), @ApiResponse(code=204, message="No matching data found."), @ApiResponse(code=400, message="Missing or invalid tags query", response=ApiError.class), @ApiResponse(code=500, message="Any error in the query.", response=ApiError.class)})
    public Response findAvailabilityDataByTags(@ApiParam(value="Tag list", required=true) @QueryParam(value="tags") Tags tags) {
        if (tags == null) {
            return ApiUtils.badRequest((ApiError)new ApiError("Missing tags query"));
        }
        try {
            return (Response)this.metricsService.findAvailabilityByTags(this.tenantId, tags.getTags()).map(m -> {
                if (m.isEmpty()) {
                    return ApiUtils.noContent();
                }
                return Response.ok((Object)m).build();
            }).toBlocking().lastOrDefault(null);
        }
        catch (Exception e) {
            return Response.serverError().entity((Object)new ApiError(e.getMessage())).build();
        }
    }

    @GET
    @Path(value="/{id}/data")
    @ApiOperation(value="Retrieve availability data. When buckets or bucketDuration query parameter is used, the time range between start and end will be divided in buckets of equal duration, and availability statistics will be computed for each bucket.", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully fetched availability data."), @ApiResponse(code=204, message="No availability data was found."), @ApiResponse(code=400, message="buckets or bucketDuration parameter is invalid, or both are used.", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error occurred while fetching availability data.", response=ApiError.class)})
    public Response findAvailabilityData(@PathParam(value="id") String id, @ApiParam(value="Defaults to now - 8 hours") @QueryParam(value="start") Long start, @ApiParam(value="Defaults to now") @QueryParam(value="end") Long end, @ApiParam(value="Total number of buckets") @QueryParam(value="buckets") Integer bucketsCount, @ApiParam(value="Bucket duration") @QueryParam(value="bucketDuration") Duration bucketDuration, @ApiParam(value="Set to true to return only distinct, contiguous values") @QueryParam(value="distinct") @DefaultValue(value="false") Boolean distinct) {
        Buckets buckets;
        long now = System.currentTimeMillis();
        Long startTime = start == null ? now - EIGHT_HOURS : start;
        Long endTime = end == null ? now : end;
        MetricId metricId = new MetricId(this.tenantId, MetricType.AVAILABILITY, id);
        if (bucketsCount == null && bucketDuration == null) {
            try {
                return (Response)this.metricsService.findAvailabilityData(metricId, startTime.longValue(), endTime.longValue(), distinct.booleanValue()).map(AvailabilityDataPoint::new).toList().map(ApiUtils::collectionToResponse).toBlocking().lastOrDefault(null);
            }
            catch (Exception e) {
                logger.warn("Failed to fetch availability data", (Throwable)e);
                return ApiUtils.serverError((Throwable)e);
            }
        }
        if (bucketsCount != null && bucketDuration != null) {
            return ApiUtils.badRequest((ApiError)new ApiError("Both buckets and bucketDuration parameters are used"));
        }
        try {
            buckets = bucketsCount != null ? Buckets.fromCount((long)startTime, (long)endTime, (int)bucketsCount) : Buckets.fromStep((long)startTime, (long)endTime, (long)bucketDuration.toMillis());
        }
        catch (IllegalArgumentException e) {
            return ApiUtils.badRequest((ApiError)new ApiError("Bucket: " + e.getMessage()));
        }
        try {
            return (Response)this.metricsService.findAvailabilityStats(metricId, startTime.longValue(), endTime.longValue(), buckets).map(ApiUtils::collectionToResponse).toBlocking().lastOrDefault(null);
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @POST
    @Path(value="/{id}/tag")
    @ApiOperation(value="Add or update availability metric's tags.")
    @ApiResponses(value={@ApiResponse(code=200, message="Tags were modified successfully."), @ApiResponse(code=400, message="Missing or invalid payload", response=ApiError.class)})
    public Response tagAvailabilityData(@PathParam(value="id") String id, @ApiParam(required=true) TagRequest params) {
        Metric metric = new Metric(new MetricId(this.tenantId, MetricType.AVAILABILITY, id));
        Observable resultSetObservable = params.getTimestamp() != null ? this.metricsService.tagAvailabilityData(metric, params.getTags(), params.getTimestamp().longValue()) : this.metricsService.tagAvailabilityData(metric, params.getTags(), params.getStart().longValue(), params.getEnd().longValue());
        try {
            resultSetObservable.toBlocking().lastOrDefault(null);
            return Response.ok().build();
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @GET
    @Path(value="/tags/{tags}")
    @ApiOperation(value="Find availability metric data with given tags.", response=Map.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Availability values fetched successfully"), @ApiResponse(code=204, message="No matching data found."), @ApiResponse(code=400, message="Invalid tags", response=ApiError.class), @ApiResponse(code=500, message="Any error while fetching data.", response=ApiError.class)})
    public Response findTaggedAvailabilityData(@ApiParam(value="Tag list") @PathParam(value="tags") Tags tags) {
        try {
            return (Response)this.metricsService.findAvailabilityByTags(this.tenantId, tags.getTags()).map(m -> {
                if (m.isEmpty()) {
                    return ApiUtils.noContent();
                }
                return Response.ok((Object)m).build();
            }).toBlocking().lastOrDefault(null);
        }
        catch (Exception e) {
            return Response.serverError().entity((Object)new ApiError(e.getMessage())).build();
        }
    }
}

