/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.filter;

import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.hawkular.metrics.api.jaxrs.model.ApiError;
import org.jboss.resteasy.annotations.interception.ServerInterceptor;
import org.jboss.resteasy.core.ResourceMethod;
import org.jboss.resteasy.core.ServerResponse;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.interception.PreProcessInterceptor;

@Provider
@ServerInterceptor
public class TenantFilter
implements PreProcessInterceptor {
    public static final String TENANT_HEADER_NAME = "Hawkular-Tenant";
    private static final String MISSING_TENANT_MSG = "Tenant is not specified. Use 'Hawkular-Tenant' header.";

    public ServerResponse preProcess(HttpRequest request, ResourceMethod method) throws Failure, WebApplicationException {
        String tenant;
        String path = request.getUri().getPath();
        if (path.startsWith("/tenants") || path.startsWith("/db") || path.startsWith("/status") || path.equals("/") || path.equals("") || path.startsWith("/clock")) {
            return null;
        }
        List requestHeader = request.getHttpHeaders().getRequestHeader(TENANT_HEADER_NAME);
        String string = tenant = requestHeader != null && !requestHeader.isEmpty() ? (String)requestHeader.get(0) : null;
        if (tenant != null && !tenant.trim().isEmpty()) {
            return null;
        }
        Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new ApiError(MISSING_TENANT_MSG)).build();
        return ServerResponse.copyIfNotServerResponse((Response)response);
    }
}

