/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.handler;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.metrics.api.jaxrs.model.ApiError;
import org.hawkular.metrics.api.jaxrs.model.Gauge;
import org.hawkular.metrics.api.jaxrs.model.GaugeDataPoint;
import org.hawkular.metrics.api.jaxrs.model.MetricDefinition;
import org.hawkular.metrics.api.jaxrs.param.BucketConfig;
import org.hawkular.metrics.api.jaxrs.param.Duration;
import org.hawkular.metrics.api.jaxrs.param.Percentiles;
import org.hawkular.metrics.api.jaxrs.param.Tags;
import org.hawkular.metrics.api.jaxrs.param.TimeRange;
import org.hawkular.metrics.api.jaxrs.util.ApiUtils;
import org.hawkular.metrics.core.api.Buckets;
import org.hawkular.metrics.core.api.Metric;
import org.hawkular.metrics.core.api.MetricAlreadyExistsException;
import org.hawkular.metrics.core.api.MetricId;
import org.hawkular.metrics.core.api.MetricType;
import org.hawkular.metrics.core.api.MetricsService;
import rx.Observable;

@Path(value="/gauges")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class GaugeHandler {
    @Inject
    private MetricsService metricsService;
    @HeaderParam(value="Hawkular-Tenant")
    private String tenantId;

    @POST
    @Produces(value={"application/json"})
    @Path(value="/")
    public Response createGaugeMetric(MetricDefinition metricDefinition, @Context UriInfo uriInfo) {
        if (metricDefinition.getType() != null && MetricType.GAUGE != metricDefinition.getType()) {
            return ApiUtils.badRequest((ApiError)new ApiError("MetricDefinition type does not match " + MetricType.GAUGE.getText()));
        }
        Metric metric = new Metric(new MetricId(this.tenantId, MetricType.GAUGE, metricDefinition.getId()), metricDefinition.getTags(), metricDefinition.getDataRetention());
        URI location = uriInfo.getBaseUriBuilder().path("/gauges/{id}").build(new Object[]{metric.getId().getName()});
        try {
            Observable observable = this.metricsService.createMetric(metric);
            observable.toBlocking().lastOrDefault(null);
            return Response.created((URI)location).build();
        }
        catch (MetricAlreadyExistsException e) {
            String message = "A metric with name [" + e.getMetric().getId().getName() + "] already exists";
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)new ApiError(message)).build();
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    public Response getGaugeMetric(@PathParam(value="id") String id) {
        try {
            return (Response)this.metricsService.findMetric(new MetricId(this.tenantId, MetricType.GAUGE, id)).map(MetricDefinition::new).map(metricDef -> Response.ok((Object)metricDef).build()).switchIfEmpty(Observable.just((Object)ApiUtils.noContent())).toBlocking().lastOrDefault(null);
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{id}/tags")
    public Response getMetricTags(@PathParam(value="id") String id) {
        try {
            return (Response)this.metricsService.getMetricTags(new MetricId(this.tenantId, MetricType.GAUGE, id)).map(ApiUtils::valueToResponse).toBlocking().lastOrDefault(null);
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/{id}/tags")
    public Response updateMetricTags(@PathParam(value="id") String id, Map<String, String> tags) {
        Metric metric = new Metric(new MetricId(this.tenantId, MetricType.GAUGE, id));
        try {
            this.metricsService.addTags(metric, tags).toBlocking().lastOrDefault(null);
            return Response.ok().build();
        }
        catch (IllegalArgumentException e1) {
            return ApiUtils.badRequest((ApiError)new ApiError(e1.getMessage()));
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/{id}/tags/{tags}")
    public Response deleteMetricTags(@PathParam(value="id") String id, @PathParam(value="tags") Tags tags) {
        try {
            Metric metric = new Metric(new MetricId(this.tenantId, MetricType.GAUGE, id));
            this.metricsService.deleteTags(metric, tags.getTags()).toBlocking().lastOrDefault(null);
            return Response.ok().build();
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/{id}/data")
    public Response addDataForMetric(@PathParam(value="id") String id, List<GaugeDataPoint> data) {
        Observable metrics = GaugeDataPoint.toObservable((String)this.tenantId, (String)id, data);
        try {
            this.metricsService.addDataPoints(MetricType.GAUGE, metrics).toBlocking().lastOrDefault(null);
            return Response.ok().build();
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/data")
    public Response addGaugeData(List<Gauge> gauges) {
        Observable metrics = Gauge.toObservable((String)this.tenantId, gauges);
        try {
            this.metricsService.addDataPoints(MetricType.GAUGE, metrics).toBlocking().lastOrDefault(null);
            return Response.ok().build();
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @GET
    @Path(value="/{id}/data")
    @Produces(value={"application/json"})
    public Response findGaugeData(@PathParam(value="id") String id, @QueryParam(value="start") Long start, @QueryParam(value="end") Long end, @QueryParam(value="buckets") Integer bucketsCount, @QueryParam(value="bucketDuration") Duration bucketDuration, @QueryParam(value="percentiles") Percentiles percentiles) {
        TimeRange timeRange = new TimeRange(start, end);
        if (!timeRange.isValid()) {
            return ApiUtils.badRequest((ApiError)new ApiError(timeRange.getProblem()));
        }
        BucketConfig bucketConfig = new BucketConfig(bucketsCount, bucketDuration, timeRange);
        if (!bucketConfig.isValid()) {
            return ApiUtils.badRequest((ApiError)new ApiError(bucketConfig.getProblem()));
        }
        MetricId metricId = new MetricId(this.tenantId, MetricType.GAUGE, id);
        Buckets buckets = bucketConfig.getBuckets();
        try {
            if (buckets == null) {
                return (Response)this.metricsService.findDataPoints(metricId, timeRange.getStart(), timeRange.getEnd()).map(GaugeDataPoint::new).toList().map(ApiUtils::collectionToResponse).toBlocking().lastOrDefault(null);
            }
            if (percentiles == null) {
                percentiles = new Percentiles(Collections.emptyList());
            }
            return (Response)this.metricsService.findGaugeStats(metricId, timeRange.getStart(), timeRange.getEnd(), buckets, percentiles.getPercentiles()).map(ApiUtils::collectionToResponse).toBlocking().lastOrDefault(null);
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @GET
    @Path(value="/data")
    public Response findGaugeData(@QueryParam(value="start") Long start, @QueryParam(value="end") Long end, @QueryParam(value="tags") Tags tags, @QueryParam(value="buckets") Integer bucketsCount, @QueryParam(value="bucketDuration") Duration bucketDuration, @QueryParam(value="percentiles") Percentiles percentiles, @QueryParam(value="metrics") List<String> metricNames, @DefaultValue(value="false") @QueryParam(value="stacked") Boolean stacked) {
        TimeRange timeRange = new TimeRange(start, end);
        if (!timeRange.isValid()) {
            return ApiUtils.badRequest((ApiError)new ApiError(timeRange.getProblem()));
        }
        BucketConfig bucketConfig = new BucketConfig(bucketsCount, bucketDuration, timeRange);
        if (bucketConfig.isEmpty()) {
            return ApiUtils.badRequest((ApiError)new ApiError("Either the buckets or bucketsDuration parameter must be used"));
        }
        if (!bucketConfig.isValid()) {
            return ApiUtils.badRequest((ApiError)new ApiError(bucketConfig.getProblem()));
        }
        if (metricNames.isEmpty() && (tags == null || tags.getTags().isEmpty())) {
            return ApiUtils.badRequest((ApiError)new ApiError("Either metrics or tags parameter must be used"));
        }
        if (!metricNames.isEmpty() && tags != null && !tags.getTags().isEmpty()) {
            return ApiUtils.badRequest((ApiError)new ApiError("Cannot use both the metrics and tags parameters"));
        }
        if (percentiles == null) {
            percentiles = new Percentiles(Collections.emptyList());
        }
        if (metricNames.isEmpty()) {
            return (Response)this.metricsService.findNumericStats(this.tenantId, MetricType.GAUGE, tags.getTags(), timeRange.getStart(), timeRange.getEnd(), bucketConfig.getBuckets(), percentiles.getPercentiles(), stacked.booleanValue()).map(ApiUtils::collectionToResponse).toBlocking().lastOrDefault(null);
        }
        return (Response)this.metricsService.findNumericStats(this.tenantId, MetricType.GAUGE, metricNames, timeRange.getStart(), timeRange.getEnd(), bucketConfig.getBuckets(), percentiles.getPercentiles(), stacked.booleanValue()).map(ApiUtils::collectionToResponse).toBlocking().lastOrDefault(null);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{id}/periods")
    public Response findPeriods(@PathParam(value="id") String id, @QueryParam(value="start") Long start, @QueryParam(value="end") Long end, @QueryParam(value="threshold") double threshold, @QueryParam(value="op") String operator) {
        Predicate<Double> predicate;
        TimeRange timeRange = new TimeRange(start, end);
        if (!timeRange.isValid()) {
            return ApiUtils.badRequest((ApiError)new ApiError(timeRange.getProblem()));
        }
        switch (operator) {
            case "lt": {
                predicate = d2 -> d2 < threshold;
                break;
            }
            case "lte": {
                predicate = d2 -> d2 <= threshold;
                break;
            }
            case "eq": {
                predicate = d2 -> d2 == threshold;
                break;
            }
            case "neq": {
                predicate = d2 -> d2 != threshold;
                break;
            }
            case "gt": {
                predicate = d2 -> d2 > threshold;
                break;
            }
            case "gte": {
                predicate = d2 -> d2 >= threshold;
                break;
            }
            default: {
                predicate = null;
            }
        }
        if (predicate == null) {
            return ApiUtils.badRequest((ApiError)new ApiError("Invalid value for op parameter. Supported values are lt, lte, eq, gt, gte."));
        }
        try {
            MetricId metricId = new MetricId(this.tenantId, MetricType.GAUGE, id);
            return (Response)this.metricsService.getPeriods(metricId, predicate, timeRange.getStart(), timeRange.getEnd()).map(ApiUtils::collectionToResponse).toBlocking().lastOrDefault(null);
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }
}

