/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.handler;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.metrics.api.jaxrs.model.ApiError;
import org.hawkular.metrics.api.jaxrs.model.Counter;
import org.hawkular.metrics.api.jaxrs.model.CounterDataPoint;
import org.hawkular.metrics.api.jaxrs.model.GaugeDataPoint;
import org.hawkular.metrics.api.jaxrs.model.MetricDefinition;
import org.hawkular.metrics.api.jaxrs.param.BucketConfig;
import org.hawkular.metrics.api.jaxrs.param.Duration;
import org.hawkular.metrics.api.jaxrs.param.Percentiles;
import org.hawkular.metrics.api.jaxrs.param.Tags;
import org.hawkular.metrics.api.jaxrs.param.TimeRange;
import org.hawkular.metrics.api.jaxrs.util.ApiUtils;
import org.hawkular.metrics.core.api.Buckets;
import org.hawkular.metrics.core.api.Metric;
import org.hawkular.metrics.core.api.MetricAlreadyExistsException;
import org.hawkular.metrics.core.api.MetricId;
import org.hawkular.metrics.core.api.MetricType;
import org.hawkular.metrics.core.api.MetricsService;
import rx.Observable;

@Path(value="/counters")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class CounterHandler {
    @Inject
    private MetricsService metricsService;
    @HeaderParam(value="Hawkular-Tenant")
    private String tenantId;

    @POST
    @Path(value="/")
    public Response createCounter(MetricDefinition metricDefinition, @Context UriInfo uriInfo) {
        if (metricDefinition.getType() != null && MetricType.COUNTER != metricDefinition.getType()) {
            return ApiUtils.badRequest((ApiError)new ApiError("MetricDefinition type does not match " + MetricType.COUNTER.getText()));
        }
        Metric metric = new Metric(new MetricId(this.tenantId, MetricType.COUNTER, metricDefinition.getId()), metricDefinition.getTags(), metricDefinition.getDataRetention());
        URI location = uriInfo.getBaseUriBuilder().path("/counters/{id}").build(new Object[]{metric.getId().getName()});
        try {
            Observable observable = this.metricsService.createMetric(metric);
            observable.toBlocking().lastOrDefault(null);
            return Response.created((URI)location).build();
        }
        catch (MetricAlreadyExistsException e) {
            String message = "A metric with name [" + e.getMetric().getId().getName() + "] already exists";
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)new ApiError(message)).build();
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @GET
    @Path(value="/{id}")
    public Response getCounter(@PathParam(value="id") String id) {
        try {
            return (Response)this.metricsService.findMetric(new MetricId(this.tenantId, MetricType.COUNTER, id)).map(MetricDefinition::new).map(metricDef -> Response.ok((Object)metricDef).build()).switchIfEmpty(Observable.just((Object)ApiUtils.noContent())).toBlocking().lastOrDefault(null);
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{id}/tags")
    public Response getMetricTags(@PathParam(value="id") String id) {
        try {
            return (Response)this.metricsService.getMetricTags(new MetricId(this.tenantId, MetricType.COUNTER, id)).map(ApiUtils::valueToResponse).toBlocking().lastOrDefault(null);
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/{id}/tags")
    public Response updateMetricTags(@PathParam(value="id") String id, Map<String, String> tags) {
        Metric metric = new Metric(new MetricId(this.tenantId, MetricType.COUNTER, id));
        try {
            this.metricsService.addTags(metric, tags).toBlocking().lastOrDefault(null);
            return Response.ok().build();
        }
        catch (IllegalArgumentException e1) {
            return ApiUtils.badRequest((ApiError)new ApiError(e1.getMessage()));
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/{id}/tags/{tags}")
    public Response deleteMetricTags(@PathParam(value="id") String id, @PathParam(value="tags") Tags tags) {
        try {
            Metric metric = new Metric(new MetricId(this.tenantId, MetricType.COUNTER, id));
            this.metricsService.deleteTags(metric, tags.getTags()).toBlocking().lastOrDefault(null);
            return Response.ok().build();
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @POST
    @Path(value="/data")
    public Response addData(List<Counter> counters) {
        Observable metrics = Counter.toObservable((String)this.tenantId, counters);
        try {
            this.metricsService.addDataPoints(MetricType.COUNTER, metrics).toBlocking().lastOrDefault(null);
            return Response.ok().build();
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @POST
    @Path(value="/{id}/data")
    public Response addData(@PathParam(value="id") String id, List<CounterDataPoint> data) {
        Observable metrics = CounterDataPoint.toObservable((String)this.tenantId, (String)id, data);
        try {
            this.metricsService.addDataPoints(MetricType.COUNTER, metrics).toBlocking().lastOrDefault(null);
            return Response.ok().build();
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @GET
    @Path(value="/{id}/data")
    public Response findCounterData(@PathParam(value="id") String id, @QueryParam(value="start") Long start, @QueryParam(value="end") Long end, @QueryParam(value="buckets") Integer bucketsCount, @QueryParam(value="bucketDuration") Duration bucketDuration, @QueryParam(value="percentiles") Percentiles percentiles) {
        TimeRange timeRange = new TimeRange(start, end);
        if (!timeRange.isValid()) {
            return ApiUtils.badRequest((ApiError)new ApiError(timeRange.getProblem()));
        }
        BucketConfig bucketConfig = new BucketConfig(bucketsCount, bucketDuration, timeRange);
        if (!bucketConfig.isValid()) {
            return ApiUtils.badRequest((ApiError)new ApiError(bucketConfig.getProblem()));
        }
        MetricId metricId = new MetricId(this.tenantId, MetricType.COUNTER, id);
        Buckets buckets = bucketConfig.getBuckets();
        try {
            if (buckets == null) {
                return (Response)this.metricsService.findDataPoints(metricId, timeRange.getStart(), timeRange.getEnd()).map(CounterDataPoint::new).toList().map(ApiUtils::collectionToResponse).toBlocking().lastOrDefault(null);
            }
            if (percentiles == null) {
                percentiles = new Percentiles(Collections.emptyList());
            }
            return (Response)this.metricsService.findCounterStats(metricId, timeRange.getStart(), timeRange.getEnd(), buckets, percentiles.getPercentiles()).map(ApiUtils::collectionToResponse).toBlocking().lastOrDefault(null);
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @GET
    @Path(value="/{id}/rate")
    public Response findRate(@PathParam(value="id") String id, @QueryParam(value="start") Long start, @QueryParam(value="end") Long end, @QueryParam(value="buckets") Integer bucketsCount, @QueryParam(value="bucketDuration") Duration bucketDuration, @QueryParam(value="percentiles") Percentiles percentiles) {
        TimeRange timeRange = new TimeRange(start, end);
        if (!timeRange.isValid()) {
            return ApiUtils.badRequest((ApiError)new ApiError(timeRange.getProblem()));
        }
        BucketConfig bucketConfig = new BucketConfig(bucketsCount, bucketDuration, timeRange);
        if (!bucketConfig.isValid()) {
            return ApiUtils.badRequest((ApiError)new ApiError(bucketConfig.getProblem()));
        }
        MetricId metricId = new MetricId(this.tenantId, MetricType.COUNTER, id);
        Buckets buckets = bucketConfig.getBuckets();
        try {
            if (buckets == null) {
                return (Response)this.metricsService.findRateData(metricId, timeRange.getStart(), timeRange.getEnd()).map(GaugeDataPoint::new).toList().map(ApiUtils::collectionToResponse).toBlocking().lastOrDefault(null);
            }
            if (percentiles == null) {
                percentiles = new Percentiles(Collections.emptyList());
            }
            return (Response)this.metricsService.findRateStats(metricId, timeRange.getStart(), timeRange.getEnd(), buckets, percentiles.getPercentiles()).map(ApiUtils::collectionToResponse).toBlocking().lastOrDefault(null);
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @GET
    @Path(value="/data")
    public Response findCounterDataStats(@QueryParam(value="start") Long start, @QueryParam(value="end") Long end, @QueryParam(value="tags") Tags tags, @QueryParam(value="buckets") Integer bucketsCount, @QueryParam(value="bucketDuration") Duration bucketDuration, @QueryParam(value="percentiles") Percentiles percentiles, @QueryParam(value="metrics") List<String> metricNames, @DefaultValue(value="false") @QueryParam(value="stacked") Boolean stacked) {
        TimeRange timeRange = new TimeRange(start, end);
        if (!timeRange.isValid()) {
            return ApiUtils.badRequest((ApiError)new ApiError(timeRange.getProblem()));
        }
        BucketConfig bucketConfig = new BucketConfig(bucketsCount, bucketDuration, timeRange);
        if (bucketConfig.isEmpty()) {
            return ApiUtils.badRequest((ApiError)new ApiError("Either the buckets or bucketsDuration parameter must be used"));
        }
        if (!bucketConfig.isValid()) {
            return ApiUtils.badRequest((ApiError)new ApiError(bucketConfig.getProblem()));
        }
        if (metricNames.isEmpty() && (tags == null || tags.getTags().isEmpty())) {
            return ApiUtils.badRequest((ApiError)new ApiError("Either metrics or tags parameter must be used"));
        }
        if (!metricNames.isEmpty() && tags != null && !tags.getTags().isEmpty()) {
            return ApiUtils.badRequest((ApiError)new ApiError("Cannot use both the metrics and tags parameters"));
        }
        if (percentiles == null) {
            percentiles = new Percentiles(Collections.emptyList());
        }
        if (metricNames.isEmpty()) {
            return (Response)this.metricsService.findNumericStats(this.tenantId, MetricType.COUNTER, tags.getTags(), timeRange.getStart(), timeRange.getEnd(), bucketConfig.getBuckets(), percentiles.getPercentiles(), stacked.booleanValue()).map(ApiUtils::collectionToResponse).toBlocking().lastOrDefault(null);
        }
        return (Response)this.metricsService.findNumericStats(this.tenantId, MetricType.COUNTER, metricNames, timeRange.getStart(), timeRange.getEnd(), bucketConfig.getBuckets(), percentiles.getPercentiles(), stacked.booleanValue()).map(ApiUtils::collectionToResponse).toBlocking().lastOrDefault(null);
    }

    @GET
    @Path(value="/data/rate")
    public Response findCounterRateDataStats(@QueryParam(value="start") Long start, @QueryParam(value="end") Long end, @QueryParam(value="tags") Tags tags, @QueryParam(value="buckets") Integer bucketsCount, @QueryParam(value="bucketDuration") Duration bucketDuration, @QueryParam(value="percentiles") Percentiles percentiles, @QueryParam(value="metrics") List<String> metricNames, @DefaultValue(value="false") @QueryParam(value="stacked") Boolean stacked) {
        TimeRange timeRange = new TimeRange(start, end);
        if (!timeRange.isValid()) {
            return ApiUtils.badRequest((ApiError)new ApiError(timeRange.getProblem()));
        }
        BucketConfig bucketConfig = new BucketConfig(bucketsCount, bucketDuration, timeRange);
        if (bucketConfig.isEmpty()) {
            return ApiUtils.badRequest((ApiError)new ApiError("Either the buckets or bucketsDuration parameter must be used"));
        }
        if (!bucketConfig.isValid()) {
            return ApiUtils.badRequest((ApiError)new ApiError(bucketConfig.getProblem()));
        }
        if (metricNames.isEmpty() && (tags == null || tags.getTags().isEmpty())) {
            return ApiUtils.badRequest((ApiError)new ApiError("Either metrics or tags parameter must be used"));
        }
        if (!metricNames.isEmpty() && tags != null && !tags.getTags().isEmpty()) {
            return ApiUtils.badRequest((ApiError)new ApiError("Cannot use both the metrics and tags parameters"));
        }
        if (percentiles == null) {
            percentiles = new Percentiles(Collections.emptyList());
        }
        if (metricNames.isEmpty()) {
            return (Response)this.metricsService.findNumericStats(this.tenantId, MetricType.COUNTER_RATE, tags.getTags(), timeRange.getStart(), timeRange.getEnd(), bucketConfig.getBuckets(), percentiles.getPercentiles(), stacked.booleanValue()).map(ApiUtils::collectionToResponse).toBlocking().lastOrDefault(null);
        }
        return (Response)this.metricsService.findNumericStats(this.tenantId, MetricType.COUNTER_RATE, metricNames, timeRange.getStart(), timeRange.getEnd(), bucketConfig.getBuckets(), percentiles.getPercentiles(), stacked.booleanValue()).map(ApiUtils::collectionToResponse).toBlocking().lastOrDefault(null);
    }
}

