/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs;

import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;
import org.hawkular.metrics.api.jaxrs.exception.mappers.ApplicationExceptionMapper;
import org.hawkular.metrics.api.jaxrs.exception.mappers.BadRequestExceptionMapper;
import org.hawkular.metrics.api.jaxrs.exception.mappers.NotAcceptableExceptionMapper;
import org.hawkular.metrics.api.jaxrs.exception.mappers.NotAllowedExceptionMapper;
import org.hawkular.metrics.api.jaxrs.exception.mappers.NotFoundExceptionMapper;
import org.hawkular.metrics.api.jaxrs.exception.mappers.NotSupportedExceptionMapper;
import org.hawkular.metrics.api.jaxrs.exception.mappers.ReaderExceptionMapper;
import org.hawkular.metrics.api.jaxrs.filter.CorsRequestFilter;
import org.hawkular.metrics.api.jaxrs.filter.CorsResponseFilter;
import org.hawkular.metrics.api.jaxrs.filter.EmptyPayloadFilter;
import org.hawkular.metrics.api.jaxrs.filter.MetricsServiceStateFilter;
import org.hawkular.metrics.api.jaxrs.filter.TenantFilter;
import org.hawkular.metrics.api.jaxrs.handler.AvailabilityHandler;
import org.hawkular.metrics.api.jaxrs.handler.BaseHandler;
import org.hawkular.metrics.api.jaxrs.handler.CounterHandler;
import org.hawkular.metrics.api.jaxrs.handler.GaugeHandler;
import org.hawkular.metrics.api.jaxrs.handler.MetricHandler;
import org.hawkular.metrics.api.jaxrs.handler.PingHandler;
import org.hawkular.metrics.api.jaxrs.handler.StatusHandler;
import org.hawkular.metrics.api.jaxrs.handler.TenantsHandler;
import org.hawkular.metrics.api.jaxrs.handler.VirtualClockHandler;
import org.hawkular.metrics.api.jaxrs.influx.InfluxSeriesHandler;
import org.hawkular.metrics.api.jaxrs.influx.param.ConvertersProvider;
import org.hawkular.metrics.api.jaxrs.interceptor.EmptyPayloadInterceptor;
import org.hawkular.metrics.api.jaxrs.log.RestLogger;
import org.hawkular.metrics.api.jaxrs.log.RestLogging;
import org.hawkular.metrics.api.jaxrs.util.JacksonConfig;

@ApplicationPath(value="/")
public class HawkularMetricsRestApp
extends Application {
    private static final RestLogger log = RestLogging.getRestLogger(HawkularMetricsRestApp.class);

    public HawkularMetricsRestApp() {
        log.infoAppStarting();
    }

    public Set<Class<?>> getClasses() {
        HashSet classes = new HashSet();
        classes.add(MetricHandler.class);
        classes.add(AvailabilityHandler.class);
        classes.add(InfluxSeriesHandler.class);
        classes.add(TenantsHandler.class);
        classes.add(GaugeHandler.class);
        classes.add(CounterHandler.class);
        classes.add(StatusHandler.class);
        classes.add(BaseHandler.class);
        classes.add(CounterHandler.class);
        classes.add(PingHandler.class);
        boolean useVirtualClock = Boolean.valueOf(System.getProperty("hawkular.metrics.use-virtual-clock", "false"));
        if (useVirtualClock) {
            log.infof("Deploying %s", (Object)VirtualClockHandler.class.getCanonicalName());
            classes.add(VirtualClockHandler.class);
        } else {
            log.info((Object)"Virtual clock is disabled");
        }
        classes.add(BadRequestExceptionMapper.class);
        classes.add(NotAcceptableExceptionMapper.class);
        classes.add(NotAllowedExceptionMapper.class);
        classes.add(NotFoundExceptionMapper.class);
        classes.add(ReaderExceptionMapper.class);
        classes.add(NotSupportedExceptionMapper.class);
        classes.add(ApplicationExceptionMapper.class);
        classes.add(EmptyPayloadFilter.class);
        classes.add(TenantFilter.class);
        classes.add(MetricsServiceStateFilter.class);
        classes.add(CorsResponseFilter.class);
        classes.add(CorsRequestFilter.class);
        classes.add(EmptyPayloadInterceptor.class);
        classes.add(org.hawkular.metrics.api.jaxrs.param.ConvertersProvider.class);
        classes.add(ConvertersProvider.class);
        classes.add(JacksonConfig.class);
        return classes;
    }
}

