/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.datastax.driver.core.Session;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import org.hawkular.metrics.api.jaxrs.DriverUsageMetricsManager;
import org.hawkular.metrics.api.jaxrs.util.MetricRegistryProvider;

/*
 * Exception performing whole class analysis ignored.
 */
@ApplicationScoped
public class DriverUsageMetricsManager {
    public void updateDriverUsageMetrics(Session session) {
        MetricRegistry metricRegistry = MetricRegistryProvider.INSTANCE.getMetricRegistry();
        Session.State state = session.getState();
        Set expectedHosts = state.getConnectedHosts().stream().map(DriverUsageMetric::getHostKey).collect(Collectors.toSet());
        HashSet<String> actualHosts = new HashSet<String>();
        for (String name : metricRegistry.getGauges().keySet()) {
            if (!name.startsWith("driver-usage-")) continue;
            for (DriverUsageMetric driverUsageMetric : DriverUsageMetric.values()) {
                if (!name.endsWith(driverUsageMetric.suffix)) continue;
                int beginIndex = "driver-usage-".length();
                int endIndex = name.length() - driverUsageMetric.suffix.length();
                actualHosts.add(name.substring(beginIndex, endIndex));
            }
        }
        HashSet toRemoveHosts = new HashSet(actualHosts);
        toRemoveHosts.removeAll(expectedHosts);
        toRemoveHosts.forEach(hostkey -> {
            for (DriverUsageMetric metric : DriverUsageMetric.values()) {
                metricRegistry.remove("driver-usage-" + hostkey + metric.suffix);
            }
        });
        HashSet toCreateHosts = new HashSet(expectedHosts);
        toCreateHosts.removeAll(actualHosts);
        state.getConnectedHosts().stream().map(DriverUsageMetric::getHostKey).filter(toCreateHosts::contains).forEach(hostkey -> {
            for (DriverUsageMetric driverUsageMetric : DriverUsageMetric.values()) {
                String metricName = "driver-usage-" + hostkey + driverUsageMetric.suffix;
                Gauge gauge = driverUsageMetric.createGauge(session, hostkey);
                metricRegistry.register(metricName, (Metric)gauge);
            }
        });
    }

    public void removeDriverUsageMetrics() {
        MetricRegistry metricRegistry = MetricRegistryProvider.INSTANCE.getMetricRegistry();
        metricRegistry.removeMatching((name, metric) -> name.startsWith("driver-usage-"));
    }
}

