/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.influx;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.apache.commons.math3.stat.descriptive.rank.Percentile;
import org.hawkular.metrics.api.jaxrs.influx.InfluxObject;
import org.hawkular.metrics.api.jaxrs.influx.InfluxTimeUnit;
import org.hawkular.metrics.api.jaxrs.influx.query.InfluxQueryParseTreeWalker;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.InfluxQueryParser;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.InfluxQueryParserFactory;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.QueryParseException;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.AggregatedColumnDefinition;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.BooleanExpression;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.FunctionArgument;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.GroupByClause;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.ListSeriesDefinitionsParser;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.NumberFunctionArgument;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.RegularExpression;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.SelectQueryDefinitions;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.SelectQueryDefinitionsParser;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.type.QueryType;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.type.QueryTypeVisitor;
import org.hawkular.metrics.api.jaxrs.influx.query.translate.ToIntervalTranslator;
import org.hawkular.metrics.api.jaxrs.influx.query.validation.AggregationFunction;
import org.hawkular.metrics.api.jaxrs.influx.query.validation.IllegalQueryException;
import org.hawkular.metrics.api.jaxrs.influx.query.validation.QueryValidator;
import org.hawkular.metrics.api.jaxrs.influx.write.validation.InfluxObjectValidator;
import org.hawkular.metrics.api.jaxrs.influx.write.validation.InvalidObjectException;
import org.hawkular.metrics.core.service.MetricTypeFilter;
import org.hawkular.metrics.core.service.MetricsService;
import org.hawkular.metrics.core.service.Order;
import org.hawkular.metrics.model.Buckets;
import org.hawkular.metrics.model.DataPoint;
import org.hawkular.metrics.model.Metric;
import org.hawkular.metrics.model.MetricId;
import org.hawkular.metrics.model.MetricType;
import org.jboss.logging.Logger;
import org.joda.time.Instant;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import rx.Observable;
import rx.Observer;

@Path(value="/db/{tenantId}/series")
@Produces(value={"application/json"})
@ApplicationScoped
public class InfluxSeriesHandler {
    private static final Logger log = Logger.getLogger(InfluxSeriesHandler.class);
    private static final EnumSet<InfluxTimeUnit> TIME_PRECISION_ALLOWED = EnumSet.of(InfluxTimeUnit.SECONDS, InfluxTimeUnit.MILLISECONDS, InfluxTimeUnit.MICROSECONDS);
    private static final String GAUGE_PREFIX = "_gauge.";
    private static final String COUNTER_PREFIX = "_counter.";
    @Inject
    MetricsService metricsService;
    @Inject
    InfluxObjectValidator objectValidator;
    @Inject
    @InfluxQueryParseTreeWalker
    ParseTreeWalker parseTreeWalker;
    @Inject
    InfluxQueryParserFactory parserFactory;
    @Inject
    QueryValidator queryValidator;
    @Inject
    ToIntervalTranslator toIntervalTranslator;

    @POST
    @Consumes(value={"application/json"})
    public void write(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, @QueryParam(value="time_precision") InfluxTimeUnit timePrecision, List<InfluxObject> influxObjects) {
        if (influxObjects == null) {
            asyncResponse.resume((Object)this.errorResponse(Response.Status.BAD_REQUEST, "Null objects"));
            return;
        }
        if (timePrecision != null && !TIME_PRECISION_ALLOWED.contains((Object)timePrecision)) {
            asyncResponse.resume((Object)this.errorResponse(Response.Status.BAD_REQUEST, "Invalid time precision: " + (Object)((Object)timePrecision)));
            return;
        }
        try {
            this.objectValidator.validateInfluxObjects(influxObjects);
        }
        catch (InvalidObjectException e) {
            asyncResponse.resume((Object)this.errorResponse(Response.Status.BAD_REQUEST, Throwables.getRootCause((Throwable)e).getMessage()));
            return;
        }
        Map<MetricType, List<Metric>> metrics = influxObjects.stream().map(influxObject -> InfluxSeriesHandler.influxToMetrics(tenantId, influxObject, timePrecision)).collect(Collectors.groupingBy(metric -> metric.getMetricId().getType()));
        Observable result = Observable.empty();
        if (metrics.containsKey(MetricType.GAUGE)) {
            result = result.mergeWith(this.metricsService.addDataPoints(MetricType.GAUGE, Observable.from((Iterable)metrics.get(MetricType.GAUGE)).compose((Observable.Transformer)MetricTypeFilter.GAUGE_FILTER)));
        }
        if (metrics.containsKey(MetricType.COUNTER)) {
            result = result.mergeWith(this.metricsService.addDataPoints(MetricType.COUNTER, Observable.from((Iterable)metrics.get(MetricType.COUNTER)).compose((Observable.Transformer)MetricTypeFilter.COUNTER_FILTER)));
        }
        result.subscribe((Observer)new WriteObserver(asyncResponse));
    }

    private static Metric<?> influxToMetrics(String tenantId, InfluxObject influxObject, InfluxTimeUnit timePrecision) {
        MetricTypeAndName metricTypeAndName = new MetricTypeAndName(influxObject.getName());
        MetricType<?> type = metricTypeAndName.getType();
        String name = metricTypeAndName.getName();
        List<String> influxObjectColumns = influxObject.getColumns();
        int valueColumnIndex = influxObjectColumns.indexOf("value");
        Stream<DataPoint> dataPoints = influxObject.getPoints().stream().map(objects -> {
            Number value;
            long timestamp;
            if (influxObjectColumns.size() == 1) {
                timestamp = System.currentTimeMillis();
                value = (Number)objects.get(0);
            } else {
                timestamp = ((Number)objects.get((valueColumnIndex + 1) % 2)).longValue();
                if (timePrecision != null) {
                    timestamp = timePrecision.convertTo(TimeUnit.MILLISECONDS, timestamp);
                }
                value = (Number)objects.get(valueColumnIndex);
            }
            return new DataPoint(Long.valueOf(timestamp), (Object)value);
        });
        if (type == MetricType.COUNTER) {
            List counterPoints = dataPoints.map(p -> new DataPoint(Long.valueOf(p.getTimestamp()), (Object)((Number)p.getValue()).longValue())).collect(Collectors.toList());
            return new Metric(new MetricId(tenantId, MetricType.COUNTER, name), counterPoints);
        }
        List gaugePoints = dataPoints.map(p -> new DataPoint(Long.valueOf(p.getTimestamp()), (Object)((Number)p.getValue()).doubleValue())).collect(Collectors.toList());
        return new Metric(new MetricId(tenantId, MetricType.GAUGE, name), gaugePoints);
    }

    @GET
    public void query(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, @QueryParam(value="q") String queryString, @QueryParam(value="time_precision") InfluxTimeUnit timePrecision) {
        QueryType queryType;
        InfluxQueryParser.QueryContext queryContext;
        if (queryString == null || queryString.isEmpty()) {
            asyncResponse.resume((Object)this.errorResponse(Response.Status.BAD_REQUEST, "Missing query"));
            return;
        }
        if (timePrecision != null && !TIME_PRECISION_ALLOWED.contains((Object)timePrecision)) {
            asyncResponse.resume((Object)this.errorResponse(Response.Status.BAD_REQUEST, "Invalid time precision: " + (Object)((Object)timePrecision)));
            return;
        }
        InfluxQueryParser queryParser = this.parserFactory.newInstanceForQuery(queryString);
        try {
            queryContext = queryParser.query();
            queryType = (QueryType)((Object)new QueryTypeVisitor().visit((ParseTree)queryContext));
        }
        catch (QueryParseException e) {
            asyncResponse.resume((Object)this.errorResponse(Response.Status.BAD_REQUEST, "Syntactically incorrect query: " + e.getMessage()));
            return;
        }
        switch (queryType) {
            case LIST_SERIES: {
                this.listSeries(asyncResponse, tenantId, queryContext.listSeries());
                break;
            }
            case SELECT: {
                this.select(asyncResponse, tenantId, queryContext.selectQuery(), timePrecision);
                break;
            }
            default: {
                asyncResponse.resume((Object)this.errorResponse(Response.Status.BAD_REQUEST, "Query not yet supported: " + queryString));
            }
        }
    }

    private void listSeries(AsyncResponse asyncResponse, String tenantId, InfluxQueryParser.ListSeriesContext listSeriesContext) {
        Pattern pattern;
        ListSeriesDefinitionsParser definitionsParser = new ListSeriesDefinitionsParser();
        this.parseTreeWalker.walk((ParseTreeListener)definitionsParser, (ParseTree)listSeriesContext);
        RegularExpression regularExpression = definitionsParser.getRegularExpression();
        if (regularExpression != null) {
            int flag = regularExpression.isCaseSensitive() ? 0 : 2;
            try {
                pattern = Pattern.compile(regularExpression.getExpression(), flag);
            }
            catch (Exception e) {
                asyncResponse.resume((Object)this.errorResponse(Response.Status.BAD_REQUEST, Throwables.getRootCause((Throwable)e).getMessage()));
                return;
            }
        } else {
            pattern = null;
        }
        Observable.merge((Observable)this.metricsService.findMetrics(tenantId, MetricType.GAUGE), (Observable)this.metricsService.findMetrics(tenantId, MetricType.COUNTER)).filter(metric -> pattern == null || pattern.matcher(metric.getMetricId().getName()).find()).toList().map(InfluxSeriesHandler::metricsListToListSeries).subscribe((Observer)new ReadObserver(asyncResponse));
    }

    private static List<InfluxObject> metricsListToListSeries(List<? extends Metric<?>> metrics) {
        ImmutableList columns = ImmutableList.of((Object)"time", (Object)"name");
        InfluxObject.Builder builder = new InfluxObject.Builder("list_series_result", (List<String>)columns).withForeseenPoints(metrics.size());
        for (Metric<?> metric : metrics) {
            String prefix;
            MetricType type = metric.getMetricId().getType();
            if (type == MetricType.GAUGE) {
                prefix = GAUGE_PREFIX;
            } else if (type == MetricType.COUNTER) {
                prefix = COUNTER_PREFIX;
            } else {
                log.tracef("List series query does not expect %s metric type", (Object)type);
                continue;
            }
            builder.addPoint((List<?>)ImmutableList.of((Object)0, (Object)(prefix + metric.getMetricId().getName())));
        }
        return ImmutableList.of((Object)builder.createInfluxObject());
    }

    private void select(AsyncResponse asyncResponse, String tenantId, InfluxQueryParser.SelectQueryContext selectQueryContext, InfluxTimeUnit timePrecision) {
        Buckets buckets;
        SelectQueryDefinitionsParser definitionsParser = new SelectQueryDefinitionsParser();
        this.parseTreeWalker.walk((ParseTreeListener)definitionsParser, (ParseTree)selectQueryContext);
        SelectQueryDefinitions queryDefinitions = definitionsParser.getSelectQueryDefinitions();
        try {
            this.queryValidator.validateSelectQuery(queryDefinitions);
        }
        catch (IllegalQueryException e) {
            asyncResponse.resume((Object)this.errorResponse(Response.Status.BAD_REQUEST, "Illegal query: " + e.getMessage()));
            return;
        }
        String influxObjectName = queryDefinitions.getFromClause().getName();
        MetricTypeAndName metricTypeAndName = new MetricTypeAndName(influxObjectName);
        MetricType<?> metricType = metricTypeAndName.getType();
        String metricName = metricTypeAndName.getName();
        BooleanExpression whereClause = queryDefinitions.getWhereClause();
        Interval timeInterval = whereClause == null ? new Interval((ReadableInstant)new Instant(0L), (ReadableInstant)Instant.now()) : this.toIntervalTranslator.toInterval(whereClause);
        if (timeInterval == null) {
            asyncResponse.resume((Object)this.errorResponse(Response.Status.BAD_REQUEST, "Invalid time interval"));
            return;
        }
        String columnName = this.getColumnName(queryDefinitions);
        try {
            buckets = this.getBucketConfig(queryDefinitions, timeInterval);
        }
        catch (IllegalArgumentException e) {
            asyncResponse.resume((Object)this.errorResponse(Response.Status.BAD_REQUEST, e.getMessage()));
            return;
        }
        this.metricsService.idExists(new MetricId(tenantId, metricType, metricName)).flatMap(idExists -> {
            if (idExists != Boolean.TRUE) {
                return Observable.just(null);
            }
            long start = timeInterval.getStartMillis();
            long end = timeInterval.getEndMillis();
            if (metricType == MetricType.GAUGE) {
                MetricId metricId = new MetricId(tenantId, MetricType.GAUGE, metricName);
                return this.metricsService.findDataPoints(metricId, start, end, 0, Order.DESC).toList();
            }
            if (metricType == MetricType.COUNTER) {
                MetricId metricId = new MetricId(tenantId, MetricType.COUNTER, metricName);
                return this.metricsService.findDataPoints(metricId, start, end, 0, Order.DESC).toSortedList((dataPoint, dataPoint2) -> Long.compare(dataPoint2.getTimestamp(), dataPoint.getTimestamp()));
            }
            return Observable.just(null);
        }).map(inputMetrics -> {
            if (inputMetrics == null) {
                return null;
            }
            List<Object> metrics = inputMetrics;
            if (buckets != null) {
                AggregatedColumnDefinition aggregatedColumnDefinition = (AggregatedColumnDefinition)queryDefinitions.getColumnDefinitions().get(0);
                metrics = this.applyMapping(aggregatedColumnDefinition.getAggregationFunction(), aggregatedColumnDefinition.getAggregationFunctionArguments(), (List<? extends DataPoint<? extends Number>>)inputMetrics, buckets);
            }
            if (!queryDefinitions.isOrderDesc()) {
                metrics = Lists.reverse(metrics);
            }
            if (queryDefinitions.getLimitClause() != null) {
                metrics = metrics.subList(0, queryDefinitions.getLimitClause().getLimit());
            }
            ArrayList<InfluxObject> objects = new ArrayList<InfluxObject>(1);
            ArrayList<String> columns = new ArrayList<String>(2);
            columns.add("time");
            columns.add(columnName);
            InfluxObject.Builder builder = new InfluxObject.Builder(influxObjectName, columns).withForeseenPoints(metrics.size());
            for (DataPoint dataPoint : metrics) {
                ArrayList<Object> data = new ArrayList<Object>();
                if (timePrecision == null) {
                    data.add(dataPoint.getTimestamp());
                } else {
                    data.add(timePrecision.convert(dataPoint.getTimestamp(), InfluxTimeUnit.MILLISECONDS));
                }
                data.add(dataPoint.getValue());
                builder.addPoint(data);
            }
            objects.add(builder.createInfluxObject());
            return objects;
        }).subscribe(objects -> {
            if (objects == null) {
                String msg = "Metric with id [" + influxObjectName + "] not found. ";
                asyncResponse.resume((Object)this.errorResponse(Response.Status.NOT_FOUND, msg));
            } else {
                Response.ResponseBuilder builder = Response.ok((Object)objects);
                asyncResponse.resume((Object)builder.build());
            }
        }, arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0));
    }

    private String getColumnName(SelectQueryDefinitions queryDefinitions) {
        if (queryDefinitions.isStarColumn()) {
            return "value";
        }
        return queryDefinitions.getColumnDefinitions().get(0).getDisplayName();
    }

    private Buckets getBucketConfig(SelectQueryDefinitions queryDefinitions, Interval timeInterval) {
        if (queryDefinitions.isStarColumn() || !(queryDefinitions.getColumnDefinitions().get(0) instanceof AggregatedColumnDefinition)) {
            return null;
        }
        GroupByClause groupByClause = queryDefinitions.getGroupByClause();
        InfluxTimeUnit bucketSizeUnit = groupByClause.getBucketSizeUnit();
        long bucketSize = bucketSizeUnit.convertTo(TimeUnit.MILLISECONDS, groupByClause.getBucketSize());
        return Buckets.fromStep((long)timeInterval.getStartMillis(), (long)timeInterval.getEndMillis(), (long)bucketSize);
    }

    private List<? extends DataPoint<? extends Number>> applyMapping(String aggregationFunction, List<FunctionArgument> aggregationFunctionArguments, List<? extends DataPoint<? extends Number>> in, Buckets buckets) {
        HashMap<Integer, ArrayList<DataPoint>> tmpMap = new HashMap<Integer, ArrayList<DataPoint>>(buckets.getCount());
        for (DataPoint<? extends Number> dataPoint : in) {
            int pos = (int)((dataPoint.getTimestamp() - buckets.getStart()) / buckets.getStep());
            ArrayList<DataPoint> bucket = (ArrayList<DataPoint>)tmpMap.get(pos);
            if (bucket == null) {
                bucket = new ArrayList<DataPoint>();
                tmpMap.put(pos, bucket);
            }
            bucket.add(new DataPoint(Long.valueOf(dataPoint.getTimestamp()), (Object)((Number)dataPoint.getValue()).doubleValue()));
        }
        ArrayList out = new ArrayList(buckets.getCount());
        TreeSet treeSet = new TreeSet(tmpMap.keySet());
        for (Integer pos : treeSet) {
            List list = (List)tmpMap.get(pos);
            double retVal = 0.0;
            boolean isSingleValue = true;
            if (list == null) continue;
            int size = list.size();
            DataPoint lastElementInList = (DataPoint)list.get(size - 1);
            DataPoint firstElementInList = (DataPoint)list.get(0);
            AggregationFunction function = AggregationFunction.findByName(aggregationFunction);
            switch (function) {
                case MEAN: {
                    for (DataPoint rnm : list) {
                        retVal += ((Double)rnm.getValue()).doubleValue();
                    }
                    log.debugf("Applying mean mapping, total = %f, size = %d", (Object)retVal, (Object)size);
                    retVal /= (double)size;
                    break;
                }
                case MAX: {
                    retVal = Double.MIN_VALUE;
                    for (DataPoint rnm : list) {
                        if (!((Double)rnm.getValue() > retVal)) continue;
                        retVal = (Double)rnm.getValue();
                    }
                    break;
                }
                case MIN: {
                    retVal = Double.MAX_VALUE;
                    for (DataPoint rnm : list) {
                        if (!((Double)rnm.getValue() < retVal)) continue;
                        retVal = (Double)rnm.getValue();
                    }
                    break;
                }
                case SUM: {
                    for (DataPoint rnm : list) {
                        retVal += ((Double)rnm.getValue()).doubleValue();
                    }
                    break;
                }
                case COUNT: {
                    retVal = size;
                    break;
                }
                case FIRST: {
                    if (list.isEmpty()) break;
                    retVal = (Double)firstElementInList.getValue();
                    break;
                }
                case LAST: {
                    if (list.isEmpty()) break;
                    retVal = (Double)lastElementInList.getValue();
                    break;
                }
                case DIFFERENCE: {
                    if (list.isEmpty()) break;
                    retVal = (Double)lastElementInList.getValue() - (Double)firstElementInList.getValue();
                    break;
                }
                case DERIVATIVE: {
                    if (list.isEmpty()) break;
                    double y = (Double)lastElementInList.getValue() - (Double)firstElementInList.getValue();
                    long t = (lastElementInList.getTimestamp() - firstElementInList.getTimestamp()) / 1000L;
                    retVal = y / (double)t;
                    break;
                }
                case MEDIAN: {
                    retVal = this.quantil(list, 50.0);
                    break;
                }
                case PERCENTILE: {
                    NumberFunctionArgument argument = (NumberFunctionArgument)aggregationFunctionArguments.get(1);
                    retVal = this.quantil(list, argument.getDoubleValue());
                    break;
                }
                case TOP: {
                    isSingleValue = false;
                    NumberFunctionArgument argument = (NumberFunctionArgument)aggregationFunctionArguments.get(1);
                    int numberOfTopElement = list.size() < (int)argument.getDoubleValue() ? list.size() : (int)argument.getDoubleValue();
                    for (int elementPos = 0; elementPos < numberOfTopElement; ++elementPos) {
                        out.add(list.get(elementPos));
                    }
                    break;
                }
                case BOTTOM: {
                    isSingleValue = false;
                    NumberFunctionArgument argument = (NumberFunctionArgument)aggregationFunctionArguments.get(1);
                    int numberOfBottomElement = list.size() < (int)argument.getDoubleValue() ? list.size() : (int)argument.getDoubleValue();
                    for (int elementPos = 0; elementPos < numberOfBottomElement; ++elementPos) {
                        out.add(list.get(list.size() - 1 - elementPos));
                    }
                    break;
                }
                case HISTOGRAM: 
                case MODE: {
                    int maxCount = 0;
                    for (DataPoint rnm : list) {
                        int count = 0;
                        for (DataPoint rnm2 : list) {
                            if (((Double)rnm.getValue()).doubleValue() != ((Double)rnm2.getValue()).doubleValue()) continue;
                            ++count;
                        }
                        if (count <= maxCount) continue;
                        maxCount = count;
                        retVal = (Double)rnm.getValue();
                    }
                    break;
                }
                case STDDEV: {
                    double meanValue = 0.0;
                    double sd = 0.0;
                    for (DataPoint rnm : list) {
                        meanValue += ((Double)rnm.getValue()).doubleValue();
                    }
                    meanValue /= (double)size;
                    for (DataPoint rnm : list) {
                        sd += Math.pow((Double)rnm.getValue() - meanValue, 2.0) / (double)(size - 1);
                    }
                    retVal = Math.sqrt(sd);
                    break;
                }
                default: {
                    log.warnf("Mapping of '%s' function not supported yet", (Object)function);
                }
            }
            if (!isSingleValue) continue;
            out.add(new DataPoint(Long.valueOf(firstElementInList.getTimestamp()), (Object)retVal));
        }
        return out;
    }

    private double quantil(List<DataPoint<Double>> in, double quantil) {
        double[] values = new double[in.size()];
        for (int i = 0; i < in.size(); ++i) {
            values[i] = (Double)in.get(i).getValue();
        }
        return new Percentile(quantil).evaluate(values);
    }

    private Response errorResponse(Response.Status status, String message) {
        return Response.status((Response.Status)status).entity((Object)message).type(MediaType.TEXT_PLAIN_TYPE).build();
    }

    private static class MetricTypeAndName {
        private final MetricType<?> type;
        private final String name;

        public MetricTypeAndName(String influxObjectName) {
            if (influxObjectName.startsWith(InfluxSeriesHandler.COUNTER_PREFIX)) {
                this.type = MetricType.COUNTER;
                this.name = influxObjectName.substring(InfluxSeriesHandler.COUNTER_PREFIX.length());
            } else {
                this.type = MetricType.GAUGE;
                this.name = influxObjectName.startsWith(InfluxSeriesHandler.GAUGE_PREFIX) ? influxObjectName.substring(InfluxSeriesHandler.GAUGE_PREFIX.length()) : influxObjectName;
            }
        }

        public MetricType<?> getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }
    }

    private class ReadObserver
    implements Observer<List<InfluxObject>> {
        private final AsyncResponse asyncResponse;

        public ReadObserver(AsyncResponse asyncResponse) {
            this.asyncResponse = asyncResponse;
        }

        public void onCompleted() {
        }

        public void onError(Throwable t) {
            this.asyncResponse.resume((Object)InfluxSeriesHandler.this.errorResponse(Response.Status.INTERNAL_SERVER_ERROR, Throwables.getRootCause((Throwable)t).getMessage()));
        }

        public void onNext(List<InfluxObject> influxObjects) {
            this.asyncResponse.resume((Object)Response.ok(influxObjects).build());
        }
    }

    private class WriteObserver
    implements Observer<Void> {
        private final AsyncResponse asyncResponse;

        public WriteObserver(AsyncResponse asyncResponse) {
            this.asyncResponse = asyncResponse;
        }

        public void onCompleted() {
            this.asyncResponse.resume((Object)Response.ok().build());
        }

        public void onError(Throwable t) {
            log.tracef(t, "Influx write query error", new Object[0]);
            this.asyncResponse.resume((Object)InfluxSeriesHandler.this.errorResponse(Response.Status.INTERNAL_SERVER_ERROR, Throwables.getRootCause((Throwable)t).getMessage()));
        }

        public void onNext(Void aVoid) {
        }
    }
}

