/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.influx;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public enum InfluxTimeUnit {
    MICROSECONDS("u"){

        @Override
        public long convertTo(TimeUnit targetUnit, long value) {
            return targetUnit.convert(value, TimeUnit.MICROSECONDS);
        }

        @Override
        public long convert(long sourceValue, InfluxTimeUnit sourceUnit) {
            return sourceUnit.convertTo(TimeUnit.MICROSECONDS, sourceValue);
        }
    }
    ,
    MILLISECONDS("ms"){

        @Override
        public long convertTo(TimeUnit targetUnit, long value) {
            return targetUnit.convert(value, TimeUnit.MILLISECONDS);
        }

        @Override
        public long convert(long sourceValue, InfluxTimeUnit sourceUnit) {
            return sourceUnit.convertTo(TimeUnit.MILLISECONDS, sourceValue);
        }
    }
    ,
    SECONDS("s"){

        @Override
        public long convertTo(TimeUnit targetUnit, long value) {
            return targetUnit.convert(value, TimeUnit.SECONDS);
        }

        @Override
        public long convert(long sourceValue, InfluxTimeUnit sourceUnit) {
            return sourceUnit.convertTo(TimeUnit.SECONDS, sourceValue);
        }
    }
    ,
    MINUTES("m"){

        @Override
        public long convertTo(TimeUnit targetUnit, long value) {
            return targetUnit.convert(value, TimeUnit.MINUTES);
        }

        @Override
        public long convert(long sourceValue, InfluxTimeUnit sourceUnit) {
            return sourceUnit.convertTo(TimeUnit.MINUTES, sourceValue);
        }
    }
    ,
    HOURS("h"){

        @Override
        public long convertTo(TimeUnit targetUnit, long value) {
            return targetUnit.convert(value, TimeUnit.HOURS);
        }

        @Override
        public long convert(long sourceValue, InfluxTimeUnit sourceUnit) {
            return sourceUnit.convertTo(TimeUnit.HOURS, sourceValue);
        }
    }
    ,
    DAYS("d"){

        @Override
        public long convertTo(TimeUnit targetUnit, long value) {
            return targetUnit.convert(value, TimeUnit.DAYS);
        }

        @Override
        public long convert(long sourceValue, InfluxTimeUnit sourceUnit) {
            return sourceUnit.convertTo(TimeUnit.DAYS, sourceValue);
        }
    }
    ,
    WEEKS("w"){

        @Override
        public long convertTo(TimeUnit targetUnit, long value) {
            return targetUnit.convert(7L * value, TimeUnit.DAYS);
        }

        @Override
        public long convert(long sourceValue, InfluxTimeUnit sourceUnit) {
            return sourceUnit.convertTo(TimeUnit.DAYS, sourceValue) / 7L;
        }
    };

    private String id;
    private static final Map<String, InfluxTimeUnit> UNIT_BY_ID;

    private InfluxTimeUnit(String id) {
        this.id = id.toLowerCase();
    }

    public String getId() {
        return this.id;
    }

    public abstract long convertTo(TimeUnit var1, long var2);

    public abstract long convert(long var1, InfluxTimeUnit var3);

    public static InfluxTimeUnit findById(String id) {
        return UNIT_BY_ID.get(id);
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (InfluxTimeUnit influxTimeUnit : InfluxTimeUnit.values()) {
            builder.put((Object)influxTimeUnit.id, (Object)influxTimeUnit);
        }
        UNIT_BY_ID = builder.build();
    }
}

