/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.handler;

import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.hawkular.metrics.api.jaxrs.util.ManifestInformation;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

@Path(value="/")
public class BaseHandler {
    public static final String PATH = "/";
    @Inject
    ManifestInformation manifestInformation;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Returns some basic information about the Hawkular Metrics service.", response=String.class, responseContainer="Map")
    public Response baseJSON(@Context ServletContext servletContext) {
        HashMap<String, String> hawkularMetricsProperties = new HashMap<String, String>();
        hawkularMetricsProperties.put("name", "Hawkular-Metrics");
        hawkularMetricsProperties.putAll(this.manifestInformation.getFrom(servletContext));
        return Response.ok(hawkularMetricsProperties).build();
    }

    @GET
    @Produces(value={"application/xhtml+xml", "text/html"})
    public void baseHTML(@Context ServletContext context) throws Exception {
        HttpServletRequest request = (HttpServletRequest)ResteasyProviderFactory.getContextData(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)ResteasyProviderFactory.getContextData(HttpServletResponse.class);
        request.getRequestDispatcher("/static/index.html").forward((ServletRequest)request, (ServletResponse)response);
    }
}

