/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.util;

import com.google.common.base.Throwables;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.core.Response;
import org.hawkular.metrics.api.jaxrs.log.RestLogger;
import org.hawkular.metrics.api.jaxrs.log.RestLogging;
import org.hawkular.metrics.model.ApiError;
import org.hawkular.metrics.model.exception.RuntimeApiError;

/*
 * Exception performing whole class analysis ignored.
 */
public class ApiUtils {
    private static final RestLogger log = RestLogging.getRestLogger(ApiUtils.class);

    public static Response collectionToResponse(Collection<?> collection) {
        return collection.isEmpty() ? ApiUtils.noContent() : Response.ok(collection).type("application/json").build();
    }

    public static Response mapToResponse(Map<?, ?> map) {
        return map.isEmpty() ? ApiUtils.noContent() : Response.ok(map).type("application/json").build();
    }

    public static Response error(Throwable t) {
        if (t instanceof RuntimeApiError) {
            return ApiUtils.badRequest((Throwable)t);
        }
        return ApiUtils.serverError((Throwable)t);
    }

    public static Response serverError(Throwable t, String message) {
        log.errorRequestProblem(t);
        String errorMsg = message + ": " + Throwables.getRootCause((Throwable)t).getMessage();
        return Response.serverError().type("application/json").entity((Object)new ApiError(errorMsg)).build();
    }

    public static Response serverError(Throwable t) {
        return ApiUtils.serverError((Throwable)t, (String)"Failed to perform operation due to an error");
    }

    public static Response valueToResponse(Optional<?> optional) {
        return optional.map(value -> Response.ok((Object)value).build()).orElse(ApiUtils.noContent());
    }

    public static Response noContent() {
        return Response.noContent().build();
    }

    public static Response emptyPayload() {
        return ApiUtils.badRequest((ApiError)new ApiError("Payload is empty"));
    }

    public static Response badRequest(ApiError error) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)error).build();
    }

    public static Response badRequest(Throwable t) {
        ApiError error = new ApiError(t.getLocalizedMessage());
        return ApiUtils.badRequest((ApiError)error);
    }

    private ApiUtils() {
    }
}

