/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.influx;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class InfluxObject {
    private final String name;
    private final List<String> columns;
    private final List<List<?>> points;

    @JsonCreator
    private InfluxObject(@JsonProperty(value="name") String name, @JsonProperty(value="columns") List<String> columns, @JsonProperty(value="points") List<List<?>> points) {
        this.name = name;
        this.columns = columns;
        this.points = points == null ? Collections.emptyList() : points;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public List<List<?>> getPoints() {
        return this.points;
    }

    public static class Builder {
        private final String name;
        private final List<String> columns;
        private ArrayList<List<?>> points;

        public Builder(String name, List<String> columns) {
            this.name = name;
            this.columns = columns;
        }

        public Builder withForeseenPoints(int count) {
            if (this.points == null) {
                this.points = new ArrayList();
            }
            this.points.ensureCapacity(count);
            return this;
        }

        public Builder addPoint(List<?> point) {
            if (this.points == null) {
                this.points = new ArrayList();
            }
            this.points.add(point);
            return this;
        }

        public InfluxObject createInfluxObject() {
            return new InfluxObject(this.name, this.columns, this.points);
        }
    }
}

