/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.influx.query.parse.definition;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.hawkular.metrics.api.jaxrs.influx.InfluxTimeUnit;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.InfluxQueryBaseListener;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.InfluxQueryParser;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.AggregatedColumnDefinitionBuilder;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.AndBooleanExpression;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.BooleanExpression;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.ColumnDefinition;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.ColumnDefinitionBuilder;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.DateOperand;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.DoubleFunctionArgument;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.DoubleOperand;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.EqBooleanExpression;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.FromClause;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.FunctionArgument;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.GroupByClause;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.GtBooleanExpression;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.LimitClause;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.LongFunctionArgument;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.LongOperand;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.LtBooleanExpression;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.MomentOperand;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.NameFunctionArgument;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.NameOperand;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.NeqBooleanExpression;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.Operand;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.OrBooleanExpression;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.RawColumnDefinitionBuilder;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.SelectQueryDefinitions;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.SelectQueryDefinitionsBuilder;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.StringFunctionArgument;
import org.joda.time.Instant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;

public class SelectQueryDefinitionsParser
extends InfluxQueryBaseListener {
    private static final DateTimeFormatter DATE_FORMATTER;
    private static final Pattern TIMESPAN_MATCHER;
    private SelectQueryDefinitionsBuilder definitionsBuilder = new SelectQueryDefinitionsBuilder();
    private String prefix;
    private String name;
    private String alias;
    private String function;
    private List<ColumnDefinition> columnDefinitions;
    private RawColumnDefinitionBuilder rawColumnDefinitionBuilder;
    private AggregatedColumnDefinitionBuilder aggregatedColumnDefinitionBuilder;
    private List<FunctionArgument> functionArguments;
    private Deque<BooleanExpression> booleanExpressionQueue;
    private Deque<Operand> operandQueue;

    @Override
    public void enterColumnDefinitionList(InfluxQueryParser.ColumnDefinitionListContext ctx) {
        this.columnDefinitions = new ArrayList<ColumnDefinition>((ctx.getChildCount() + 1) / 2);
    }

    @Override
    public void exitColumnDefinitionList(InfluxQueryParser.ColumnDefinitionListContext ctx) {
        this.definitionsBuilder.setColumnDefinitions(this.columnDefinitions);
    }

    @Override
    public void enterColumnDefinition(InfluxQueryParser.ColumnDefinitionContext ctx) {
        this.alias = null;
        this.removeColumnDefinitionBuilder();
    }

    @Override
    public void exitColumnDefinition(InfluxQueryParser.ColumnDefinitionContext ctx) {
        ColumnDefinitionBuilder columnDefinitionBuilder = this.getColumnDefinitionBuilder();
        columnDefinitionBuilder.setAlias(this.alias);
        this.columnDefinitions.add(columnDefinitionBuilder.createColumnDefinition());
        this.alias = null;
        this.removeColumnDefinitionBuilder();
    }

    @Override
    public void enterRawColumnDefinition(InfluxQueryParser.RawColumnDefinitionContext ctx) {
        this.rawColumnDefinitionBuilder = new RawColumnDefinitionBuilder();
        this.prefix = null;
        this.name = null;
    }

    @Override
    public void exitRawColumnDefinition(InfluxQueryParser.RawColumnDefinitionContext ctx) {
        this.rawColumnDefinitionBuilder.setPrefix(this.prefix);
        this.rawColumnDefinitionBuilder.setName(this.name);
        this.prefix = null;
        this.name = null;
    }

    @Override
    public void enterAggregatedColumnDefinition(InfluxQueryParser.AggregatedColumnDefinitionContext ctx) {
        this.aggregatedColumnDefinitionBuilder = new AggregatedColumnDefinitionBuilder();
        this.function = null;
        this.functionArguments = null;
    }

    @Override
    public void exitAggregatedColumnDefinition(InfluxQueryParser.AggregatedColumnDefinitionContext ctx) {
        this.aggregatedColumnDefinitionBuilder.setAggregationFunction(this.function);
        this.aggregatedColumnDefinitionBuilder.setAggregationFunctionArguments(this.functionArguments);
        this.function = null;
        this.functionArguments = null;
    }

    @Override
    public void enterFromClause(InfluxQueryParser.FromClauseContext ctx) {
        this.name = null;
        this.alias = null;
    }

    @Override
    public void exitFromClause(InfluxQueryParser.FromClauseContext ctx) {
        this.definitionsBuilder.setFromClause(new FromClause(this.name, this.alias));
        this.name = null;
        this.alias = null;
    }

    @Override
    public void exitGroupByClause(InfluxQueryParser.GroupByClauseContext ctx) {
        String bucketType = ctx.ID().getText();
        String timespan = ctx.TIMESPAN().getText();
        Matcher matcher = TIMESPAN_MATCHER.matcher(timespan);
        if (!matcher.matches()) {
            throw new IllegalStateException("Unknown timespan format: " + timespan);
        }
        long bucketSize = Long.parseLong(matcher.group(1));
        String unitId = matcher.group(2);
        InfluxTimeUnit bucketSizeUnit = InfluxTimeUnit.findById(unitId);
        if (bucketSizeUnit == null) {
            throw new RuntimeException("Unknown time unit: " + unitId);
        }
        this.definitionsBuilder.setGroupByClause(new GroupByClause(bucketType, bucketSize, bucketSizeUnit));
    }

    @Override
    public void enterWhereClause(InfluxQueryParser.WhereClauseContext ctx) {
        this.booleanExpressionQueue = new ArrayDeque<BooleanExpression>(10);
        this.operandQueue = new ArrayDeque<Operand>(10);
    }

    @Override
    public void exitWhereClause(InfluxQueryParser.WhereClauseContext ctx) {
        this.definitionsBuilder.setWhereClause(this.booleanExpressionQueue.removeLast());
    }

    @Override
    public void exitOrderAsc(InfluxQueryParser.OrderAscContext ctx) {
        this.definitionsBuilder.setOrderDesc(false);
    }

    @Override
    public void exitEqExpression(InfluxQueryParser.EqExpressionContext ctx) {
        Operand rightOperand = this.operandQueue.removeLast();
        Operand leftOperand = this.operandQueue.removeLast();
        this.booleanExpressionQueue.addLast(new EqBooleanExpression(leftOperand, rightOperand));
    }

    @Override
    public void exitGtExpression(InfluxQueryParser.GtExpressionContext ctx) {
        Operand rightOperand = this.operandQueue.removeLast();
        Operand leftOperand = this.operandQueue.removeLast();
        this.booleanExpressionQueue.addLast(new GtBooleanExpression(leftOperand, rightOperand));
    }

    @Override
    public void exitLtExpression(InfluxQueryParser.LtExpressionContext ctx) {
        Operand rightOperand = this.operandQueue.removeLast();
        Operand leftOperand = this.operandQueue.removeLast();
        this.booleanExpressionQueue.addLast(new LtBooleanExpression(leftOperand, rightOperand));
    }

    @Override
    public void exitNeqExpression(InfluxQueryParser.NeqExpressionContext ctx) {
        Operand rightOperand = this.operandQueue.removeLast();
        Operand leftOperand = this.operandQueue.removeLast();
        this.booleanExpressionQueue.addLast(new NeqBooleanExpression(leftOperand, rightOperand));
    }

    @Override
    public void exitAndExpression(InfluxQueryParser.AndExpressionContext ctx) {
        BooleanExpression rightExpression = this.booleanExpressionQueue.removeLast();
        BooleanExpression leftExpression = this.booleanExpressionQueue.removeLast();
        this.booleanExpressionQueue.addLast(new AndBooleanExpression(leftExpression, rightExpression));
    }

    @Override
    public void exitOrExpression(InfluxQueryParser.OrExpressionContext ctx) {
        BooleanExpression rightExpression = this.booleanExpressionQueue.removeLast();
        BooleanExpression leftExpression = this.booleanExpressionQueue.removeLast();
        this.booleanExpressionQueue.addLast(new OrBooleanExpression(leftExpression, rightExpression));
    }

    @Override
    public void enterNameOperand(InfluxQueryParser.NameOperandContext ctx) {
        this.prefix = null;
        this.name = null;
    }

    @Override
    public void exitNameOperand(InfluxQueryParser.NameOperandContext ctx) {
        this.operandQueue.addLast(new NameOperand(this.prefix, this.name));
        this.prefix = null;
        this.name = null;
    }

    @Override
    public void exitAbsoluteMomentOperand(InfluxQueryParser.AbsoluteMomentOperandContext ctx) {
        String timespan = ctx.TIMESPAN().getText();
        Matcher matcher = TIMESPAN_MATCHER.matcher(timespan);
        if (!matcher.matches()) {
            throw new IllegalStateException("Unknown timespan format: " + timespan);
        }
        long amount = Long.parseLong(matcher.group(1));
        String unitId = matcher.group(2);
        InfluxTimeUnit unit = InfluxTimeUnit.findById(unitId);
        if (unit == null) {
            throw new RuntimeException("Unknown time unit: " + unitId);
        }
        this.operandQueue.addLast(new DateOperand(new Instant(unit.convertTo(TimeUnit.MILLISECONDS, amount))));
    }

    @Override
    public void exitPastMomentOperand(InfluxQueryParser.PastMomentOperandContext ctx) {
        InfluxTimeUnit timeshiftUnit;
        long timeshift;
        String functionName = ctx.ID().getText();
        TerminalNode intNode = ctx.INT();
        if (intNode == null) {
            String timespan = ctx.TIMESPAN().getText();
            Matcher matcher = TIMESPAN_MATCHER.matcher(timespan);
            if (!matcher.matches()) {
                throw new IllegalStateException("Unknown timespan format: " + timespan);
            }
            timeshift = Long.parseLong(matcher.group(1));
            String unitId = matcher.group(2);
            timeshiftUnit = InfluxTimeUnit.findById(unitId);
            if (timeshiftUnit == null) {
                throw new RuntimeException("Unknown time unit: " + unitId);
            }
        } else {
            timeshift = Long.parseLong(intNode.getText());
            timeshiftUnit = InfluxTimeUnit.MICROSECONDS;
        }
        this.operandQueue.addLast(new MomentOperand(functionName, -1L * timeshift, timeshiftUnit));
    }

    @Override
    public void exitFutureMomentOperand(InfluxQueryParser.FutureMomentOperandContext ctx) {
        InfluxTimeUnit timeshiftUnit;
        long timeshift;
        String functionName = ctx.ID().getText();
        TerminalNode intNode = ctx.INT();
        if (intNode == null) {
            String timespan = ctx.TIMESPAN().getText();
            Matcher matcher = TIMESPAN_MATCHER.matcher(timespan);
            if (!matcher.matches()) {
                throw new IllegalStateException("Unknown timespan format: " + timespan);
            }
            timeshift = Long.parseLong(matcher.group(1));
            String unitId = matcher.group(2);
            timeshiftUnit = InfluxTimeUnit.findById(unitId);
            if (timeshiftUnit == null) {
                throw new RuntimeException("Unknown time unit: " + unitId);
            }
        } else {
            timeshift = Long.parseLong(intNode.getText());
            timeshiftUnit = InfluxTimeUnit.MICROSECONDS;
        }
        this.operandQueue.addLast(new MomentOperand(functionName, timeshift, timeshiftUnit));
    }

    @Override
    public void exitPresentMomentOperand(InfluxQueryParser.PresentMomentOperandContext ctx) {
        String functionName = ctx.ID().getText();
        this.operandQueue.addLast(new MomentOperand(functionName, 0L, InfluxTimeUnit.SECONDS));
    }

    @Override
    public void exitDateOperand(InfluxQueryParser.DateOperandContext ctx) {
        String dateString = ctx.DATE_STRING().getText();
        dateString = dateString.substring(1, dateString.length() - 1);
        this.operandQueue.addLast(new DateOperand(Instant.parse((String)dateString, (DateTimeFormatter)DATE_FORMATTER)));
    }

    @Override
    public void exitLongOperand(InfluxQueryParser.LongOperandContext ctx) {
        long value = Long.parseLong(ctx.INT().getText());
        if (ctx.DASH() != null) {
            value = -1L * value;
        }
        this.operandQueue.addLast(new LongOperand(value));
    }

    @Override
    public void exitDoubleOperand(InfluxQueryParser.DoubleOperandContext ctx) {
        double value = Double.parseDouble(ctx.FLOAT().getText());
        if (ctx.DASH() != null) {
            value = -1.0 * value;
        }
        this.operandQueue.addLast(new DoubleOperand(value));
    }

    @Override
    public void exitLimitClause(InfluxQueryParser.LimitClauseContext ctx) {
        int limit = Integer.parseInt(ctx.INT().getText());
        this.definitionsBuilder.setLimitClause(new LimitClause(limit));
    }

    @Override
    public void exitPrefix(InfluxQueryParser.PrefixContext ctx) {
        this.prefix = ctx.ID().getText();
    }

    @Override
    public void exitIdName(InfluxQueryParser.IdNameContext ctx) {
        this.name = ctx.ID().getText();
    }

    @Override
    public void exitStringName(InfluxQueryParser.StringNameContext ctx) {
        String doubleQuotedString = ctx.DOUBLE_QUOTED_STRING().getText();
        this.name = doubleQuotedString.substring(1, doubleQuotedString.length() - 1);
    }

    @Override
    public void exitAlias(InfluxQueryParser.AliasContext ctx) {
        this.alias = ctx.ID().getText();
    }

    @Override
    public void exitFunctionCall(InfluxQueryParser.FunctionCallContext ctx) {
        this.function = ctx.ID().getText();
    }

    @Override
    public void enterFunctionArgumentList(InfluxQueryParser.FunctionArgumentListContext ctx) {
        this.functionArguments = new ArrayList<FunctionArgument>((ctx.getChildCount() + 1) / 2);
    }

    @Override
    public void enterNameFunctionArgument(InfluxQueryParser.NameFunctionArgumentContext ctx) {
        this.prefix = null;
        this.name = null;
    }

    @Override
    public void exitStringFunctionArgument(InfluxQueryParser.StringFunctionArgumentContext ctx) {
        String singleQuotedString = ctx.SINGLE_QUOTED_STRING().getText();
        String value = singleQuotedString.substring(1, singleQuotedString.length() - 1);
        this.functionArguments.add(new StringFunctionArgument(value));
    }

    @Override
    public void exitNameFunctionArgument(InfluxQueryParser.NameFunctionArgumentContext ctx) {
        NameFunctionArgument functionArgument = new NameFunctionArgument(this.prefix, this.name);
        this.functionArguments.add(functionArgument);
        this.prefix = null;
        this.name = null;
    }

    @Override
    public void exitDoubleFunctionArgument(InfluxQueryParser.DoubleFunctionArgumentContext ctx) {
        double value = Double.parseDouble(ctx.FLOAT().getText());
        if (ctx.DASH() != null) {
            value = -1.0 * value;
        }
        this.functionArguments.add(new DoubleFunctionArgument(value));
    }

    @Override
    public void exitLongFunctionArgument(InfluxQueryParser.LongFunctionArgumentContext ctx) {
        long value = Long.parseLong(ctx.INT().getText());
        if (ctx.DASH() != null) {
            value = -1L * value;
        }
        this.functionArguments.add(new LongFunctionArgument(value));
    }

    private ColumnDefinitionBuilder getColumnDefinitionBuilder() {
        return this.rawColumnDefinitionBuilder != null ? this.rawColumnDefinitionBuilder : this.aggregatedColumnDefinitionBuilder;
    }

    private void removeColumnDefinitionBuilder() {
        this.rawColumnDefinitionBuilder = null;
        this.aggregatedColumnDefinitionBuilder = null;
    }

    public SelectQueryDefinitions getSelectQueryDefinitions() {
        return this.definitionsBuilder.createSelectQueryDefinitions();
    }

    static {
        DateTimeParser millisParser = new DateTimeFormatterBuilder().appendLiteral('.').append(DateTimeFormat.forPattern((String)"SSS")).toParser();
        DateTimeParser timeParser = new DateTimeFormatterBuilder().appendLiteral(' ').append(DateTimeFormat.forPattern((String)"HH")).appendLiteral(':').append(DateTimeFormat.forPattern((String)"mm")).appendLiteral(':').append(DateTimeFormat.forPattern((String)"ss")).appendOptional(millisParser).toParser();
        DATE_FORMATTER = new DateTimeFormatterBuilder().append(DateTimeFormat.forPattern((String)"yyyy")).appendLiteral('-').append(DateTimeFormat.forPattern((String)"MM")).appendLiteral('-').append(DateTimeFormat.forPattern((String)"dd")).appendOptional(timeParser).toFormatter().withZoneUTC();
        String regex = Arrays.stream(InfluxTimeUnit.values()).map(InfluxTimeUnit::getId).collect(Collectors.joining("|", "(\\d+)(", ")"));
        TIMESPAN_MATCHER = Pattern.compile(regex);
    }
}

