/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.influx.query.validation;

import java.util.HashMap;
import java.util.Map;
import org.hawkular.metrics.api.jaxrs.influx.query.validation.AggregationFunctionValidationRule;
import org.hawkular.metrics.api.jaxrs.influx.query.validation.DefaultAggregatorRule;
import org.hawkular.metrics.api.jaxrs.influx.query.validation.NameAndNumberAggregatorRule;

public enum AggregationFunction {
    MEAN("mean"),
    MAX("max"),
    MIN("min"),
    SUM("sum"),
    COUNT("count"),
    FIRST("first"),
    LAST("last"),
    DIFFERENCE("difference"),
    DERIVATIVE("derivative"),
    MEDIAN("median"),
    PERCENTILE("percentile", new NameAndNumberAggregatorRule()),
    TOP("top", new NameAndNumberAggregatorRule()),
    BOTTOM("bottom", new NameAndNumberAggregatorRule()),
    HISTOGRAM("histogram"),
    MODE("mode"),
    STDDEV("stddev");

    private String name;
    private AggregationFunctionValidationRule validationRule;
    private static final Map<String, AggregationFunction> FUNCTION_BY_NAME;

    private AggregationFunction(String name) {
        this(name, DefaultAggregatorRule.DEFAULT_INSTANCE);
    }

    private AggregationFunction(String name, AggregationFunctionValidationRule validationRule) {
        this.name = name;
        this.validationRule = validationRule;
    }

    public String getName() {
        return this.name;
    }

    public AggregationFunctionValidationRule getValidationRule() {
        return this.validationRule;
    }

    public static AggregationFunction findByName(String name) {
        return FUNCTION_BY_NAME.get(name.toLowerCase());
    }

    static {
        FUNCTION_BY_NAME = new HashMap<String, AggregationFunction>();
        for (AggregationFunction function : AggregationFunction.values()) {
            FUNCTION_BY_NAME.put(function.name.toLowerCase(), function);
        }
    }
}

