/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.influx.query.validation;

import org.hawkular.metrics.api.jaxrs.influx.InfluxTimeUnit;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.GroupByClause;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.SelectQueryDefinitions;
import org.hawkular.metrics.api.jaxrs.influx.query.validation.IllegalQueryException;
import org.hawkular.metrics.api.jaxrs.influx.query.validation.SelectQueryValidationRule;

public class GroupByTimeRule
implements SelectQueryValidationRule {
    public void checkQuery(SelectQueryDefinitions queryDefinitions) throws IllegalQueryException {
        GroupByClause groupByClause = queryDefinitions.getGroupByClause();
        if (groupByClause == null) {
            return;
        }
        if (!groupByClause.getBucketType().equalsIgnoreCase("time")) {
            throw new IllegalQueryException("Group by " + groupByClause.getBucketType());
        }
        if (groupByClause.getBucketSizeUnit() == InfluxTimeUnit.MICROSECONDS && groupByClause.getBucketSize() < InfluxTimeUnit.MICROSECONDS.convert(1L, InfluxTimeUnit.MILLISECONDS)) {
            throw new IllegalQueryException("Group by bucket size smaller than maximum resolution");
        }
    }
}

