/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.influx.query.validation;

import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.AndBooleanExpression;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.BooleanExpression;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.GtBooleanExpression;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.LtBooleanExpression;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.Operand;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.OperandUtils;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.SelectQueryDefinitions;
import org.hawkular.metrics.api.jaxrs.influx.query.validation.IllegalQueryException;
import org.hawkular.metrics.api.jaxrs.influx.query.validation.QueryNotSupportedException;
import org.hawkular.metrics.api.jaxrs.influx.query.validation.SelectQueryValidationRule;

@Deprecated
public class SimpleTimeRangesOnlyRule
implements SelectQueryValidationRule {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void checkQuery(SelectQueryDefinitions queryDefinitions) throws IllegalQueryException {
        BooleanExpression whereClause = queryDefinitions.getWhereClause();
        if (whereClause == null) {
            return;
        }
        if (whereClause instanceof LtBooleanExpression) {
            LtBooleanExpression lt = (LtBooleanExpression)whereClause;
            this.checkOneTimeOperand(lt.getLeftOperand(), lt.getRightOperand());
            this.checkOneInstantOrPositiveLongOperand(lt.getLeftOperand(), lt.getRightOperand());
            return;
        } else if (whereClause instanceof GtBooleanExpression) {
            GtBooleanExpression gt = (GtBooleanExpression)whereClause;
            this.checkOneTimeOperand(gt.getLeftOperand(), gt.getRightOperand());
            this.checkOneInstantOrPositiveLongOperand(gt.getLeftOperand(), gt.getRightOperand());
            return;
        } else {
            if (!(whereClause instanceof AndBooleanExpression)) throw new QueryNotSupportedException("Not a simple time range restriction");
            AndBooleanExpression and = (AndBooleanExpression)whereClause;
            BooleanExpression left = and.getLeftExpression();
            BooleanExpression right = and.getRightExpression();
            if (left instanceof LtBooleanExpression) {
                LtBooleanExpression lt = (LtBooleanExpression)left;
                this.checkOneTimeOperand(lt.getLeftOperand(), lt.getRightOperand());
                this.checkOneInstantOrPositiveLongOperand(lt.getLeftOperand(), lt.getRightOperand());
                if (right instanceof GtBooleanExpression) {
                    GtBooleanExpression gt = (GtBooleanExpression)right;
                    this.checkOneTimeOperand(gt.getLeftOperand(), gt.getRightOperand());
                    this.checkOneInstantOrPositiveLongOperand(gt.getLeftOperand(), gt.getRightOperand());
                    this.checkRestrictionIsARange(lt, gt);
                    return;
                } else {
                    if (!(right instanceof LtBooleanExpression)) throw new QueryNotSupportedException("Not a simple time range restriction");
                    LtBooleanExpression lt2 = (LtBooleanExpression)right;
                    this.checkOneTimeOperand(lt2.getLeftOperand(), lt2.getRightOperand());
                    this.checkOneInstantOrPositiveLongOperand(lt2.getLeftOperand(), lt2.getRightOperand());
                    this.checkRestrictionIsARange(lt, lt2);
                }
                return;
            } else {
                if (!(left instanceof GtBooleanExpression)) throw new QueryNotSupportedException("Not a simple time range restriction");
                GtBooleanExpression gt = (GtBooleanExpression)left;
                this.checkOneTimeOperand(gt.getLeftOperand(), gt.getRightOperand());
                this.checkOneInstantOrPositiveLongOperand(gt.getLeftOperand(), gt.getRightOperand());
                if (right instanceof LtBooleanExpression) {
                    LtBooleanExpression lt = (LtBooleanExpression)right;
                    this.checkOneTimeOperand(lt.getLeftOperand(), lt.getRightOperand());
                    this.checkOneInstantOrPositiveLongOperand(lt.getLeftOperand(), lt.getRightOperand());
                    this.checkRestrictionIsARange(lt, gt);
                    return;
                } else {
                    if (!(right instanceof GtBooleanExpression)) throw new QueryNotSupportedException("Not a simple time range restriction");
                    GtBooleanExpression gt2 = (GtBooleanExpression)right;
                    this.checkOneTimeOperand(gt2.getLeftOperand(), gt2.getRightOperand());
                    this.checkOneInstantOrPositiveLongOperand(gt2.getLeftOperand(), gt2.getRightOperand());
                    this.checkRestrictionIsARange(gt, gt2);
                }
            }
        }
    }

    private void checkRestrictionIsARange(LtBooleanExpression lt, GtBooleanExpression gt) throws QueryNotSupportedException {
        if (OperandUtils.isTimeOperand(lt.getLeftOperand()) && OperandUtils.isTimeOperand(gt.getRightOperand()) || OperandUtils.isTimeOperand(lt.getRightOperand()) && OperandUtils.isTimeOperand(gt.getLeftOperand())) {
            throw new QueryNotSupportedException("Not a simple time range restriction");
        }
    }

    private void checkRestrictionIsARange(GtBooleanExpression gt1, GtBooleanExpression gt2) throws QueryNotSupportedException {
        if (OperandUtils.isTimeOperand(gt1.getLeftOperand()) && OperandUtils.isTimeOperand(gt2.getLeftOperand()) || OperandUtils.isTimeOperand(gt1.getRightOperand()) && OperandUtils.isTimeOperand(gt2.getRightOperand())) {
            throw new QueryNotSupportedException("Not a simple time range restriction");
        }
    }

    private void checkRestrictionIsARange(LtBooleanExpression lt1, LtBooleanExpression lt2) throws QueryNotSupportedException {
        if (OperandUtils.isTimeOperand(lt1.getLeftOperand()) && OperandUtils.isTimeOperand(lt2.getLeftOperand()) || OperandUtils.isTimeOperand(lt1.getRightOperand()) && OperandUtils.isTimeOperand(lt2.getRightOperand())) {
            throw new QueryNotSupportedException("Not a simple time range restriction");
        }
    }

    private void checkOneTimeOperand(Operand leftOperand, Operand rightOperand) throws QueryNotSupportedException {
        if (OperandUtils.isTimeOperand(leftOperand) == OperandUtils.isTimeOperand(rightOperand)) {
            throw new QueryNotSupportedException("Expected exactly one time operand");
        }
    }

    private void checkOneInstantOrPositiveLongOperand(Operand leftOperand, Operand rightOperand) throws QueryNotSupportedException {
        if ((OperandUtils.isInstantOperand(leftOperand) || OperandUtils.isPositiveLongOperand(leftOperand)) == (OperandUtils.isInstantOperand(rightOperand) || OperandUtils.isPositiveLongOperand(rightOperand))) {
            throw new QueryNotSupportedException("Expected exactly one instant operand");
        }
    }
}

