/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.handler;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.hawkular.metrics.api.jaxrs.QueryRequest;
import org.hawkular.metrics.api.jaxrs.handler.observer.NamedDataPointObserver;
import org.hawkular.metrics.api.jaxrs.util.ApiUtils;
import org.hawkular.metrics.core.service.MetricsService;
import org.hawkular.metrics.core.service.Order;
import org.hawkular.metrics.model.ApiError;
import org.hawkular.metrics.model.MetricId;
import org.hawkular.metrics.model.MetricType;
import org.hawkular.metrics.model.param.TimeRange;
import rx.Observable;
import rx.schedulers.Schedulers;

public abstract class MetricsServiceHandler {
    @Inject
    protected MetricsService metricsService;
    @Inject
    protected ObjectMapper mapper;
    @HeaderParam(value="Hawkular-Tenant")
    protected String tenantId;

    protected <T> Response findRawDataPointsForMetrics(QueryRequest query, MetricType<T> type) {
        TimeRange timeRange = new TimeRange(query.getStart(), query.getEnd());
        if (!timeRange.isValid()) {
            return ApiUtils.badRequest(new ApiError(timeRange.getProblem()));
        }
        int limit = query.getLimit() == null ? 0 : query.getLimit();
        Order order = query.getOrder() == null ? Order.defaultValue((int)limit, (Long)timeRange.getStart(), (Long)timeRange.getEnd()) : Order.fromText((String)query.getOrder());
        if (query.getIds().isEmpty()) {
            return ApiUtils.badRequest(new ApiError("Metric ids must be specified"));
        }
        List metricIds = query.getIds().stream().map(id -> new MetricId(this.tenantId, type, id)).collect(Collectors.toList());
        Observable dataPoints = this.metricsService.findDataPoints(metricIds, timeRange.getStart(), timeRange.getEnd(), limit, order).observeOn(Schedulers.io());
        StreamingOutput stream = output -> {
            JsonGenerator generator = this.mapper.getFactory().createGenerator(output, JsonEncoding.UTF8);
            CountDownLatch latch = new CountDownLatch(1);
            dataPoints.subscribe(new NamedDataPointObserver(generator, latch, type));
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new WebApplicationException("There was an interrupt while fetching raw data points", (Throwable)e);
            }
        };
        return Response.ok((Object)stream).build();
    }

    protected Response findRateDataPointsForMetrics(QueryRequest query, MetricType<? extends Number> type) {
        TimeRange timeRange = new TimeRange(query.getStart(), query.getEnd());
        if (!timeRange.isValid()) {
            return ApiUtils.badRequest(new ApiError(timeRange.getProblem()));
        }
        int limit = query.getLimit() == null ? 0 : query.getLimit();
        Order order = query.getOrder() == null ? Order.defaultValue((int)limit, (Long)timeRange.getStart(), (Long)timeRange.getEnd()) : Order.fromText((String)query.getOrder());
        if (query.getIds().isEmpty()) {
            return ApiUtils.badRequest(new ApiError("Metric ids must be specified"));
        }
        List metricIds = query.getIds().stream().map(id -> new MetricId(this.tenantId, type, id)).collect(Collectors.toList());
        Observable dataPoints = this.metricsService.findRateData(metricIds, timeRange.getStart(), timeRange.getEnd(), limit, order).observeOn(Schedulers.io());
        StreamingOutput stream = output -> {
            JsonGenerator generator = this.mapper.getFactory().createGenerator(output, JsonEncoding.UTF8);
            CountDownLatch latch = new CountDownLatch(1);
            if (type == MetricType.GAUGE) {
                dataPoints.subscribe(new NamedDataPointObserver(generator, latch, MetricType.GAUGE));
            } else if (type == MetricType.COUNTER) {
                dataPoints.subscribe(new NamedDataPointObserver(generator, latch, MetricType.COUNTER_RATE));
            } else {
                throw new IllegalArgumentException(type + " is not a supported metric type for rate data points");
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new WebApplicationException("There was an interrupt while fetching raw data points", (Throwable)e);
            }
        };
        return Response.ok((Object)stream).build();
    }
}

