/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.handler.observer;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.hawkular.metrics.model.AvailabilityType;
import org.hawkular.metrics.model.MetricType;
import org.hawkular.metrics.model.NamedDataPoint;
import org.jboss.logging.Logger;
import rx.Subscriber;

public class NamedDataPointObserver<T>
extends Subscriber<NamedDataPoint<T>> {
    private static final Logger log = Logger.getLogger(NamedDataPointObserver.class);
    private final JsonGenerator generator;
    private final CountDownLatch latch;
    private final WriteValue<T> writeValue;
    private volatile String currentMetric;

    public NamedDataPointObserver(JsonGenerator generator, CountDownLatch latch, MetricType<T> type) {
        this.generator = generator;
        this.latch = latch;
        if (type == MetricType.GAUGE || type == MetricType.GAUGE_RATE || type == MetricType.COUNTER_RATE) {
            this.writeValue = dataPoint -> generator.writeNumberField("value", ((Double)dataPoint.getValue()).doubleValue());
        } else if (type == MetricType.COUNTER) {
            this.writeValue = dataPoint -> generator.writeNumberField("value", ((Long)dataPoint.getValue()).longValue());
        } else if (type == MetricType.AVAILABILITY) {
            this.writeValue = dataPoint -> {
                AvailabilityType availability = (AvailabilityType)dataPoint.getValue();
                generator.writeStringField("value", availability.getText());
            };
        } else if (type == MetricType.STRING) {
            this.writeValue = dataPoint -> generator.writeStringField("value", (String)dataPoint.getValue());
        } else {
            throw new IllegalArgumentException(type + " is not supported metric type. This class should be " + "updated to add support for it!");
        }
    }

    public void onNext(NamedDataPoint<T> dataPoint) {
        log.trace((Object)("Next data point is " + dataPoint));
        try {
            if (this.currentMetric == null) {
                this.generator.writeStartArray();
                this.generator.writeStartObject();
                this.generator.writeStringField("id", dataPoint.getName());
                this.generator.writeArrayFieldStart("data");
                this.generator.writeStartObject();
                this.generator.writeNumberField("timestamp", dataPoint.getTimestamp());
                this.writeValue.call(dataPoint);
                this.generator.writeEndObject();
            } else if (this.currentMetric.equals(dataPoint.getName())) {
                this.generator.writeStartObject();
                this.generator.writeNumberField("timestamp", dataPoint.getTimestamp());
                this.writeValue.call(dataPoint);
                this.generator.writeEndObject();
            } else {
                this.generator.writeEndArray();
                this.generator.writeEndObject();
                this.generator.writeStartObject();
                this.generator.writeStringField("id", dataPoint.getName());
                this.generator.writeArrayFieldStart("data");
                this.generator.writeStartObject();
                this.generator.writeNumberField("timestamp", dataPoint.getTimestamp());
                this.writeValue.call(dataPoint);
                this.generator.writeEndObject();
            }
            this.currentMetric = dataPoint.getName();
        }
        catch (IOException e) {
            throw new RuntimeException("Streaming data to client failed", e);
        }
    }

    public void onError(Throwable e) {
        try {
            log.warn((Object)"Fetching data failed", e);
            this.generator.close();
        }
        catch (IOException e1) {
            log.error((Object)("Failed to close " + this.generator.getClass().getName()));
        }
        finally {
            this.latch.countDown();
        }
    }

    public void onCompleted() {
        try {
            if (this.currentMetric == null) {
                this.generator.writeStartArray();
                this.generator.writeEndArray();
            } else {
                this.generator.writeEndArray();
                this.generator.writeEndObject();
                this.generator.writeEndArray();
            }
            this.generator.close();
            this.latch.countDown();
        }
        catch (IOException e) {
            log.warn((Object)"Error while finishing streaming data", (Throwable)e);
        }
        finally {
            this.latch.countDown();
        }
    }

    @FunctionalInterface
    private static interface WriteValue<T> {
        public void call(NamedDataPoint<T> var1) throws IOException;
    }
}

