/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import org.hawkular.metrics.api.jaxrs.QueryRequest;
import org.hawkular.metrics.api.jaxrs.handler.observer.NamedDataPointObserver;
import org.hawkular.metrics.api.jaxrs.util.ApiUtils;
import org.hawkular.metrics.core.service.MetricsService;
import org.hawkular.metrics.core.service.Order;
import org.hawkular.metrics.model.ApiError;
import org.hawkular.metrics.model.MetricId;
import org.hawkular.metrics.model.MetricType;
import org.hawkular.metrics.model.param.TimeRange;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import rx.Observable;
import rx.Subscriber;
import rx.schedulers.Schedulers;

public abstract class MetricsServiceHandler {
    @Inject
    protected MetricsService metricsService;
    @Inject
    protected ObjectMapper mapper;
    @Context
    protected HttpHeaders httpHeaders;

    protected String getTenant() {
        return (String)this.httpHeaders.getRequestHeaders().getFirst((Object)"Hawkular-Tenant");
    }

    protected <T> void findRawDataPointsForMetrics(AsyncResponse asyncResponse, QueryRequest query, MetricType<T> type) {
        TimeRange timeRange = new TimeRange(query.getStart(), query.getEnd());
        if (!timeRange.isValid()) {
            asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError(timeRange.getProblem())));
            return;
        }
        int limit = query.getLimit() == null ? 0 : query.getLimit();
        Order order = query.getOrder() == null ? Order.defaultValue((int)limit, (Long)timeRange.getStart(), (Long)timeRange.getEnd()) : Order.fromText((String)query.getOrder());
        if (query.getIds().isEmpty()) {
            asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError("Metric ids must be specified")));
            return;
        }
        List metricIds = query.getIds().stream().map(id -> new MetricId(this.getTenant(), type, id)).collect(Collectors.toList());
        Observable dataPoints = this.metricsService.findDataPoints(metricIds, timeRange.getStart(), timeRange.getEnd(), limit, order).observeOn(Schedulers.io());
        HttpServletRequest request = (HttpServletRequest)ResteasyProviderFactory.getContextData(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)ResteasyProviderFactory.getContextData(HttpServletResponse.class);
        dataPoints.subscribe((Subscriber)new NamedDataPointObserver(request, response, this.mapper, type));
    }

    protected void findRateDataPointsForMetrics(AsyncResponse asyncResponse, QueryRequest query, MetricType<? extends Number> type) {
        TimeRange timeRange = new TimeRange(query.getStart(), query.getEnd());
        if (!timeRange.isValid()) {
            asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError(timeRange.getProblem())));
            return;
        }
        int limit = query.getLimit() == null ? 0 : query.getLimit();
        Order order = query.getOrder() == null ? Order.defaultValue((int)limit, (Long)timeRange.getStart(), (Long)timeRange.getEnd()) : Order.fromText((String)query.getOrder());
        if (query.getIds().isEmpty()) {
            asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError("Metric ids must be specified")));
            return;
        }
        List metricIds = query.getIds().stream().map(id -> new MetricId(this.getTenant(), type, id)).collect(Collectors.toList());
        Observable dataPoints = this.metricsService.findRateData(metricIds, timeRange.getStart(), timeRange.getEnd(), limit, order).observeOn(Schedulers.io());
        HttpServletRequest request = (HttpServletRequest)ResteasyProviderFactory.getContextData(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)ResteasyProviderFactory.getContextData(HttpServletResponse.class);
        if (type == MetricType.GAUGE) {
            dataPoints.subscribe((Subscriber)new NamedDataPointObserver(request, response, this.mapper, MetricType.GAUGE));
        } else if (type == MetricType.COUNTER) {
            dataPoints.subscribe((Subscriber)new NamedDataPointObserver(request, response, this.mapper, MetricType.COUNTER_RATE));
        } else {
            throw new IllegalArgumentException(type + " is not a supported metric type for rate data points");
        }
    }
}

