/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.handler.observer;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hawkular.metrics.model.ApiError;
import org.hawkular.metrics.model.AvailabilityType;
import org.hawkular.metrics.model.MetricType;
import org.hawkular.metrics.model.NamedDataPoint;
import org.jboss.logging.Logger;
import rx.Subscriber;

public class NamedDataPointObserver<T>
extends Subscriber<NamedDataPoint<T>> {
    private static final Logger log = Logger.getLogger(NamedDataPointObserver.class);
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final ObjectMapper mapper;
    private final JsonGenerator generator;
    private final WriteValue<T> writeValue;
    private volatile String currentMetric;

    public NamedDataPointObserver(HttpServletRequest request, HttpServletResponse response, ObjectMapper mapper, MetricType<T> type) {
        this.request = request;
        this.response = response;
        this.mapper = mapper;
        try {
            this.generator = mapper.getFactory().createGenerator((OutputStream)response.getOutputStream(), JsonEncoding.UTF8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (type == MetricType.GAUGE || type == MetricType.GAUGE_RATE || type == MetricType.COUNTER_RATE) {
            this.writeValue = dataPoint -> this.generator.writeNumberField("value", ((Double)dataPoint.getValue()).doubleValue());
        } else if (type == MetricType.COUNTER) {
            this.writeValue = dataPoint -> this.generator.writeNumberField("value", ((Long)dataPoint.getValue()).longValue());
        } else if (type == MetricType.AVAILABILITY) {
            this.writeValue = dataPoint -> {
                AvailabilityType availability = (AvailabilityType)dataPoint.getValue();
                this.generator.writeStringField("value", availability.getText());
            };
        } else if (type == MetricType.STRING) {
            this.writeValue = dataPoint -> this.generator.writeStringField("value", (String)dataPoint.getValue());
        } else {
            throw new IllegalArgumentException(type + " is not supported metric type. This class should be " + "updated to add support for it!");
        }
    }

    public void onNext(NamedDataPoint<T> dataPoint) {
        try {
            if (this.currentMetric == null) {
                this.response.setStatus(200);
                this.response.setHeader("Content-Type", "application/json");
                this.generator.writeStartArray();
                this.generator.writeStartObject();
                this.generator.writeStringField("id", dataPoint.getName());
                this.generator.writeArrayFieldStart("data");
                this.generator.writeStartObject();
                this.generator.writeNumberField("timestamp", dataPoint.getTimestamp());
                this.writeValue.call(dataPoint);
                this.generator.writeEndObject();
            } else if (this.currentMetric.equals(dataPoint.getName())) {
                this.generator.writeStartObject();
                this.generator.writeNumberField("timestamp", dataPoint.getTimestamp());
                this.writeValue.call(dataPoint);
                this.generator.writeEndObject();
            } else {
                this.generator.writeEndArray();
                this.generator.writeEndObject();
                this.generator.writeStartObject();
                this.generator.writeStringField("id", dataPoint.getName());
                this.generator.writeArrayFieldStart("data");
                this.generator.writeStartObject();
                this.generator.writeNumberField("timestamp", dataPoint.getTimestamp());
                this.writeValue.call(dataPoint);
                this.generator.writeEndObject();
            }
            this.currentMetric = dataPoint.getName();
        }
        catch (IOException e) {
            throw new RuntimeException("Streaming data to client failed", e);
        }
    }

    public void onError(Throwable e) {
        log.trace((Object)"Fetching data failed", e);
        try {
            if (this.currentMetric == null) {
                this.response.setStatus(500);
                this.response.setHeader("Content-Type", "application/json");
                ApiError apiError = new ApiError(Throwables.getRootCause((Throwable)e).getMessage());
                this.mapper.writeValue((OutputStream)this.response.getOutputStream(), (Object)apiError);
            } else {
                this.generator.close();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.request.getAsyncContext().complete();
        }
    }

    public void onCompleted() {
        try {
            if (this.currentMetric == null) {
                this.response.setStatus(204);
            } else {
                this.generator.writeEndArray();
                this.generator.writeEndObject();
                this.generator.writeEndArray();
            }
            this.generator.close();
        }
        catch (IOException e) {
            log.trace((Object)"Error while finishing streaming data", (Throwable)e);
        }
        finally {
            this.request.getAsyncContext().complete();
        }
    }

    @FunctionalInterface
    private static interface WriteValue<T> {
        public void call(NamedDataPoint<T> var1) throws IOException;
    }
}

