/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs;

import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.MetricRegistry;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.JdkSSLOptions;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.SSLOptions;
import com.datastax.driver.core.Session;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.Uninterruptibles;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.net.ssl.SSLContext;
import org.hawkular.metrics.api.jaxrs.DriverUsageMetricsManager;
import org.hawkular.metrics.api.jaxrs.MetricsServiceLifecycle;
import org.hawkular.metrics.api.jaxrs.ServiceReady;
import org.hawkular.metrics.api.jaxrs.ServiceReadyEvent;
import org.hawkular.metrics.api.jaxrs.config.Configurable;
import org.hawkular.metrics.api.jaxrs.config.ConfigurationKey;
import org.hawkular.metrics.api.jaxrs.config.ConfigurationProperty;
import org.hawkular.metrics.api.jaxrs.log.RestLogger;
import org.hawkular.metrics.api.jaxrs.log.RestLogging;
import org.hawkular.metrics.api.jaxrs.util.Eager;
import org.hawkular.metrics.api.jaxrs.util.JobSchedulerFactory;
import org.hawkular.metrics.api.jaxrs.util.MetricRegistryProvider;
import org.hawkular.metrics.core.jobs.JobsService;
import org.hawkular.metrics.core.jobs.JobsServiceImpl;
import org.hawkular.metrics.core.service.DataAccess;
import org.hawkular.metrics.core.service.DataAccessImpl;
import org.hawkular.metrics.core.service.MetricsService;
import org.hawkular.metrics.core.service.MetricsServiceImpl;
import org.hawkular.metrics.scheduler.api.Scheduler;
import org.hawkular.metrics.scheduler.impl.TestScheduler;
import org.hawkular.metrics.schema.SchemaService;
import org.hawkular.metrics.sysconfig.ConfigurationService;
import org.hawkular.rx.cassandra.driver.RxSession;
import org.hawkular.rx.cassandra.driver.RxSessionImpl;

@ApplicationScoped
@Eager
public class MetricsServiceLifecycle {
    private static final RestLogger log = RestLogging.getRestLogger(MetricsServiceLifecycle.class);
    private MetricsServiceImpl metricsService;
    private final ScheduledExecutorService lifecycleExecutor;
    private Scheduler scheduler;
    private JobsServiceImpl jobsService;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.CASSANDRA_CQL_PORT)
    private String cqlPort;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.CASSANDRA_NODES)
    private String nodes;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.CASSANDRA_KEYSPACE)
    private String keyspace;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.CASSANDRA_RESETDB)
    private String resetDb;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.CASSANDRA_MAX_CONN_HOST)
    private String maxConnectionsPerHost;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.CASSANDRA_MAX_REQUEST_CONN)
    private String maxRequestsPerConnection;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.WAIT_FOR_SERVICE)
    private String waitForService;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.CASSANDRA_USESSL)
    private String cassandraUseSSL;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.DEFAULT_TTL)
    private String defaultTTL;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.DISABLE_METRICS_JMX)
    private String disableMetricsJmxReporting;
    @Inject
    DriverUsageMetricsManager driverUsageMetricsManager;
    @Inject
    @ServiceReady
    Event<ServiceReadyEvent> metricsServiceReady;
    private volatile State state;
    private int connectionAttempts;
    private Session session;
    private JmxReporter jmxReporter;
    private DataAccess dataAcces;

    MetricsServiceLifecycle() {
        ThreadFactory threadFactory = r -> {
            Thread thread = Executors.defaultThreadFactory().newThread(r);
            thread.setName(MetricsService.class.getSimpleName().toLowerCase(Locale.ROOT) + "-lifecycle-thread");
            return thread;
        };
        this.lifecycleExecutor = Executors.newSingleThreadScheduledExecutor(threadFactory);
        this.state = State.STARTING;
    }

    public State getState() {
        return this.state;
    }

    @PostConstruct
    void init() {
        this.lifecycleExecutor.submit(() -> this.startMetricsService());
        if (Boolean.parseBoolean(this.waitForService) || "embedded_cassandra".equals(System.getProperty("hawkular.backend"))) {
            long start = System.nanoTime();
            while (this.state == State.STARTING && TimeUnit.NANOSECONDS.convert(1L, TimeUnit.MINUTES) > System.nanoTime() - start) {
                Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startMetricsService() {
        if (this.state != State.STARTING) {
            return;
        }
        log.infoInitializing();
        ++this.connectionAttempts;
        try {
            this.session = this.createSession();
        }
        catch (Exception t) {
            Throwable rootCause = Throwables.getRootCause((Throwable)t);
            if (rootCause.getLocalizedMessage().equals(this.nodes + ": unknown error")) {
                log.warnCouldNotConnectToCassandra("Could not resolve hostname: " + rootCause.getLocalizedMessage());
            } else {
                log.warnCouldNotConnectToCassandra(rootCause.getLocalizedMessage());
            }
            long delay = 1L + ((long)this.connectionAttempts - 1L) % 4L;
            log.warnRetryingConnectingToCassandra(Integer.valueOf(this.connectionAttempts), Long.valueOf(delay));
            this.lifecycleExecutor.schedule(() -> this.startMetricsService(), delay, TimeUnit.SECONDS);
            return;
        }
        try {
            this.initSchema();
            this.dataAcces = new DataAccessImpl(this.session);
            ConfigurationService configurationService = new ConfigurationService();
            configurationService.init((RxSession)new RxSessionImpl(this.session));
            this.metricsService = new MetricsServiceImpl();
            this.metricsService.setDataAccess(this.dataAcces);
            this.metricsService.setConfigurationService(configurationService);
            this.metricsService.setDefaultTTL(this.getDefaultTTL());
            MetricRegistry metricRegistry = MetricRegistryProvider.INSTANCE.getMetricRegistry();
            if (!Boolean.parseBoolean(this.disableMetricsJmxReporting)) {
                this.jmxReporter = JmxReporter.forRegistry((MetricRegistry)metricRegistry).inDomain("hawkular.metrics").build();
                this.jmxReporter.start();
            }
            this.metricsService.startUp(this.session, this.keyspace, false, false, metricRegistry);
            this.metricsServiceReady.fire((Object)new ServiceReadyEvent(this.metricsService.insertedDataEvents()));
            this.initJobsService();
            this.session.getCluster().register((Host.StateListener)new ClusterStateListener(this, null));
            this.state = State.STARTED;
            log.infoServiceStarted();
        }
        catch (Exception e) {
            log.fatalCannotConnectToCassandra(e);
            this.state = State.FAILED;
        }
        finally {
            if (this.state != State.STARTED && this.metricsService != null) {
                try {
                    this.metricsService.shutdown();
                }
                catch (Exception e) {
                    log.errorCouldNotCloseServiceInstance(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session createSession() {
        int newMaxRequests;
        int newMaxConnections;
        int port;
        Cluster.Builder clusterBuilder = new Cluster.Builder();
        try {
            port = Integer.parseInt(this.cqlPort);
        }
        catch (NumberFormatException nfe) {
            String defaultPort = ConfigurationKey.CASSANDRA_CQL_PORT.defaultValue();
            log.warnInvalidCqlPort(this.cqlPort, defaultPort);
            port = Integer.parseInt(defaultPort);
        }
        clusterBuilder.withPort(port);
        Arrays.stream(this.nodes.split(",")).forEach(arg_0 -> ((Cluster.Builder)clusterBuilder).addContactPoint(arg_0));
        if (Boolean.parseBoolean(this.cassandraUseSSL)) {
            JdkSSLOptions sslOptions = null;
            try {
                String[] defaultCipherSuites = new String[]{"TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA"};
                sslOptions = JdkSSLOptions.builder().withSSLContext(SSLContext.getDefault()).withCipherSuites(defaultCipherSuites).build();
                clusterBuilder.withSSL((SSLOptions)sslOptions);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("SSL support is required but is not available in the JVM.", e);
            }
        }
        if (Boolean.parseBoolean(this.disableMetricsJmxReporting)) {
            clusterBuilder.withoutJMXReporting();
        }
        try {
            newMaxConnections = Integer.parseInt(this.maxConnectionsPerHost);
        }
        catch (NumberFormatException nfe) {
            String defaultMaxConnections = ConfigurationKey.CASSANDRA_MAX_CONN_HOST.defaultValue();
            log.warnInvalidMaxConnections(this.maxConnectionsPerHost, defaultMaxConnections);
            newMaxConnections = Integer.parseInt(defaultMaxConnections);
        }
        try {
            newMaxRequests = Integer.parseInt(this.maxRequestsPerConnection);
        }
        catch (NumberFormatException nfe) {
            String defaultMaxRequests = ConfigurationKey.CASSANDRA_MAX_REQUEST_CONN.defaultValue();
            log.warnInvalidMaxRequests(this.maxRequestsPerConnection, defaultMaxRequests);
            newMaxRequests = Integer.parseInt(defaultMaxRequests);
        }
        clusterBuilder.withPoolingOptions(new PoolingOptions().setMaxConnectionsPerHost(HostDistance.LOCAL, newMaxConnections).setMaxConnectionsPerHost(HostDistance.REMOTE, newMaxConnections).setMaxRequestsPerConnection(HostDistance.LOCAL, newMaxRequests).setMaxRequestsPerConnection(HostDistance.REMOTE, newMaxRequests));
        Cluster cluster = clusterBuilder.build();
        cluster.init();
        Session createdSession = null;
        try {
            Session session = createdSession = cluster.connect("system");
            return session;
        }
        finally {
            if (createdSession == null) {
                cluster.close();
            }
        }
    }

    private void initSchema() {
        SchemaService schemaService = new SchemaService();
        schemaService.run(this.session, this.keyspace, Boolean.parseBoolean(this.resetDb));
        this.session.execute("USE " + this.keyspace);
    }

    private int getDefaultTTL() {
        try {
            return Integer.parseInt(this.defaultTTL);
        }
        catch (NumberFormatException e) {
            log.warnInvalidDefaultTTL(this.defaultTTL, ConfigurationKey.DEFAULT_TTL.defaultValue());
            return Integer.parseInt(ConfigurationKey.DEFAULT_TTL.defaultValue());
        }
    }

    private void initJobsService() {
        RxSessionImpl rxSession = new RxSessionImpl(this.session);
        this.jobsService = new JobsServiceImpl();
        this.jobsService.setMetricsService((MetricsService)this.metricsService);
        this.jobsService.setSession((RxSession)rxSession);
        this.scheduler = new JobSchedulerFactory().getJobScheduler((RxSession)rxSession);
        this.jobsService.setScheduler(this.scheduler);
        this.jobsService.start();
    }

    @Produces
    @ApplicationScoped
    public MetricsService getMetricsService() {
        return this.metricsService;
    }

    @Produces
    @ApplicationScoped
    public JobsService getJobsService() {
        return this.jobsService;
    }

    @Produces
    @ApplicationScoped
    public TestScheduler getTestScheduler() {
        if (this.scheduler instanceof TestScheduler) {
            return (TestScheduler)this.scheduler;
        }
        throw new RuntimeException(TestScheduler.class.getName() + " is not available in this deployment");
    }

    @PreDestroy
    void destroy() {
        Future<?> stopFuture = this.lifecycleExecutor.submit(() -> this.stopServices());
        try {
            Futures.get(stopFuture, (long)1L, (TimeUnit)TimeUnit.MINUTES, Exception.class);
        }
        catch (Exception e) {
            log.errorShutdownProblem(e);
        }
        this.lifecycleExecutor.shutdown();
    }

    private void stopServices() {
        this.state = State.STOPPING;
        try {
            if (this.jobsService != null) {
                this.jobsService.shutdown();
            }
            if (this.metricsService != null) {
                this.metricsService.shutdown();
            }
            if (this.jmxReporter != null) {
                this.jmxReporter.stop();
            }
        }
        finally {
            this.state = State.STOPPED;
        }
    }

    static /* synthetic */ ScheduledExecutorService access$100(MetricsServiceLifecycle x0) {
        return x0.lifecycleExecutor;
    }

    static /* synthetic */ Session access$200(MetricsServiceLifecycle x0) {
        return x0.session;
    }
}

