/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import org.hawkular.metrics.api.jaxrs.AggregatedStatsQueryRequest;
import org.hawkular.metrics.api.jaxrs.QueryRequest;
import org.hawkular.metrics.api.jaxrs.handler.observer.NamedDataPointObserver;
import org.hawkular.metrics.api.jaxrs.param.DurationConverter;
import org.hawkular.metrics.api.jaxrs.param.PercentilesConverter;
import org.hawkular.metrics.api.jaxrs.param.TagsConverter;
import org.hawkular.metrics.api.jaxrs.util.ApiUtils;
import org.hawkular.metrics.core.service.MetricsService;
import org.hawkular.metrics.core.service.Order;
import org.hawkular.metrics.model.ApiError;
import org.hawkular.metrics.model.MetricId;
import org.hawkular.metrics.model.MetricType;
import org.hawkular.metrics.model.param.BucketConfig;
import org.hawkular.metrics.model.param.Duration;
import org.hawkular.metrics.model.param.TimeRange;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import rx.Observable;
import rx.schedulers.Schedulers;

public abstract class MetricsServiceHandler {
    @Inject
    protected MetricsService metricsService;
    @Inject
    protected ObjectMapper mapper;
    @Context
    protected HttpHeaders httpHeaders;

    protected String getTenant() {
        return (String)this.httpHeaders.getRequestHeaders().getFirst((Object)"Hawkular-Tenant");
    }

    protected <T> void findRawDataPointsForMetrics(AsyncResponse asyncResponse, QueryRequest query, MetricType<T> type) {
        Observable dataPoints;
        List<Object> ids;
        TimeRange timeRange = new TimeRange(query.getStart(), query.getEnd());
        if (!timeRange.isValid()) {
            asyncResponse.resume((Object)ApiUtils.badRequest(new ApiError(timeRange.getProblem())));
            return;
        }
        int limit = query.getLimit() == null ? 0 : query.getLimit();
        Order order = query.getOrder() == null ? Order.defaultValue((int)limit, (Object)timeRange.getStart(), (Object)timeRange.getEnd()) : Order.fromText((String)query.getOrder());
        Map tags = TagsConverter.fromNullable(query.getTags()).getTags();
        List<Object> list = ids = query.getIds() == null ? Collections.emptyList() : query.getIds();
        if (ids.isEmpty() && tags.isEmpty()) {
            asyncResponse.resume((Object)ApiUtils.badRequest(new ApiError("Either metrics or tags parameter must be used")));
            return;
        }
        if (!ids.isEmpty() && !tags.isEmpty()) {
            asyncResponse.resume((Object)ApiUtils.badRequest(new ApiError("Cannot use both the metrics and tags parameters")));
            return;
        }
        if (tags.isEmpty()) {
            List metricIds = ids.stream().map(id -> new MetricId(this.getTenant(), type, id)).collect(Collectors.toList());
            dataPoints = this.metricsService.findDataPoints(metricIds, timeRange.getStart(), timeRange.getEnd(), limit, order).observeOn(Schedulers.io());
        } else {
            dataPoints = this.metricsService.findDataPoints(this.getTenant(), type, tags, timeRange.getStart(), timeRange.getEnd(), limit, order).observeOn(Schedulers.io());
        }
        HttpServletRequest request = (HttpServletRequest)ResteasyProviderFactory.getContextData(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)ResteasyProviderFactory.getContextData(HttpServletResponse.class);
        dataPoints.subscribe(new NamedDataPointObserver<T>(request, response, this.mapper, type));
    }

    protected void findRateDataPointsForMetrics(AsyncResponse asyncResponse, QueryRequest query, MetricType<? extends Number> type) {
        Observable dataPoints;
        List<Object> ids;
        TimeRange timeRange = new TimeRange(query.getStart(), query.getEnd());
        if (!timeRange.isValid()) {
            asyncResponse.resume((Object)ApiUtils.badRequest(new ApiError(timeRange.getProblem())));
            return;
        }
        int limit = query.getLimit() == null ? 0 : query.getLimit();
        Order order = query.getOrder() == null ? Order.defaultValue((int)limit, (Object)timeRange.getStart(), (Object)timeRange.getEnd()) : Order.fromText((String)query.getOrder());
        Map tags = TagsConverter.fromNullable(query.getTags()).getTags();
        List<Object> list = ids = query.getIds() == null ? Collections.emptyList() : query.getIds();
        if (ids.isEmpty() && tags.isEmpty()) {
            asyncResponse.resume((Object)ApiUtils.badRequest(new ApiError("Either metrics or tags parameter must be used")));
            return;
        }
        if (!ids.isEmpty() && !tags.isEmpty()) {
            asyncResponse.resume((Object)ApiUtils.badRequest(new ApiError("Cannot use both the metrics and tags parameters")));
            return;
        }
        if (tags.isEmpty()) {
            List metricIds = ids.stream().map(id -> new MetricId(this.getTenant(), type, id)).collect(Collectors.toList());
            dataPoints = this.metricsService.findRateData(metricIds, timeRange.getStart(), timeRange.getEnd(), limit, order).observeOn(Schedulers.io());
        } else {
            dataPoints = this.metricsService.findRateData(this.getTenant(), type, tags, timeRange.getStart(), timeRange.getEnd(), limit, order).observeOn(Schedulers.io());
        }
        HttpServletRequest request = (HttpServletRequest)ResteasyProviderFactory.getContextData(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)ResteasyProviderFactory.getContextData(HttpServletResponse.class);
        if (type == MetricType.GAUGE) {
            dataPoints.subscribe(new NamedDataPointObserver(request, response, this.mapper, MetricType.GAUGE));
        } else if (type == MetricType.COUNTER) {
            dataPoints.subscribe(new NamedDataPointObserver(request, response, this.mapper, MetricType.COUNTER_RATE));
        } else {
            throw new IllegalArgumentException(type + " is not a supported metric type for rate data points");
        }
    }

    protected void findStatsForAggregatedMetrics(AsyncResponse asyncResponse, AggregatedStatsQueryRequest query, MetricType<? extends Number> type) {
        List percentiles;
        List<Object> ids;
        TimeRange timeRange = new TimeRange(query.getStart(), query.getEnd());
        if (!timeRange.isValid()) {
            asyncResponse.resume((Object)ApiUtils.badRequest(new ApiError(timeRange.getProblem())));
            return;
        }
        Duration duration = query.getBucketDuration() == null ? null : new DurationConverter().fromString(query.getBucketDuration());
        BucketConfig bucketConfig = new BucketConfig(query.getBuckets(), duration, timeRange);
        if (bucketConfig.isEmpty()) {
            asyncResponse.resume((Object)ApiUtils.badRequest(new ApiError("Either the buckets or bucketDuration parameter must be used")));
            return;
        }
        if (!bucketConfig.isValid()) {
            asyncResponse.resume((Object)ApiUtils.badRequest(new ApiError(bucketConfig.getProblem())));
            return;
        }
        Map tags = TagsConverter.fromNullable(query.getTags()).getTags();
        List<Object> list = ids = query.getMetrics() == null ? Collections.emptyList() : query.getMetrics();
        if (ids.isEmpty() && tags.isEmpty()) {
            asyncResponse.resume((Object)ApiUtils.badRequest(new ApiError("Either metrics or tags parameter must be used")));
            return;
        }
        if (!ids.isEmpty() && !tags.isEmpty()) {
            asyncResponse.resume((Object)ApiUtils.badRequest(new ApiError("Cannot use both the metrics and tags parameters")));
            return;
        }
        List list2 = percentiles = query.getPercentiles() == null ? Collections.emptyList() : new PercentilesConverter().fromString(query.getPercentiles()).getPercentiles();
        if (ids.isEmpty()) {
            this.metricsService.findNumericStats(this.getTenant(), type, tags, timeRange.getStart(), timeRange.getEnd(), bucketConfig.getBuckets(), percentiles, query.isStacked()).map(ApiUtils::collectionToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.serverError(t)));
        } else {
            this.metricsService.findNumericStats(this.getTenant(), type, ids, timeRange.getStart(), timeRange.getEnd(), bucketConfig.getBuckets(), percentiles, query.isStacked()).map(ApiUtils::collectionToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.serverError(t)));
        }
    }
}

