/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.util;

import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.hawkular.metrics.api.jaxrs.config.Configurable;
import org.hawkular.metrics.api.jaxrs.config.ConfigurationKey;
import org.hawkular.metrics.api.jaxrs.config.ConfigurationProperty;
import org.hawkular.metrics.api.jaxrs.util.Eager;

@ApplicationScoped
@Eager
public class OriginValidation {
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.ALLOWED_CORS_ORIGINS)
    String allowedCorsOriginsConfig;
    private boolean allowAnyOrigin;
    private Set<URI> allowedOrigins;

    @PostConstruct
    void init() {
        if ("*".equals(this.allowedCorsOriginsConfig.trim())) {
            this.allowAnyOrigin = true;
        } else {
            this.allowAnyOrigin = false;
            Set parsedOrigins = Arrays.stream(this.allowedCorsOriginsConfig.split(",")).map(String::trim).map(URI::create).collect(Collectors.toSet());
            this.allowedOrigins = ImmutableSet.copyOf(parsedOrigins);
        }
    }

    public boolean isAllowedOrigin(String requestOrigin) {
        URI requestOriginURI;
        if (this.allowAnyOrigin) {
            return true;
        }
        if (requestOrigin == null) {
            return false;
        }
        try {
            requestOriginURI = new URI(requestOrigin);
        }
        catch (URISyntaxException e) {
            return false;
        }
        String requestScheme = requestOriginURI.getScheme();
        String requestHost = requestOriginURI.getHost();
        int requestPort = requestOriginURI.getPort();
        if (requestScheme == null || requestHost == null) {
            return false;
        }
        for (URI allowedOrigin : this.allowedOrigins) {
            if (!requestHost.equalsIgnoreCase(allowedOrigin.getHost()) && !requestHost.toLowerCase().endsWith("." + allowedOrigin.getHost().toLowerCase()) || requestPort != allowedOrigin.getPort() || !requestScheme.equalsIgnoreCase(allowedOrigin.getScheme())) continue;
            return true;
        }
        return false;
    }
}

