/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.filter;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import java.io.IOException;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import org.hawkular.metrics.model.ApiError;
import org.hawkular.metrics.sysconfig.ConfigurationService;

@Provider
@PreMatching
@Priority(value=20)
public class AdminFilter
implements ContainerRequestFilter {
    public static final String TENANT_HEADER_NAME = "Hawkular-Tenant";
    public static final String ADMIN_TOKEN_HEADER_NAME = "Hawkular-Admin-Token";
    private static final String MISSING_TENANT_MSG = "Tenant is not specified. Use 'Hawkular-Tenant' header.";
    private static final String WRONG_ADMIN_TOKEN_MSG = "Admin token is wrong or not specified.";
    @Inject
    private ConfigurationService configurationService;
    private String savedAdminToken;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        UriInfo uriInfo = requestContext.getUriInfo();
        String path = uriInfo.getPath();
        if (path.startsWith("/tenants")) {
            String tenant = (String)requestContext.getHeaders().getFirst((Object)TENANT_HEADER_NAME);
            if (tenant == null || tenant.trim().isEmpty()) {
                Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new ApiError(MISSING_TENANT_MSG)).build();
                requestContext.abortWith(response);
                return;
            }
            String adminToken = (String)requestContext.getHeaders().getFirst((Object)ADMIN_TOKEN_HEADER_NAME);
            if (adminToken != null && !adminToken.trim().isEmpty() && this.validAdminToken(adminToken)) {
                return;
            }
            Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new ApiError(WRONG_ADMIN_TOKEN_MSG)).build();
            requestContext.abortWith(response);
            return;
        }
    }

    private boolean validAdminToken(String adminToken) {
        if (this.savedAdminToken == null) {
            this.savedAdminToken = (String)this.configurationService.load("org.hawkular.metrics", "admin.token").toBlocking().firstOrDefault((Object)"");
        }
        return (adminToken = Hashing.sha256().newHasher().putString((CharSequence)adminToken, Charsets.UTF_8).hash().toString()).equals(this.savedAdminToken);
    }
}

