/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.handler.transformer;

import org.hawkular.metrics.core.service.MetricsService;
import org.hawkular.metrics.core.service.Order;
import org.hawkular.metrics.model.Metric;
import org.hawkular.metrics.model.MetricId;
import rx.Observable;

public class MinMaxTimestampTransformer<T>
implements Observable.Transformer<Metric<T>, Metric<T>> {
    private final MetricsService metricsService;

    public MinMaxTimestampTransformer(MetricsService metricsService) {
        this.metricsService = metricsService;
    }

    public Observable<Metric<T>> call(Observable<Metric<T>> metricObservable) {
        return metricObservable.flatMap(metric -> {
            long now = System.currentTimeMillis();
            MetricId metricId = metric.getMetricId();
            return this.metricsService.findDataPoints(metricId, 0L, now, 1, Order.ASC).zipWith(this.metricsService.findDataPoints(metricId, 0L, now, 1, Order.DESC), (p1, p2) -> new Metric(metric, p1.getTimestamp(), p2.getTimestamp())).switchIfEmpty(Observable.just((Object)metric));
        });
    }
}

