/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.handler;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import javax.enterprise.context.ApplicationScoped;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.metrics.api.jaxrs.QueryRequest;
import org.hawkular.metrics.api.jaxrs.handler.MetricsServiceHandler;
import org.hawkular.metrics.api.jaxrs.handler.observer.MetricCreatedObserver;
import org.hawkular.metrics.api.jaxrs.handler.observer.ResultSetObserver;
import org.hawkular.metrics.api.jaxrs.handler.template.IMetricsHandler;
import org.hawkular.metrics.api.jaxrs.param.TimeAndSortParams;
import org.hawkular.metrics.api.jaxrs.util.ApiUtils;
import org.hawkular.metrics.core.service.Functions;
import org.hawkular.metrics.core.service.Order;
import org.hawkular.metrics.core.service.transformers.MinMaxTimestampTransformer;
import org.hawkular.metrics.model.ApiError;
import org.hawkular.metrics.model.DataPoint;
import org.hawkular.metrics.model.Metric;
import org.hawkular.metrics.model.MetricId;
import org.hawkular.metrics.model.MetricType;
import org.hawkular.metrics.model.param.TagNames;
import org.hawkular.metrics.model.param.Tags;
import rx.Observable;
import rx.Observer;
import rx.schedulers.Schedulers;

@Path(value="/strings")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(tags={"String"}, description="This resource is experimental and changes may be made to it in subsequent releases that are not backwards compatible.")
@ApplicationScoped
public class StringHandler
extends MetricsServiceHandler
implements IMetricsHandler<String> {
    @Override
    @POST
    @Path(value="/")
    @ApiOperation(value="Create string metric.", notes="Clients are not required to explicitly create a metric before storing data. Doing so however allows clients to prevent naming collisions and to specify tags and data retention.")
    @ApiResponses(value={@ApiResponse(code=201, message="Metric created successfully"), @ApiResponse(code=400, message="Missing or invalid payload", response=ApiError.class), @ApiResponse(code=409, message="String metric with given id already exists", response=ApiError.class), @ApiResponse(code=500, message="Metric creation failed due to an unexpected error", response=ApiError.class)})
    public void createMetric(@Suspended AsyncResponse asyncResponse, @ApiParam(required=true) Metric<String> metric, @ApiParam(value="Overwrite previously created metric configuration if it exists. Only data retention and tags are overwriten; existing data points are unnafected. Defaults to false.") @DefaultValue(value="false") @QueryParam(value="overwrite") Boolean overwrite, @Context UriInfo uriInfo) {
        if (metric.getType() != null && MetricType.UNDEFINED != metric.getType() && MetricType.STRING != metric.getType()) {
            asyncResponse.resume((Object)ApiUtils.badRequest(new ApiError("Metric type does not match " + MetricType.STRING.getText())));
        }
        metric = new Metric(new MetricId(this.getTenant(), MetricType.STRING, metric.getId()), metric.getTags(), metric.getDataRetention());
        URI location = uriInfo.getBaseUriBuilder().path("/strings/{id}").build(new Object[]{metric.getMetricId().getName()});
        this.metricsService.createMetric(metric, overwrite.booleanValue()).subscribe((Observer)new MetricCreatedObserver(asyncResponse, location));
    }

    @Override
    @GET
    @Path(value="/")
    @ApiOperation(value="Find tenant's metric definitions.", notes="Does not include any metric values. ", response=Metric.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully retrieved at least one metric definition."), @ApiResponse(code=204, message="No metrics found."), @ApiResponse(code=400, message="Invalid type parameter type.", response=ApiError.class), @ApiResponse(code=500, message="Failed to retrieve metrics due to unexpected error.", response=ApiError.class)})
    public void getMetrics(@Suspended AsyncResponse asyncResponse, @ApiParam(value="List of tags filters") @QueryParam(value="tags") Tags tags, @ApiParam(value="Fetch min and max timestamps of available datapoints") @DefaultValue(value="false") @QueryParam(value="timestamps") Boolean fetchTimestamps) {
        Observable metricObservable;
        Observable observable = metricObservable = tags == null ? this.metricsService.findMetrics(this.getTenant(), MetricType.STRING) : this.metricsService.findMetricsWithFilters(this.getTenant(), MetricType.STRING, tags.getTags());
        if (fetchTimestamps.booleanValue()) {
            metricObservable = metricObservable.compose((Observable.Transformer)new MinMaxTimestampTransformer(this.metricsService));
        }
        metricObservable.toList().map(ApiUtils::collectionToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> {
            if (t instanceof PatternSyntaxException) {
                asyncResponse.resume((Object)ApiUtils.badRequest(t));
            } else {
                asyncResponse.resume((Object)ApiUtils.serverError(t));
            }
        });
    }

    @Override
    @GET
    @Path(value="/{id}")
    @ApiOperation(value="Retrieve single metric definition.", response=Metric.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Metric's definition was successfully retrieved."), @ApiResponse(code=204, message="Query was successful, but no metrics definition is set."), @ApiResponse(code=500, message="Unexpected error occurred while fetching metric's definition.", response=ApiError.class)})
    public void getMetric(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id) {
        this.metricsService.findMetric(new MetricId(this.getTenant(), MetricType.STRING, id)).compose((Observable.Transformer)new MinMaxTimestampTransformer(this.metricsService)).map(metric -> Response.ok((Object)metric).build()).switchIfEmpty(Observable.just((Object)ApiUtils.noContent())).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.serverError(t)));
    }

    @Override
    @GET
    @Path(value="/tags/{tags}")
    @ApiOperation(value="Retrieve string type's tag values", response=Map.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Tags successfully retrieved."), @ApiResponse(code=204, message="No matching tags were found"), @ApiResponse(code=500, message="Unexpected error occurred while fetching tags.", response=ApiError.class)})
    public void getTags(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Tag query") @PathParam(value="tags") Tags tags) {
        this.metricsService.getTagValues(this.getTenant(), MetricType.STRING, tags.getTags()).map(ApiUtils::mapToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.serverError(t)));
    }

    @Override
    @GET
    @Path(value="/{id}/tags")
    @ApiOperation(value="Retrieve tags associated with the metric definition.", response=Map.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Metric's tags were successfully retrieved."), @ApiResponse(code=204, message="Query was successful, but no metrics were found."), @ApiResponse(code=500, message="Unexpected error occurred while fetching metric's tags.", response=ApiError.class)})
    public void getMetricTags(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id) {
        this.metricsService.getMetricTags(new MetricId(this.getTenant(), MetricType.STRING, id)).map(ApiUtils::mapToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.serverError(t)));
    }

    @Override
    @PUT
    @Path(value="/{id}/tags")
    @ApiOperation(value="Update tags associated with the metric definition.")
    @ApiResponses(value={@ApiResponse(code=200, message="Metric's tags were successfully updated."), @ApiResponse(code=500, message="Unexpected error occurred while updating metric's tags.", response=ApiError.class)})
    public void updateMetricTags(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id, @ApiParam(required=true) Map<String, String> tags) {
        Metric metric = new Metric(new MetricId(this.getTenant(), MetricType.STRING, id));
        this.metricsService.addTags(metric, tags).subscribe((Observer)new ResultSetObserver(asyncResponse));
    }

    @Override
    @DELETE
    @Path(value="/{id}/tags/{tags}")
    @ApiOperation(value="Delete tags associated with the metric definition.")
    @ApiResponses(value={@ApiResponse(code=200, message="Metric's tags were successfully deleted."), @ApiResponse(code=400, message="Invalid tags", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error occurred while trying to delete metric's tags.", response=ApiError.class)})
    public void deleteMetricTags(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id, @ApiParam(value="Tag names", allowableValues="Comma-separated list of tag names") @PathParam(value="tags") TagNames tags) {
        Metric metric = new Metric(new MetricId(this.getTenant(), MetricType.STRING, id));
        this.metricsService.deleteTags(metric, tags.getNames()).subscribe((Observer)new ResultSetObserver(asyncResponse));
    }

    @Override
    @POST
    @Path(value="/{id}/raw")
    @ApiOperation(value="Add data for a single string metric.")
    @ApiResponses(value={@ApiResponse(code=200, message="Adding data succeeded."), @ApiResponse(code=400, message="Missing or invalid payload", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error happened while storing the data", response=ApiError.class)})
    public void addMetricData(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id, @ApiParam(value="List of string datapoints", required=true) List<DataPoint<String>> data) {
        Observable metrics = Functions.dataPointToObservable((String)this.getTenant(), (String)id, data, (MetricType)MetricType.STRING);
        Observable observable = this.metricsService.addDataPoints(MetricType.STRING, metrics);
        observable.subscribe((Observer)new ResultSetObserver(asyncResponse));
    }

    @Override
    @POST
    @Path(value="/raw")
    @ApiOperation(value="Add metric data for multiple string metrics in a single call.")
    @ApiResponses(value={@ApiResponse(code=200, message="Adding data succeeded."), @ApiResponse(code=400, message="Missing or invalid payload", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error happened while storing the data", response=ApiError.class)})
    public void addData(@Suspended AsyncResponse asyncResponse, @ApiParam(value="List of string metrics", required=true) @JsonDeserialize List<Metric<String>> availabilities) {
        Observable metrics = Functions.metricToObservable((String)this.getTenant(), availabilities, (MetricType)MetricType.STRING);
        Observable observable = this.metricsService.addDataPoints(MetricType.STRING, metrics);
        observable.subscribe((Observer)new ResultSetObserver(asyncResponse));
    }

    @Override
    @POST
    @Path(value="/raw/query")
    @ApiOperation(value="Fetch raw data points for multiple metrics. This endpoint is experimental and may undergo non-backwards compatible changes in future releases.")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully fetched metric data points."), @ApiResponse(code=204, message="Query was successful, but no data was found."), @ApiResponse(code=400, message="No metric ids are specified", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error occurred while fetching metric data.", response=ApiError.class)})
    public void getData(@Suspended AsyncResponse asyncResponse, @ApiParam(required=true, value="Query parameters that minimally must include a list of metric ids or tags. The standard start, end, order, and limit query parameters are supported as well.") QueryRequest query) {
        this.findMetricsByNameOrTag(query.getIds(), query.getTags(), MetricType.STRING).toList().flatMap(metricIds -> TimeAndSortParams.deferredBuilder(query.getStart(), query.getEnd()).fromEarliest(query.getFromEarliest(), metricIds, this::findTimeRange).sortOptions(query.getLimit(), query.getOrder()).forString().toObservable().flatMap(p -> this.metricsService.findDataPoints(metricIds, p.getTimeRange().getStart(), p.getTimeRange().getEnd(), p.getLimit(), p.getOrder()).observeOn(Schedulers.io()))).subscribe(this.createNamedDataPointObserver(asyncResponse, MetricType.STRING));
    }

    @GET
    @Path(value="/{id}/raw")
    @ApiOperation(value="Retrieve string data.", response=DataPoint.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully fetched string data."), @ApiResponse(code=204, message="No string data was found."), @ApiResponse(code=500, message="Unexpected error occurred while fetching string data.", response=ApiError.class)})
    public void getMetricData(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id, @ApiParam(value="Defaults to now - 8 hours") @QueryParam(value="start") String start, @ApiParam(value="Defaults to now") @QueryParam(value="end") String end, @ApiParam(value="Use data from earliest received, subject to retention period") @QueryParam(value="fromEarliest") Boolean fromEarliest, @ApiParam(value="Set to true to return only distinct, contiguous values") @QueryParam(value="distinct") @DefaultValue(value="false") Boolean distinct, @ApiParam(value="Limit the number of data points returned") @QueryParam(value="limit") Integer limit, @ApiParam(value="Data point sort order, based on timestamp") @QueryParam(value="order") Order order) {
        MetricId metricId = new MetricId(this.getTenant(), MetricType.STRING, id);
        TimeAndSortParams.deferredBuilder(start, end).fromEarliest(fromEarliest, metricId, this::findTimeRange).sortOptions(limit, order).forString().toObservable().flatMap(p -> this.metricsService.findStringData(metricId, p.getTimeRange().getStart(), p.getTimeRange().getEnd(), distinct.booleanValue(), p.getLimit(), p.getOrder())).toList().map(ApiUtils::collectionToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.error(t)));
    }
}

