/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.swagger;

import io.swagger.converter.ModelConverter;
import io.swagger.converter.ModelConverterContext;
import io.swagger.converter.ModelConverters;
import io.swagger.core.filter.AbstractSpecFilter;
import io.swagger.models.Model;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.function.Supplier;
import org.hawkular.metrics.model.param.Duration;
import org.hawkular.metrics.model.param.Tags;

public class SwaggerFilter
extends AbstractSpecFilter {
    public SwaggerFilter() {
        ModelConverters modelConverters = ModelConverters.getInstance();
        modelConverters.addConverter((ModelConverter)new ParamModelConverter(Tags.class, () -> new StringFormatProperty("tag-list")));
        modelConverters.addConverter((ModelConverter)new ParamModelConverter(Duration.class, () -> new StringFormatProperty("duration")));
    }

    private static class StringFormatProperty
    extends StringProperty {
        public StringFormatProperty(String format) {
            this.setFormat(format);
        }
    }

    private static class ParamModelConverter
    implements ModelConverter {
        private final Class<?> paramClass;
        private final Supplier<Property> propertySupplier;

        public ParamModelConverter(Class<?> paramClass, Supplier<Property> propertySupplier) {
            this.paramClass = paramClass;
            this.propertySupplier = propertySupplier;
        }

        public Property resolveProperty(Type type, ModelConverterContext context, Annotation[] annotations, Iterator<ModelConverter> chain) {
            Class cls;
            if (type instanceof Class && this.paramClass.isAssignableFrom(cls = (Class)type)) {
                return this.propertySupplier.get();
            }
            if (chain.hasNext()) {
                return chain.next().resolveProperty(type, context, annotations, chain);
            }
            return null;
        }

        public Model resolve(Type type, ModelConverterContext context, Iterator<ModelConverter> chain) {
            if (chain.hasNext()) {
                return chain.next().resolve(type, context, chain);
            }
            return null;
        }
    }
}

