/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricRegistry;
import com.datastax.driver.core.Configuration;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.Session;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import org.hawkular.metrics.api.jaxrs.util.MetricRegistryProvider;

@ApplicationScoped
public class DriverUsageMetricsManager {
    public void updateDriverUsageMetrics(Session session) {
        MetricRegistry metricRegistry = MetricRegistryProvider.INSTANCE.getMetricRegistry();
        Session.State state = session.getState();
        Set expectedHosts = state.getConnectedHosts().stream().map(DriverUsageMetric::getHostKey).collect(Collectors.toSet());
        HashSet<String> actualHosts = new HashSet<String>();
        for (String name : metricRegistry.getGauges().keySet()) {
            if (!name.startsWith("driver-usage-")) continue;
            for (DriverUsageMetric driverUsageMetric : DriverUsageMetric.values()) {
                if (!name.endsWith(driverUsageMetric.suffix)) continue;
                int beginIndex = "driver-usage-".length();
                int endIndex = name.length() - driverUsageMetric.suffix.length();
                actualHosts.add(name.substring(beginIndex, endIndex));
            }
        }
        HashSet toRemoveHosts = new HashSet(actualHosts);
        toRemoveHosts.removeAll(expectedHosts);
        toRemoveHosts.forEach(hostkey -> {
            for (DriverUsageMetric metric : DriverUsageMetric.values()) {
                metricRegistry.remove("driver-usage-" + hostkey + metric.suffix);
            }
        });
        HashSet toCreateHosts = new HashSet(expectedHosts);
        toCreateHosts.removeAll(actualHosts);
        state.getConnectedHosts().stream().map(DriverUsageMetric::getHostKey).filter(toCreateHosts::contains).forEach(hostkey -> {
            for (DriverUsageMetric driverUsageMetric : DriverUsageMetric.values()) {
                String metricName = "driver-usage-" + hostkey + driverUsageMetric.suffix;
                Gauge<?> gauge = driverUsageMetric.createGauge(session, (String)hostkey);
                metricRegistry.register(metricName, gauge);
            }
        });
    }

    public void removeDriverUsageMetrics() {
        MetricRegistry metricRegistry = MetricRegistryProvider.INSTANCE.getMetricRegistry();
        metricRegistry.removeMatching((name, metric) -> name.startsWith("driver-usage-"));
    }

    private static enum DriverUsageMetric {
        CONNECTIONS("-connections"){

            @Override
            Gauge<?> createGauge(final Session session, final String hostname) {
                return new Gauge<Integer>(){

                    public Integer getValue() {
                        Session.State state = session.getState();
                        return DriverUsageMetric.getHost(state, hostname).map(arg_0 -> ((Session.State)state).getOpenConnections(arg_0)).orElse(0);
                    }
                };
            }
        }
        ,
        LOAD("-load"){

            @Override
            Gauge<?> createGauge(final Session session, final String hostname) {
                return new Gauge<Integer>(){

                    public Integer getValue() {
                        Session.State state = session.getState();
                        return DriverUsageMetric.getHost(state, hostname).map(arg_0 -> ((Session.State)state).getInFlightQueries(arg_0)).orElse(0);
                    }
                };
            }
        }
        ,
        LOAD_MAX("-load-max"){

            @Override
            Gauge<?> createGauge(final Session session, final String hostname) {
                return new Gauge<Integer>(){

                    public Integer getValue() {
                        Session.State state = session.getState();
                        return DriverUsageMetric.getHost(state, hostname).map(host -> {
                            Configuration configuration = session.getCluster().getConfiguration();
                            PoolingOptions poolingOptions = configuration.getPoolingOptions();
                            HostDistance distance = configuration.getPolicies().getLoadBalancingPolicy().distance(host);
                            int connections = state.getOpenConnections(host);
                            return connections * poolingOptions.getMaxRequestsPerConnection(distance);
                        }).orElse(0);
                    }
                };
            }
        };

        static final String PREFIX = "driver-usage-";
        String suffix;

        static String getHostKey(Host host) {
            return host.getSocketAddress().getHostString() + "_" + host.getSocketAddress().getPort();
        }

        static Optional<Host> getHost(Session.State state, String hostname) {
            return state.getConnectedHosts().stream().filter(h -> DriverUsageMetric.getHostKey(h).equals(hostname)).findFirst();
        }

        private DriverUsageMetric(String suffix) {
            this.suffix = suffix;
        }

        abstract Gauge<?> createGauge(Session var1, String var2);
    }
}

