/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.param;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.hawkular.metrics.api.jaxrs.param.DurationConverter;
import org.hawkular.metrics.api.jaxrs.param.PercentilesConverter;
import org.hawkular.metrics.model.MetricId;
import org.hawkular.metrics.model.Percentile;
import org.hawkular.metrics.model.exception.RuntimeApiError;
import org.hawkular.metrics.model.param.BucketConfig;
import org.hawkular.metrics.model.param.Duration;
import org.hawkular.metrics.model.param.Percentiles;
import org.hawkular.metrics.model.param.TimeRange;
import rx.Observable;
import rx.functions.Func4;

public class TimeAndBucketParams {
    private final TimeRange timeRange;
    private final BucketConfig bucketConfig;
    private final List<Percentile> percentiles;

    private TimeAndBucketParams(TimeRange timeRange, BucketConfig bucketConfig, List<Percentile> percentiles) {
        this.timeRange = timeRange;
        this.bucketConfig = bucketConfig;
        this.percentiles = percentiles;
    }

    public static <T> DeferredBuilder<T> deferredBuilder(String start, String end) {
        return new DeferredBuilder(start, end);
    }

    public TimeRange getTimeRange() {
        return this.timeRange;
    }

    public BucketConfig getBucketConfig() {
        return this.bucketConfig;
    }

    public List<Percentile> getPercentiles() {
        return this.percentiles;
    }

    public static class DeferredBuilder<T> {
        private final String start;
        private final String end;
        private Boolean fromEarliest;
        private List<MetricId<T>> metricIds;
        private Integer bucketsCount;
        private Duration bucketDuration;
        private List<Percentile> percentiles;
        private Func4<String, String, Boolean, Collection<MetricId<T>>, Observable<TimeRange>> findTimeRange;

        private DeferredBuilder(String start, String end) {
            this.start = start;
            this.end = end;
        }

        public DeferredBuilder<T> fromEarliest(Boolean fromEarliest, List<MetricId<T>> metricIds, Func4<String, String, Boolean, Collection<MetricId<T>>, Observable<TimeRange>> findTimeRange) {
            this.fromEarliest = fromEarliest;
            this.metricIds = metricIds;
            this.findTimeRange = findTimeRange;
            return this;
        }

        public DeferredBuilder<T> fromEarliest(Boolean fromEarliest, MetricId<T> metricId, Func4<String, String, Boolean, Collection<MetricId<T>>, Observable<TimeRange>> findTimeRange) {
            this.fromEarliest = fromEarliest;
            this.metricIds = Collections.singletonList(metricId);
            this.findTimeRange = findTimeRange;
            return this;
        }

        public DeferredBuilder<T> bucketConfig(Integer bucketsCount, String bucketDuration) {
            this.bucketsCount = bucketsCount;
            this.bucketDuration = bucketDuration == null ? null : new DurationConverter().fromString(bucketDuration);
            return this;
        }

        public DeferredBuilder<T> bucketConfig(Integer bucketsCount, Duration bucketDuration) {
            this.bucketsCount = bucketsCount;
            this.bucketDuration = bucketDuration;
            return this;
        }

        public DeferredBuilder<T> percentiles(String percentiles) {
            this.percentiles = percentiles == null ? Collections.emptyList() : new PercentilesConverter().fromString(percentiles).getPercentiles();
            return this;
        }

        public DeferredBuilder<T> percentiles(Percentiles percentiles) {
            this.percentiles = percentiles == null ? Collections.emptyList() : percentiles.getPercentiles();
            return this;
        }

        public Observable<TimeAndBucketParams> toObservable() {
            if (this.bucketsCount == null && this.bucketDuration == null) {
                return Observable.error((Throwable)new RuntimeApiError("Either the buckets or bucketDuration parameter must be used"));
            }
            return ((Observable)this.findTimeRange.call((Object)this.start, (Object)this.end, (Object)this.fromEarliest, this.metricIds)).map(tr -> {
                BucketConfig bucketConfig = new BucketConfig(this.bucketsCount, this.bucketDuration, tr);
                if (!bucketConfig.isValid()) {
                    throw new RuntimeApiError(bucketConfig.getProblem());
                }
                return new TimeAndBucketParams((TimeRange)tr, bucketConfig, this.percentiles);
            });
        }
    }
}

