/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.handler;

import io.swagger.annotations.ApiOperation;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.hawkular.metrics.api.jaxrs.MetricsServiceLifecycle;
import org.hawkular.metrics.api.jaxrs.util.ManifestInformation;
import org.hawkular.metrics.model.Status;

@Path(value="/admin")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ApplicationScoped
public class AdminHandler {
    @Inject
    MetricsServiceLifecycle metricsServiceLifecycle;
    @Inject
    ManifestInformation manifestInformation;

    @GET
    @Path(value="status")
    @ApiOperation(value="Returns the current status for various components.", response=Map.class)
    public Response status(@Context ServletContext servletContext) {
        Status status = new Status();
        MetricsServiceLifecycle.State metricState = this.metricsServiceLifecycle.getState();
        status.setMetricsServiceStatus(this.metricsServiceLifecycle.getState().toString());
        Map<String, String> manifestInfo = this.manifestInformation.getAttributes();
        status.setImplementationVersion(manifestInfo.get("Implementation-Version"));
        status.setGitSHA(manifestInfo.get("Built-From-Git-SHA1"));
        status.setCassandraStatus(this.metricsServiceLifecycle.getCassandraStatus());
        return Response.ok((Object)status).build();
    }
}

