/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.EnumMap;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import org.hawkular.metrics.api.jaxrs.config.Configurable;
import org.hawkular.metrics.api.jaxrs.config.ConfigurationKey;
import org.hawkular.metrics.api.jaxrs.config.ConfigurationProperty;

@ApplicationScoped
public class ConfigurableProducer {
    static final String METRICS_CONF = "metrics.conf";
    private EnumMap<ConfigurationKey, String> effectiveConfig;

    @PostConstruct
    void init() {
        this.effectiveConfig = new EnumMap(ConfigurationKey.class);
        Properties configFileProperties = new Properties();
        File configurationFile = this.findConfigurationFile();
        if (configurationFile != null) {
            this.load(configFileProperties, configurationFile);
        }
        for (ConfigurationKey configKey : ConfigurationKey.values()) {
            String name = configKey.toString();
            String envName = configKey.toEnvString();
            String value = System.getProperty(name);
            if (value == null && envName != null) {
                value = System.getenv(envName);
            }
            if (value == null) {
                value = configFileProperties.getProperty(name);
            }
            if (configKey.isFlag()) {
                this.effectiveConfig.put(configKey, String.valueOf(value != null));
                continue;
            }
            this.effectiveConfig.put(configKey, value != null ? value : configKey.defaultValue());
        }
    }

    @Produces
    @Configurable
    String getConfigurationPropertyAsString(InjectionPoint injectionPoint) {
        ConfigurationProperty configProp = (ConfigurationProperty)injectionPoint.getAnnotated().getAnnotation(ConfigurationProperty.class);
        if (configProp == null) {
            String message = "Any field or parameter annotated with @" + Configurable.class.getSimpleName() + " must also be annotated with @" + ConfigurationProperty.class.getSimpleName();
            throw new IllegalArgumentException(message);
        }
        return this.effectiveConfig.get(configProp.value());
    }

    private File findConfigurationFile() {
        String configurationFilePath = System.getProperty(METRICS_CONF);
        if (configurationFilePath != null) {
            File file = new File(configurationFilePath);
            this.checkExplicitConfigurationFile(file);
            return file;
        }
        File file = new File(System.getProperty("user.home"), ".metrics.conf");
        if (!file.exists()) {
            return null;
        }
        this.checkConfigurationFile(file);
        return file;
    }

    private void checkExplicitConfigurationFile(File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException(file + " does not exist");
        }
        this.checkConfigurationFile(file);
    }

    private void checkConfigurationFile(File file) {
        if (!file.isFile()) {
            throw new IllegalArgumentException(file + " is not a regular file");
        }
        if (!file.canRead()) {
            throw new IllegalArgumentException(file + " is not readable");
        }
    }

    private void load(Properties properties, File file) {
        try (FileInputStream input = new FileInputStream(file);){
            properties.load(input);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

