/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.dropwizard;

import com.codahale.metrics.Timer;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import org.hawkular.metrics.api.jaxrs.dropwizard.HTTPMethod;
import org.hawkular.metrics.api.jaxrs.dropwizard.RESTMetricName;
import org.hawkular.metrics.api.jaxrs.dropwizard.RESTMetrics;
import org.jboss.logging.Logger;

@Provider
public class RecordMetricsFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static Logger logger = Logger.getLogger(RecordMetricsFilter.class);
    @Inject
    private RESTMetrics restMetrics;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String path = this.getPath(requestContext.getUriInfo());
        HTTPMethod method = HTTPMethod.fromString(requestContext.getMethod());
        RESTMetricName metricName = new RESTMetricName(method, path);
        Timer timer = this.restMetrics.getTimer(metricName.getName());
        if (timer != null) {
            Timer.Context context = timer.time();
            requestContext.setProperty("timerContext", (Object)context);
        }
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        Timer.Context context = (Timer.Context)requestContext.getProperty("timerContext");
        if (context != null) {
            context.stop();
        }
    }

    private String getPath(UriInfo uriInfo) {
        MultivaluedMap pathParameters = uriInfo.getPathParameters(true);
        Map valuesToParams = pathParameters.entrySet().stream().map(entry -> ((List)entry.getValue()).stream().collect(Collectors.toMap(Function.identity(), value -> "{" + (String)entry.getKey() + "}"))).reduce(new HashMap(), (m1, m2) -> {
            m1.putAll(m2);
            return m1;
        });
        return uriInfo.getPathSegments(true).stream().map(PathSegment::getPath).map(path -> {
            if (valuesToParams.containsKey(path)) {
                return (String)valuesToParams.get(path);
            }
            return path;
        }).collect(Collectors.joining("/"));
    }
}

